package org.nuiton.jaxx.demo.component.jaxx.editor;

/*-
 * #%L
 * JAXX :: Demo
 * %%
 * Copyright (C) 2008 - 2016 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jaxx.demo.DemoPanel;
import org.nuiton.jaxx.demo.entities.People;
import org.nuiton.jaxx.runtime.JAXXContext;
import org.nuiton.jaxx.runtime.JAXXObjectDescriptor;
import org.nuiton.jaxx.runtime.JAXXUtil;
import org.nuiton.jaxx.runtime.swing.Table;
import org.nuiton.jaxx.runtime.swing.editor.bean.BeanDoubleList;

public class BeanDoubleListDemo extends DemoPanel {

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAJ1UzU4UQRCuXdwFFnQRfxIvhgQQDTCjNxP8hQ1RsoIBDsS92DvT7DTOdrfdPe5w4eDBmy/gwasXwzsQTyZevPIOJjyC1bPDLuDOok4yPZPqr77+qqqrvv6CglYwJ1TD4REzgjs7JI4dFXHDmtRZebq1tVbfoZ6pUO0pJo1Q0H5yecjXYMTv2LUBp1ZFJrfN5FomN2Vyl0RTCk75CaKFKpS02Q2pDig1Bm5nOntauxsd5EIsI5We1VN1r7N+fLh3mKOVT3mAWKL8YQx79h8IulFfqEKe+QbGqzvkHXFDwhsoTjHewIAuWttSSLReJU36FvZgsApFSRSSGZj/r/QkdAlVLA2MTFVoU7wknIZ3DTw8G4KPm453zNa2UR/3lbNICa+IqB7SKtPGskiZ8BYNDE5tEtxAxsmspOgWhugkMOs03PEd9wTfZo1IEcMET5Sh0SYiTp1WEqOFj3a8xrZZaKiydIuRwdMMXDvlsxRQ782iiC2+3HG7EbBGEOJrlhP/TRqbtr8FXD0NLutAtNapptmQKxZSoZ5A9UJlw9pq1/gq8QKRCSv5nfwauN8/k2lV6liVM6VJE6XgVhYDNoTTbYju3czVoKAiNGMds3vRttM6otqNNJndSPaYBPh+f099aR0dHnfPAIqbOM/rxKDAqyyVkFQZZrWV260TGRa6L4hcqGE70hCnTDJFZvor30iRqB5VXLZMjmVynhEdIFth8PDg2/XXPwcgvwylUBB/mVj8cxg2gcKMidCP5eMnibjR1hCuY1amgWJIdgWWFi498IkhE3XGfazUoxizNNM/Sx1R+2tH3z9/nD44zlQONU79jWc3W4VXUGQ8ZJwmkyYdIj0ny4jUNPJFd0L0mhk5+y3JtNmnk/XOn/Fb86xd5uLIfuYT9fbPTfbGzmUwMGRv8+aupH14biLPb3NyTJ14BgAA";
    private static final Log log = LogFactory.getLog(BeanDoubleListDemo.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel configurationPanel;
    protected BeanDoubleList<People> doubleList;
    protected JCheckBox filterOnNachoButton;
    protected JCheckBox filterableButton;
    protected BeanDoubleListDemoHandler handler;
    protected JCheckBox highlightFilterTextButton;
    protected JCheckBox showDecoratorButton;
    protected JCheckBox showResetButton;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private BeanDoubleListDemo $DemoPanel0;
    private Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public BeanDoubleListDemo(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public BeanDoubleListDemo(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public BeanDoubleListDemo(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public BeanDoubleListDemo(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public BeanDoubleListDemo() {
        $initialize();
    }

    public BeanDoubleListDemo(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public BeanDoubleListDemo(boolean param0) {
        super(param0);
        $initialize();
    }

    public BeanDoubleListDemo(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JPanel getConfigurationPanel() {
        return configurationPanel;
    }

    public BeanDoubleList<People> getDoubleList() {
        return doubleList;
    }

    public JCheckBox getFilterOnNachoButton() {
        return filterOnNachoButton;
    }

    public JCheckBox getFilterableButton() {
        return filterableButton;
    }

    public BeanDoubleListDemoHandler getHandler() {
        return handler;
    }

    public JCheckBox getHighlightFilterTextButton() {
        return highlightFilterTextButton;
    }

    public JCheckBox getShowDecoratorButton() {
        return showDecoratorButton;
    }

    public JCheckBox getShowResetButton() {
        return showResetButton;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToConfigurationPanel() {
        configurationPanel.add(filterableButton);
        configurationPanel.add(highlightFilterTextButton);
        configurationPanel.add(showResetButton);
        configurationPanel.add(showDecoratorButton);
        configurationPanel.add(filterOnNachoButton);
    }

    protected void createConfigurationPanel() {
        $objectMap.put("configurationPanel", configurationPanel = new JPanel());
        
        configurationPanel.setName("configurationPanel");
        configurationPanel.setLayout(new GridLayout(0,1));
    }

    protected void createDoubleList() {
        $objectMap.put("doubleList", doubleList = new BeanDoubleList<People>());
        
        doubleList.setName("doubleList");
    }

    protected void createFilterOnNachoButton() {
        $objectMap.put("filterOnNachoButton", filterOnNachoButton = new JCheckBox());
        
        filterOnNachoButton.setName("filterOnNachoButton");
    }

    protected void createFilterableButton() {
        $objectMap.put("filterableButton", filterableButton = new JCheckBox());
        
        filterableButton.setName("filterableButton");
    }

    protected void createHighlightFilterTextButton() {
        $objectMap.put("highlightFilterTextButton", highlightFilterTextButton = new JCheckBox());
        
        highlightFilterTextButton.setName("highlightFilterTextButton");
    }

    protected void createShowDecoratorButton() {
        $objectMap.put("showDecoratorButton", showDecoratorButton = new JCheckBox());
        
        showDecoratorButton.setName("showDecoratorButton");
    }

    protected void createShowResetButton() {
        $objectMap.put("showResetButton", showResetButton = new JCheckBox());
        
        showResetButton.setName("showResetButton");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    protected void $initialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $DemoPanel0 = this;
        handler = new BeanDoubleListDemoHandler();
        handler.beforeInit(this);
        super.$initialize();
        handler.afterInit(this);
    }

    @Override
    protected void $initialize_01_createComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_01_createComponents();
        $objectMap.put("$DemoPanel0", $DemoPanel0);
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        createConfigurationPanel();
        createFilterableButton();
        createHighlightFilterTextButton();
        createShowResetButton();
        createShowDecoratorButton();
        createFilterOnNachoButton();
        createDoubleList();
        // inline creation of $DemoPanel0
        setName("$DemoPanel0");
        setLayout(new BorderLayout());
    }

    @Override
    protected void $initialize_02_registerDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_02_registerDataBindings();
        // register 0 data bindings
    }

    @Override
    protected void $initialize_03_finalizeCreateComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_03_finalizeCreateComponents();
        // inline complete setup of $DemoPanel0
        add($Table0);
        // inline complete setup of $Table0
        $Table0.add(configurationPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(doubleList, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        addChildrenToConfigurationPanel();
    }

    @Override
    protected void $initialize_04_applyDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_04_applyDataBindings();
    }

    @Override
    protected void $initialize_05_setProperties() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_05_setProperties();
        
        // apply 3 property setters
        doubleList.setBeanType(People.class);
    }

    @Override
    protected void $initialize_06_finalizeInitialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_06_finalizeInitialize();
    }

}