package org.nuiton.jaxx.demo.component.jaxx;

/*-
 * #%L
 * JAXX :: Demo
 * %%
 * Copyright (C) 2008 - 2016 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.ButtonModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jaxx.demo.DemoPanel;
import org.nuiton.jaxx.runtime.JAXXContext;
import org.nuiton.jaxx.runtime.JAXXObjectDescriptor;
import org.nuiton.jaxx.runtime.JAXXUtil;
import org.nuiton.jaxx.runtime.SwingUtil;
import org.nuiton.jaxx.runtime.binding.DefaultJAXXBinding;
import org.nuiton.jaxx.runtime.swing.BlockingLayerUI;
import org.nuiton.jaxx.runtime.swing.BlockingLayerUI2;
import org.nuiton.jaxx.runtime.swing.Table;
import static org.nuiton.i18n.I18n.t;

public class BoxedDecoratorDemo extends DemoPanel {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_TOGGLE_TEXT = "toggle.text";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAJ1UTU8TQRieVvpBAUWM6MWEhCom6q5igjEgStsQIasY0YTYi9PdSbsw3RlnZmW5cPDgzT/gwasXw38gnky8eOU/mPATfGd2aSnZFrCH3e3M8z77vM/O8/74i3JSoLtMNK0g9BULrE0cRZYIA+W3ibW6tLGx1tgkrqoR6QqfKyZQ/MtkUbaORrzOulTIqjvAZMdMtmayEya7ytqcBSQ4RjTvoJJUO5TIFiFKodt9i10p7fUOcj7ioUjelao67V2/Pz84yJDa1yxCEQf5o9D2nXMQdLseclDW9xSacDbxR2xTHDRBnPCDJjQ0pteqFEv5ErfJB7SLCg7KcyyATKF7/2WPoTNUEVdopFwjbfYKB4TeV2juZAsebFruEVu8VmER8WrEZQIDry7n3BDmFSpQvEPE2xUQ188NuQ29WRXK3C14cGJ8l6GYMMzC9z8XxewxFeU3uEEJNDQ9mMLAdNFwpzavWLNJiUJXtfdRAlyttoi7BZ1r1EQHXGqECqi1ffAFewqMpb3oQoxeUuhKD7RiljXo+klsRf+9kbpV7b9VS9kaK6+uu4JRqoWBM9d6JHS3eiUX20RK3CSQxss9BY4vlcaUOZz8W/1chqRZ3aR1D32mjnIipJp2un/IdU5fAypO6HT/hOrXGOCnvV3xffvw4CiWehpNnVZ1bAJBRrhgnAjla22X4kyGyqf2C8zn62hYEgrjy4ynmcHK1xMkqAcVxj1LM1nPsWwBW65wsP9z8v2fCyi7jEqUYW8Za/wKGlYtAY4x6kX86TMjbnS7CNdxLROOKESEwYdGFxc8rPBUww88+CiLEbg0M9iljqi9tcNf377c3D9yKgMay2ep7LqVe4fyfkD9gJgRlkyn1JE1wiUJPdYdPWnDKKPvJZ7E2DbXh2n9j2LXJVwtucqPYzMXhfr2yPShnx4brrFTufTykwEM42dQU4yPBNEzfCH2YwormOCQRbKYzjt5Bt4hRSI1QJvm+AcozhJpcQcAAA==";
    private static final Log log = LogFactory.getLog(BoxedDecoratorDemo.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton buttonA;
    protected JButton buttonB;
    protected JButton buttonC;
    protected JButton buttonD;
    protected JPanel buttonPane;
    protected BlockingLayerUI layerUI;
    protected BlockingLayerUI2 layerUI2;
    protected JList messages;
    protected JCheckBox toggle;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private BoxedDecoratorDemo $DemoPanel0;
    private JScrollPane $JScrollPane0;
    private Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    void $afterCompleteSetup() {
        for (JComponent boxed : SwingUtil.getLayeredComponents(this)) {
            if (boxed == buttonD) {
                SwingUtil.setLayerUI(boxed, layerUI2);
                continue;
            }
    
            BlockingLayerUI ui = layerUI.clone();
            if (boxed == buttonC) {
                ui.setBlock(true);
            }
            SwingUtil.setLayerUI(boxed, ui);
        }
    }
    
    public void setLayer(boolean active) {
        for (JComponent boxed : SwingUtil.getLayeredComponents(this)) {
            if (boxed == buttonD) {
                continue;
            }
            BlockingLayerUI ui = (BlockingLayerUI) SwingUtil.getLayer(boxed).getUI();
            if (boxed == buttonC) {
                ui.setBlock(active);
            } 
            ui.setUseIcon(active);
        }
    }
    
    protected void accept(ActionEvent e, String suffix) {
        JButton source = (JButton) e.getSource();
        String clickedMessage = (String) source.getClientProperty("clickedText");
        String msg = "'" + source.getText() + "' clicked - " + suffix + " : " + clickedMessage;
        ((DefaultListModel)messages.getModel()).addElement(msg);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public BoxedDecoratorDemo(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public BoxedDecoratorDemo(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public BoxedDecoratorDemo(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public BoxedDecoratorDemo(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public BoxedDecoratorDemo() {
        $initialize();
    }

    public BoxedDecoratorDemo(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public BoxedDecoratorDemo(boolean param0) {
        super(param0);
        $initialize();
    }

    public BoxedDecoratorDemo(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__buttonA(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        accept(event, "from button (no layer)");
    }

    public void doActionPerformed__on__buttonB(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        accept(event, "from button (no layer)");
    }

    public void doActionPerformed__on__buttonC(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        accept(event, "from button (no layer)");
    }

    public void doActionPerformed__on__buttonD(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        accept(event, "from button (no layer)");
    }

    public void doActionPerformed__on__toggle(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        setLayer(toggle.isSelected());
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JButton getButtonA() {
        return buttonA;
    }

    public JButton getButtonB() {
        return buttonB;
    }

    public JButton getButtonC() {
        return buttonC;
    }

    public JButton getButtonD() {
        return buttonD;
    }

    public JPanel getButtonPane() {
        return buttonPane;
    }

    public BlockingLayerUI getLayerUI() {
        return layerUI;
    }

    public BlockingLayerUI2 getLayerUI2() {
        return layerUI2;
    }

    public JList getMessages() {
        return messages;
    }

    public JCheckBox getToggle() {
        return toggle;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToButtonPane() {
        buttonPane.add(SwingUtil.boxComponentWithJxLayer(buttonA));
        buttonPane.add(SwingUtil.boxComponentWithJxLayer(buttonB));
        buttonPane.add(SwingUtil.boxComponentWithJxLayer(buttonC));
        buttonPane.add(SwingUtil.boxComponentWithJxLayer(buttonD));
    }

    protected void createButtonA() {
        $objectMap.put("buttonA", buttonA = new JButton());
        
        buttonA.setName("buttonA");
        buttonA.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__buttonA"));
        buttonA.putClientProperty("clickedText", "button A was clicked");
    }

    protected void createButtonB() {
        $objectMap.put("buttonB", buttonB = new JButton());
        
        buttonB.setName("buttonB");
        buttonB.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__buttonB"));
    }

    protected void createButtonC() {
        $objectMap.put("buttonC", buttonC = new JButton());
        
        buttonC.setName("buttonC");
        buttonC.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__buttonC"));
    }

    protected void createButtonD() {
        $objectMap.put("buttonD", buttonD = new JButton());
        
        buttonD.setName("buttonD");
        buttonD.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__buttonD"));
    }

    protected void createButtonPane() {
        $objectMap.put("buttonPane", buttonPane = new JPanel());
        
        buttonPane.setName("buttonPane");
    }

    protected void createLayerUI() {
        $objectMap.put("layerUI", layerUI = new BlockingLayerUI());
    }

    protected void createLayerUI2() {
        $objectMap.put("layerUI2", layerUI2 = new BlockingLayerUI2());
    }

    protected void createMessages() {
        $objectMap.put("messages", messages = new JList());
        
        messages.setName("messages");
    }

    protected void createToggle() {
        $objectMap.put("toggle", toggle = new JCheckBox());
        
        toggle.setName("toggle");
        toggle.setSelected(true);
        toggle.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__toggle"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    protected void $initialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $DemoPanel0 = this;
        super.$initialize();
    }

    @Override
    protected void $initialize_01_createComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_01_createComponents();
        $objectMap.put("$DemoPanel0", $DemoPanel0);
        createLayerUI();
        createLayerUI2();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        createToggle();
        createButtonPane();
        createButtonA();
        createButtonB();
        createButtonC();
        createButtonD();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createMessages();
        // inline creation of $DemoPanel0
        setName("$DemoPanel0");
        setLayout(new BorderLayout());
    }

    @Override
    protected void $initialize_02_registerDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_02_registerDataBindings();
        // register 1 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TOGGLE_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (toggle != null) {
                    $bindingSources.put("toggle.getModel()", toggle.getModel());
                    toggle.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u0"));
                    toggle.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.component.jaxx.BoxedDecoratorDemo.this, BINDING_TOGGLE_TEXT));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (toggle != null) {
                    toggle.setText(t(toggle.isSelected() ? "Active layer" : "No layer"));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (toggle != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("toggle.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u0"));
                    }
                    toggle.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(org.nuiton.jaxx.demo.component.jaxx.BoxedDecoratorDemo.this, BINDING_TOGGLE_TEXT));
                }
            }
        
            public void $pr$u0(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
    }

    @Override
    protected void $initialize_03_finalizeCreateComponents() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_03_finalizeCreateComponents();
        // inline complete setup of $DemoPanel0
        add($Table0, BorderLayout.CENTER);
        // inline complete setup of $Table0
        $Table0.add(toggle, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(buttonPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.5, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JScrollPane0, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.5, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        addChildrenToButtonPane();
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(messages);
    }

    @Override
    protected void $initialize_04_applyDataBindings() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_04_applyDataBindings();
        
        // apply 1 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
    }

    @Override
    protected void $initialize_05_setProperties() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_05_setProperties();
        
        // apply 3 property setters
        layerUI.setAcceptAction(new AbstractAction() {                      private static final long serialVersionUID = 1L;                      @Override                      public void actionPerformed(ActionEvent e) {                         accept(e, "from icon of layer");                      }                      });
        layerUI2.setAcceptAction(new AbstractAction() {                      private static final long serialVersionUID = 1L;                      @Override                      public void actionPerformed(ActionEvent e) {                         accept(e, "from icon of layer");                      }                      });
    }

    @Override
    protected void $initialize_06_finalizeInitialize() {
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        super.$initialize_06_finalizeInitialize();
    }

}