/*
 * #%L
 * JAXX :: Compiler
 * 
 * $Id: JListHandler.java 1873 2010-05-04 19:48:38Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/jaxx/tags/jaxx-2.2.2/jaxx-compiler/src/main/java/jaxx/compiler/tags/swing/JListHandler.java $
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

package jaxx.compiler.tags.swing;

import jaxx.compiler.CompilerException;
import jaxx.compiler.JAXXCompiler;
import jaxx.compiler.reflect.ClassDescriptor;
import jaxx.compiler.reflect.ClassDescriptorHelper;
import jaxx.compiler.tags.DefaultComponentHandler;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

import java.io.IOException;
import javax.swing.event.ListSelectionListener;
import javax.swing.JList;

public class JListHandler extends DefaultComponentHandler {

    public JListHandler(ClassDescriptor beanClass) {
        super(beanClass);
        ClassDescriptorHelper.checkSupportClass(getClass(), beanClass, JList.class);
    }

    @Override
    protected void configureProxyEventInfo() {
        super.configureProxyEventInfo();
        addProxyEventInfo("getSelectedIndex", ListSelectionListener.class, "selectionModel");
        addProxyEventInfo("getSelectedIndices", ListSelectionListener.class, "selectionModel");
        addProxyEventInfo("getSelectedValue", ListSelectionListener.class, "selectionModel");
        addProxyEventInfo("getSelectedValues", ListSelectionListener.class, "selectionModel");
    }

    @Override
    public void compileChildrenSecondPass(Element tag, JAXXCompiler compiler) throws CompilerException, IOException {
        NodeList children = tag.getChildNodes();
        if (children.getLength() > 0) {
            compiler.reportError("JList does not accept childs");
            throw new CompilerException("JList does not accept childs");
        }
    }
}



