package jaxx.compiler;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

/**
 * A usefull class to generate Ids.
 * <p/>
 * Created: 27 nov. 2009
 *
 * @author Tony Chemit <chemit@codelutin.com> Copyright Code Lutin
 * @version $Revision: 1673 $
 *          <p/>
 *          Mise a jour: $Date: 2009-12-02 14:59:28 +0100 (mer., 02 déc. 2009) $ par :
 *          $Author: tchemit $
 */
public class IDHelper {
    /**
     * Logger
     */
    protected static final Log log = LogFactory.getLog(IDHelper.class);
    /**
     * Counter by type
     */
    protected final Map<String, Integer> autoGenIds = new TreeMap<String, Integer>();
    /**
     * Maps of uniqued id for objects used in compiler
     */
    protected final Map<Object, String> uniqueIds = new HashMap<Object, String>();
    /**
     * Optimized Counter
     */
    protected int optimizedAutogenId = 0;

    /**
     * Flag to use optimized id
     */
    protected final boolean optimize;

    public IDHelper(boolean optimize) {
        this.optimize = optimize;
    }

    public String nextId(String name) {

        if (optimize) {
            return "$" + Integer.toString(optimizedAutogenId++, 36);
        }

        Integer integer = autoGenIds.get(name);

        if (integer == null) {
            integer = 0;
        }
        name = name.substring(name.lastIndexOf(".") + 1);
        String result = "$" + name + integer;
        autoGenIds.put(name, ++integer);
        if (log.isTraceEnabled()) {
            log.trace("new id = " + result);
        }
        return result;
    }

    public void revertId(String name) {
        if (optimize) {
            optimizedAutogenId--;
        } else {
            name = name.substring(name.lastIndexOf(".") + 1);
            Integer integer = autoGenIds.get(name);
            if (integer != null) {
                autoGenIds.put(name, --integer);
            }
        }
    }

    public String getUniqueId(Object object) {
        String result = uniqueIds.get(object);
        if (result == null) {
            result = "$u" + uniqueIds.size();
            uniqueIds.put(object, result);
        }
        if (log.isTraceEnabled()) {
            log.trace("new uniqueid = " + result);
        }
        return result;
    }

    public void clear() {
        autoGenIds.clear();
        uniqueIds.clear();
    }
}
