package org.nuiton.jaxx.application;

/*
 * #%L
 * JAXX :: Application API
 * %%
 * Copyright (C) 2008 - 2014 Code Lutin, Tony Chemit
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import com.google.common.base.Preconditions;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.nuiton.jaxx.application.bean.JavaBeanObjectUtil;

import java.util.Date;

/**
 * Useful methods on data.
 *
 * TODO Needs some javadoc.
 *
 * Created on 11/24/13.
 *
 * @author Tony Chemit - dev@tchemit.fr
 * @since 2.8
 * @deprecated since 2.12, will not be replaced.
 */
@Deprecated
public class ApplicationDataUtil {

    /**
     * @deprecated since 2.12, prefer use {@link JavaBeanObjectUtil#setProperty(Object, String, Object)}
     */
    @Deprecated
    public static void setProperty(Object bean, String property, Object value) {
        Preconditions.checkNotNull(bean);
        Preconditions.checkNotNull(property);
        try {
            PropertyUtils.setSimpleProperty(bean, property, value);
        } catch (Exception e) {
            throw new ApplicationTechnicalException(String.format("Property %1s not found on object of type %2s", property, bean.getClass().getName()), e);
        }
    }

    /**
     * @deprecated since 2.12, prefer use {@link JavaBeanObjectUtil#getProperty(Object, String)})
     */
    @Deprecated
    public static Object getProperty(Object bean, String property) {
        Preconditions.checkNotNull(bean);
        Preconditions.checkNotNull(property);
        try {
            return PropertyUtils.getSimpleProperty(bean, property);
        } catch (Exception e) {
            throw new ApplicationTechnicalException(String.format("Property %1s not found on object of type %2s", property, bean.getClass().getName()), e);
        }
    }

    public static String getDuration(Date startDate,
                                     Date endDate,
                                     String format) {
        String duration = "";
        if (startDate != null && endDate != null && !startDate.after(endDate)) {
            duration = DurationFormatUtils.formatPeriod(
                    startDate.getTime(),
                    endDate.getTime(),
                    format);
        }
        return duration;
    }
}
