/*
 * #%L
 * I18n :: Maven Plugin
 * 
 * $Id: Parser.java 1782 2010-10-25 07:57:22Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/i18n/tags/i18n-2.0/maven-i18n-plugin/src/main/java/org/nuiton/i18n/plugin/parser/Parser.java $
 * %%
 * Copyright (C) 2007 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

package org.nuiton.i18n.plugin.parser;

import java.io.File;
import java.io.IOException;

/**
 * Interface type pour la définition d'un nouveau parser.
 * <p/>
 * Une implantation abstraite est proposée : {@link AbstractI18nParserMojo}.
 *
 * @author julien
 * @deprecated since 1.2, use now {@link FileParser} api, which is
 *             multi-thread
 */
@Deprecated
public interface Parser {

    /**
     * Lancement du parser
     *
     * @throws IOException if any io pb
     */
    void parse() throws IOException;

    /**
     * Parse sur un fichier
     *
     * @param file le fichier à parser
     * @throws IOException if any pb
     */
    void parseFile(File file) throws IOException;

    /**
     * Parse une partie du fichier
     *
     * @param file le fichier à parser
     * @param line la ligne à parser
     * @throws IOException if any pb
     */
    void parseLine(File file, String line) throws IOException;

}
