/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.i18n.plugin.bundle;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.plexus.component.annotations.Component;
import org.nuiton.i18n.plugin.bundle.BundleFormatConverter;

@Component(role=BundleFormatConverter.class, hint="toMessageFormat")
public class StringFormatToMessageFormatConverter
implements BundleFormatConverter {
    private static final Log log = LogFactory.getLog(StringFormatToMessageFormatConverter.class);
    protected static Pattern PATTERN = Pattern.compile("%\\$?(\\d?)[^\\s']*");

    @Override
    public String convert(String value) {
        String result;
        Matcher matcher = PATTERN.matcher(value);
        boolean matches = matcher.find();
        if (log.isDebugEnabled()) {
            log.debug((Object)("> value : " + value + " _ matches ? " + matches));
        }
        if (matches) {
            matcher.reset();
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (matcher.find()) {
                String argNumber;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("> match group : " + matcher.group(0)));
                    log.debug((Object)("> match group for number : " + matcher.group(1)));
                }
                int nb = StringUtils.isNotEmpty((CharSequence)(argNumber = matcher.group(1))) ? Integer.parseInt(argNumber) - 1 : i;
                matcher.appendReplacement(sb, "\\{" + nb + "\\}");
                ++i;
            }
            matcher.appendTail(sb);
            result = sb.toString();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Result : " + result));
            }
        } else {
            result = value;
        }
        result = this.escapeQuoteChar(result);
        return result;
    }

    protected String escapeQuoteChar(String value) {
        String result = value.replaceAll("'", "''");
        if (log.isDebugEnabled()) {
            log.debug((Object)("Result with ' escape : " + result));
        }
        return result;
    }
}

