/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugene.java;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.eugene.java.AbstractJavaBeanTransformer;
import org.nuiton.eugene.java.JavaTemplatesStereoTypes;
import org.nuiton.eugene.models.object.ObjectModel;
import org.nuiton.eugene.models.object.ObjectModelAttribute;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.eugene.models.object.ObjectModelElement;
import org.nuiton.eugene.models.object.ObjectModelInterface;
import org.nuiton.eugene.models.object.ObjectModelJavaModifier;
import org.nuiton.eugene.models.object.ObjectModelModifier;
import org.nuiton.eugene.models.object.ObjectModelOperation;
import org.nuiton.eugene.models.object.ObjectModelPackage;
import org.nuiton.util.beans.Binder;
import org.nuiton.util.beans.BinderFactory;

public class SimpleJavaBeanTransformer
extends AbstractJavaBeanTransformer {
    private static final Log log = LogFactory.getLog(SimpleJavaBeanTransformer.class);

    public void transformFromModel(ObjectModel model) {
        String className = model.getName() + "BeanFactory";
        if (this.canGenerateFactory(model, className)) {
            this.generateBeanFactory(model, className);
        }
    }

    public void transformFromClass(ObjectModelClass input) {
        ObjectModelPackage aPackage = this.getPackage((ObjectModelClassifier)input);
        if (!JavaTemplatesStereoTypes.hasBeanStereotype((ObjectModelClassifier)input, aPackage)) {
            return;
        }
        String interfaceName = this.getBeanInterfaceName(aPackage, input);
        String abstractClassName = this.getAbstractBeanClassName(aPackage, input);
        String className = this.getBeanClassName(aPackage, input);
        String defaultClassName = this.getBeanDefaultsClassName(aPackage, input);
        boolean generateDefaults = this.canGenerateBeanDefaults(aPackage, input);
        boolean generateInterface = this.canGenerateInterface(aPackage, input, interfaceName);
        boolean generateAbstractClass = this.canGenerateAbstractBean(input, abstractClassName);
        boolean generateClass = this.canGenerateBean(input, className);
        String prefix = this.getConstantPrefix((ObjectModelClassifier)input);
        this.setConstantPrefix(prefix);
        ObjectModelClass outputAbstractClass = null;
        if (generateAbstractClass) {
            outputAbstractClass = this.generateAbstractBeanClass(aPackage, input, abstractClassName, interfaceName);
        }
        if (generateInterface) {
            ObjectModelClass outputAbstractClass1 = outputAbstractClass;
            if (outputAbstractClass == null) {
                outputAbstractClass1 = input;
            }
            this.generateBeanInterface(aPackage, input, interfaceName, outputAbstractClass1);
            if (generateAbstractClass) {
                for (ObjectModelOperation operation : this.getPublicOperations(outputAbstractClass)) {
                    this.addAnnotation((ObjectModelClassifier)outputAbstractClass, (ObjectModelElement)operation, Override.class);
                }
            }
        }
        if (generateClass) {
            this.generateBeanClass(input, className, abstractClassName);
        }
        if (generateDefaults) {
            this.generateBeanDefaults(aPackage, input, defaultClassName);
        }
    }

    protected boolean canGenerateFactory(ObjectModel model, String className) {
        boolean generateFactory = this.getJavaTemplatesTagValues().isSimpleBeanGenerateFactory(model);
        String defaultPackage = this.getDefaultPackageName();
        String fqn = defaultPackage + "." + className;
        boolean canGenerate = generateFactory && !this.isInClassPath(fqn);
        return canGenerate;
    }

    protected boolean canGenerateInterface(ObjectModelPackage aPackage, ObjectModelClass input, String className) {
        boolean generateInterface = this.getJavaTemplatesTagValues().isSimpleBeanGenerateInterface((ObjectModelClassifier)input, aPackage, (ObjectModel)this.model);
        String fqn = input.getPackageName() + "." + className;
        boolean canGenerate = generateInterface && !this.isInClassPath(fqn);
        return canGenerate;
    }

    protected boolean canGenerateAbstractBean(ObjectModelClass input, String className) {
        String fqn = input.getPackageName() + "." + className;
        boolean canGenerate = !this.isInClassPath(fqn);
        return canGenerate;
    }

    protected boolean canGenerateBean(ObjectModelClass input, String className) {
        boolean canGenerate;
        String fqn = input.getPackageName() + "." + className;
        boolean bl = canGenerate = !this.isInClassPath(fqn);
        if (canGenerate && !input.getOperations().isEmpty()) {
            canGenerate = false;
        }
        return canGenerate;
    }

    protected boolean canGenerateBeanDefaults(ObjectModelPackage aPackage, ObjectModelClass input) {
        boolean withInput = input != null;
        boolean canGenerate = this.getJavaTemplatesTagValues().isSimpleBeanGenerateDefaults((ObjectModelClassifier)input, aPackage, (ObjectModel)this.model);
        if (canGenerate && withInput) {
            canGenerate = !input.isAbstract() && JavaTemplatesStereoTypes.hasBeanStereotype((ObjectModelClassifier)input, aPackage);
        }
        return canGenerate;
    }

    protected boolean canGenerateBeanAbstractDefaults(ObjectModelClass input, String className) {
        String classPackage = input.getPackageName();
        String fqn = classPackage + "." + className;
        boolean canGenerate = !this.isInClassPath(fqn);
        return canGenerate;
    }

    protected void generateBeanFactory(ObjectModel model, String className) {
        String defaultPackage = this.getDefaultPackageName();
        ObjectModelClass output = this.createClass(className, defaultPackage);
        for (ObjectModelClass aClass : model.getClasses()) {
            String packageName = aClass.getPackageName();
            ObjectModelPackage aPackage = this.getPackage(packageName);
            if (aClass.isAbstract() || !JavaTemplatesStereoTypes.hasBeanStereotype((ObjectModelClassifier)aClass, aPackage)) continue;
            String typeName = this.getBeanInterfaceName(aPackage, aClass);
            String typeBeanName = this.getBeanClassName(aPackage, aClass);
            this.addImport((ObjectModelClassifier)output, packageName + "." + typeName);
            this.addImport((ObjectModelClassifier)output, packageName + "." + typeBeanName);
            ObjectModelOperation operation = this.addOperation((ObjectModelClassifier)output, "typeOf" + typeName, "<BeanType extends " + typeName + "> Class<BeanType>", new ObjectModelModifier[]{ObjectModelJavaModifier.STATIC, ObjectModelJavaModifier.PUBLIC});
            this.setOperationBody(operation, "\n        return (Class<BeanType>) " + typeBeanName + ".class;\n" + "    ");
            operation = this.addOperation((ObjectModelClassifier)output, "new" + typeName, typeName, new ObjectModelModifier[]{ObjectModelJavaModifier.STATIC, ObjectModelJavaModifier.PUBLIC});
            this.setOperationBody(operation, "\n        return new " + typeBeanName + "();\n" + "    ");
        }
    }

    protected ObjectModelInterface generateBeanInterface(ObjectModelPackage aPackage, ObjectModelClass input, String className, ObjectModelClass outputClass) {
        boolean serializableFound;
        ObjectModelInterface output = this.createInterface(className, input.getPackageName());
        if (log.isDebugEnabled()) {
            log.debug((Object)("will generate " + output.getQualifiedName()));
        }
        boolean superClassIsBean = false;
        String superClass = null;
        Collection superclasses = input.getSuperclasses();
        if (CollectionUtils.isNotEmpty((Collection)superclasses)) {
            for (ObjectModelClass superclass : superclasses) {
                if (JavaTemplatesStereoTypes.hasBeanStereotype((ObjectModelClassifier)superclass, aPackage)) {
                    superClassIsBean = true;
                    superClass = superclass.getPackageName() + "." + this.getBeanInterfaceName(aPackage, superclass);
                    break;
                }
                superClass = superclass.getQualifiedName();
            }
        }
        if (superClass == null) {
            superClass = this.getJavaTemplatesTagValues().getSimpleBeanInterfaceSuperClassTagValue((ObjectModelClassifier)input, aPackage, (ObjectModel)this.model);
        }
        if ((serializableFound = this.addInterfaces(input, (ObjectModelClassifier)output, superClass)) || superClassIsBean) {
            this.addInterface((ObjectModelClassifier)output, Serializable.class);
        }
        this.generateI18nBlockAndConstants(aPackage, input, (ObjectModelClassifier)output);
        for (ObjectModelOperation operation : this.getPublicOperations(outputClass)) {
            this.cloneOperation(operation, (ObjectModelClassifier)output, true, new ObjectModelJavaModifier[0]);
        }
        for (ObjectModelOperation operation : this.getPublicOperations(input)) {
            this.cloneOperation(operation, (ObjectModelClassifier)output, true, new ObjectModelJavaModifier[0]);
        }
        return output;
    }

    protected ObjectModelClass generateBeanClass(ObjectModelClass input, String className, String abstractClassName) {
        ObjectModelClass output = input.isAbstract() ? this.createAbstractClass(className, input.getPackageName()) : this.createClass(className, input.getPackageName());
        this.setSuperClass(output, abstractClassName);
        if (log.isDebugEnabled()) {
            log.debug((Object)("will generate " + output.getQualifiedName()));
        }
        this.addSerializable(input, output, true);
        return output;
    }

    protected ObjectModelClass generateAbstractBeanClass(ObjectModelPackage aPackage, ObjectModelClass input, String className, String interfaceName) {
        boolean serializableFound;
        boolean generateInterface = interfaceName != null;
        String superClass = null;
        boolean superClassIsBean = false;
        Collection superclasses = input.getSuperclasses();
        if (CollectionUtils.isNotEmpty((Collection)superclasses)) {
            for (ObjectModelClass superclass : superclasses) {
                if (JavaTemplatesStereoTypes.hasBeanStereotype((ObjectModelClassifier)superclass, aPackage)) {
                    superClassIsBean = true;
                    superClass = superclass.getPackageName() + "." + this.getBeanClassName(aPackage, superclass);
                    break;
                }
                superClass = superclass.getQualifiedName();
            }
        }
        if (!superClassIsBean && (superClass = this.getJavaTemplatesTagValues().getSimpleBeanSuperClassTagValue((ObjectModelClassifier)input, aPackage, (ObjectModel)this.model)) != null) {
            superClassIsBean = true;
        }
        ObjectModelClass output = this.createAbstractClass(className, input.getPackageName());
        if (superClass != null) {
            this.setSuperClass(output, superClass);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("will generate " + output.getQualifiedName()));
        }
        if (generateInterface) {
            this.addInterface((ObjectModelClassifier)output, interfaceName);
            serializableFound = true;
        } else {
            serializableFound = this.addInterfaces(input, (ObjectModelClassifier)output, null);
            this.generateI18nBlockAndConstants(aPackage, input, (ObjectModelClassifier)output);
        }
        this.addSerializable(input, output, serializableFound || superClassIsBean);
        List<ObjectModelAttribute> properties = this.getProperties(input);
        boolean usePCS = this.getJavaTemplatesTagValues().isGeneratePropertyChangeSupport((ObjectModelClassifier)input, aPackage, (ObjectModel)this.model);
        boolean generateBooleanGetMethods = this.getEugeneTagValues().isGenerateBooleanGetMethods((ObjectModelClassifier)input, aPackage, (ObjectModel)this.model);
        boolean generateNotEmptyCollections = this.getJavaTemplatesTagValues().isGenerateNotEmptyCollections((ObjectModelClassifier)input, aPackage, (ObjectModel)this.model);
        for (ObjectModelAttribute attr : properties) {
            this.createProperty(output, attr, usePCS, generateBooleanGetMethods, generateNotEmptyCollections);
        }
        if (!superClassIsBean) {
            this.addDefaultMethodForNoneBeanSuperClass(output, usePCS, properties);
        }
        return output;
    }

    protected void generateBeanDefaults(ObjectModelPackage aPackage, ObjectModelClass aClass, String defaultClassName) {
        boolean generateDefault = this.canGenerateBeanDefaults(aPackage, aClass);
        if (!generateDefault) {
            return;
        }
        String packageName = aClass.getPackageName();
        String typeName = this.getBeanInterfaceName(aPackage, aClass);
        String typeBeanName = this.getBeanClassName(aPackage, aClass);
        String abstractoutclassName = "Abstract" + defaultClassName;
        if (!this.isInClassPath(packageName, defaultClassName)) {
            ObjectModelClass output = this.createClass(defaultClassName, packageName);
            this.setSuperClass(output, packageName + "." + abstractoutclassName);
            if (log.isDebugEnabled()) {
                log.debug((Object)("will generate " + output.getQualifiedName()));
            }
        }
        if (!this.isInClassPath(packageName, abstractoutclassName)) {
            String superClassName = this.getJavaTemplatesTagValues().getSimpleBeanDefaultsSuperClassTagValue((ObjectModelClassifier)aClass, aPackage, (ObjectModel)this.model);
            ObjectModelClass output = this.createAbstractClass(abstractoutclassName, packageName);
            if (StringUtils.isNotBlank((CharSequence)superClassName)) {
                this.setSuperClass(output, superClassName);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("will generate " + output.getQualifiedName()));
            }
            ObjectModelOperation operation = this.addOperation((ObjectModelClassifier)output, "typeOf" + typeName, "<BeanType extends " + typeName + "> Class<BeanType>", new ObjectModelModifier[]{ObjectModelJavaModifier.STATIC, ObjectModelJavaModifier.PUBLIC});
            this.setOperationBody(operation, "\n        return (Class<BeanType>) " + typeBeanName + ".class;\n" + "    ");
            operation = this.addOperation((ObjectModelClassifier)output, "new" + typeName, typeName, new ObjectModelModifier[]{ObjectModelJavaModifier.STATIC, ObjectModelJavaModifier.PUBLIC});
            this.setOperationBody(operation, "\n        return new " + typeBeanName + "();\n" + "    ");
            this.addImport((ObjectModelClassifier)output, Binder.class);
            this.addImport((ObjectModelClassifier)output, BinderFactory.class);
            operation = this.addOperation((ObjectModelClassifier)output, "new" + typeName, "<BeanType extends " + typeName + "> BeanType", new ObjectModelModifier[]{ObjectModelJavaModifier.STATIC, ObjectModelJavaModifier.PUBLIC});
            this.addParameter(operation, "BeanType", "source");
            this.setOperationBody(operation, "\n        Class<BeanType> sourceType = typeOf" + typeName + "();\n" + "        Binder<BeanType,BeanType> binder = BinderFactory.newBinder(sourceType);\n" + "        BeanType result = new" + typeName + "(source, binder);\n" + "        return result;\n" + "    ");
            operation = this.addOperation((ObjectModelClassifier)output, "new" + typeName, "<BeanType extends " + typeName + "> BeanType", new ObjectModelModifier[]{ObjectModelJavaModifier.STATIC, ObjectModelJavaModifier.PUBLIC});
            this.addParameter(operation, "BeanType", "source");
            this.addParameter(operation, "Binder<BeanType, BeanType>", "binder");
            this.setOperationBody(operation, "\n        BeanType result = (BeanType) new" + typeName + "();\n" + "        binder.copy(source, result);\n" + "        return result;\n" + "    ");
        }
    }

    protected Collection<ObjectModelOperation> getPublicOperations(ObjectModelClass clazz) {
        ArrayList<ObjectModelOperation> result = new ArrayList<ObjectModelOperation>();
        for (ObjectModelOperation operation : clazz.getOperations()) {
            ObjectModelJavaModifier visibility = ObjectModelJavaModifier.fromVisibility((String)operation.getVisibility());
            if (ObjectModelJavaModifier.PUBLIC != visibility) continue;
            result.add(operation);
        }
        return result;
    }

    protected String getBeanInterfaceName(ObjectModelPackage aPackage, ObjectModelClass input) {
        String interfaceNamePrefix = this.getJavaTemplatesTagValues().getSimpleBeanInterfaceNamePrefixTagValue((ObjectModelClassifier)input, aPackage, (ObjectModel)this.model);
        String interfaceNameSuffix = this.getJavaTemplatesTagValues().getSimpleBeanInterfaceNameSuffixTagValue((ObjectModelClassifier)input, aPackage, (ObjectModel)this.model);
        return this.generateName(interfaceNamePrefix, input.getName(), interfaceNameSuffix);
    }

    protected String getBeanClassName(ObjectModelPackage aPackage, ObjectModelClass input) {
        String classNamePrefix = this.getJavaTemplatesTagValues().getSimpleBeanClassNamePrefixTagValue((ObjectModelClassifier)input, aPackage, (ObjectModel)this.model);
        String classNameSuffix = this.getJavaTemplatesTagValues().getSimpleBeanClassNameSuffixTagValue((ObjectModelClassifier)input, aPackage, (ObjectModel)this.model);
        return this.generateName(classNamePrefix, input.getName(), classNameSuffix);
    }

    protected String getAbstractBeanClassName(ObjectModelPackage aPackage, ObjectModelClass input) {
        String classNamePrefix = this.getJavaTemplatesTagValues().getSimpleBeanClassNamePrefixTagValue((ObjectModelClassifier)input, aPackage, (ObjectModel)this.model);
        String classNameSuffix = this.getJavaTemplatesTagValues().getSimpleBeanClassNameSuffixTagValue((ObjectModelClassifier)input, aPackage, (ObjectModel)this.model);
        return this.generateName(classNamePrefix, "Abstract" + input.getName(), classNameSuffix);
    }

    protected String getBeanDefaultsClassName(ObjectModelPackage aPackage, ObjectModelClass input) {
        String classNamePrefix = this.getJavaTemplatesTagValues().getSimpleBeanDefaultsClassNamePrefixTagValue((ObjectModelClassifier)input, aPackage, (ObjectModel)this.model);
        String classNameSuffix = this.getJavaTemplatesTagValues().getSimpleBeanDefaultsClassNameSuffixTagValue((ObjectModelClassifier)input, aPackage, (ObjectModel)this.model);
        return this.generateName(classNamePrefix, input.getName(), classNameSuffix);
    }

    protected String generateName(String prefix, String name, String suffix) {
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isNotEmpty((CharSequence)prefix)) {
            sb.append(prefix);
        }
        sb.append(name);
        if (StringUtils.isNotEmpty((CharSequence)suffix)) {
            sb.append(suffix);
        }
        return sb.toString();
    }
}

