/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.async.pool;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.neo4j.driver.internal.BoltServerAddress;
import org.neo4j.driver.internal.async.ChannelAttributes;
import org.neo4j.driver.internal.shaded.io.netty.channel.Channel;
import org.neo4j.driver.internal.shaded.io.netty.channel.pool.ChannelPoolHandler;
import org.neo4j.driver.v1.Logger;
import org.neo4j.driver.v1.Logging;

public class ActiveChannelTracker
implements ChannelPoolHandler {
    private final Map<BoltServerAddress, AtomicInteger> addressToActiveChannelCount = new ConcurrentHashMap<BoltServerAddress, AtomicInteger>();
    private final Logger log;

    public ActiveChannelTracker(Logging logging) {
        this.log = logging.getLog(this.getClass().getSimpleName());
    }

    @Override
    public void channelReleased(Channel channel) {
        this.log.debug("Channel %s released back to the pool", channel);
        this.channelInactive(channel);
    }

    @Override
    public void channelAcquired(Channel channel) {
        this.log.debug("Channel %s acquired from the pool", channel);
        this.channelActive(channel);
    }

    @Override
    public void channelCreated(Channel channel) {
        this.log.debug("Channel %s created", channel);
        this.channelActive(channel);
    }

    public int activeChannelCount(BoltServerAddress address) {
        AtomicInteger count = this.addressToActiveChannelCount.get(address);
        return count == null ? 0 : count.get();
    }

    private void channelActive(Channel channel) {
        BoltServerAddress address = ChannelAttributes.serverAddress(channel);
        AtomicInteger count = this.addressToActiveChannelCount.computeIfAbsent(address, k -> new AtomicInteger());
        count.incrementAndGet();
    }

    private void channelInactive(Channel channel) {
        BoltServerAddress address = ChannelAttributes.serverAddress(channel);
        AtomicInteger count = this.addressToActiveChannelCount.get(address);
        if (count == null) {
            throw new IllegalStateException("No count exist for address '" + address + "'");
        }
        count.decrementAndGet();
    }
}

