/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.async.inbound;

import java.util.List;
import org.neo4j.driver.internal.shaded.io.netty.buffer.ByteBuf;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelHandlerContext;
import org.neo4j.driver.internal.shaded.io.netty.handler.codec.ByteToMessageDecoder;

public class MessageDecoder
extends ByteToMessageDecoder {
    private boolean readMessageBoundary;

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof ByteBuf) {
            this.readMessageBoundary = ((ByteBuf)msg).readableBytes() == 0;
        }
        super.channelRead(ctx, msg);
    }

    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) {
        if (this.readMessageBoundary) {
            ByteBuf messageBuf = in.retainedDuplicate();
            in.readerIndex(in.readableBytes());
            out.add(messageBuf);
            this.readMessageBoundary = false;
        }
    }
}

