/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.modules;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import org.apache.commons.configuration.Configuration;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.server.JAXRSHelper;
import org.neo4j.server.logging.Logger;
import org.neo4j.server.modules.ServerModule;
import org.neo4j.server.web.WebServer;

public class ManagementApiModule
implements ServerModule {
    private final Logger log = Logger.getLogger(ManagementApiModule.class);
    private final Configuration config;
    private final WebServer webServer;

    public ManagementApiModule(WebServer webServer, Configuration config) {
        this.webServer = webServer;
        this.config = config;
    }

    @Override
    public void start(StringLogger logger) {
        try {
            this.webServer.addJAXRSPackages(JAXRSHelper.listFrom(new String[]{"org.neo4j.server.webadmin.rest"}), this.managementApiUri().toString());
            this.log.info("Mounted management API at [%s]", this.managementApiUri().toString());
            if (logger != null) {
                logger.logMessage("Mounted management API at: " + this.managementApiUri().toString());
            }
        }
        catch (UnknownHostException e) {
            this.log.warn(e);
        }
    }

    @Override
    public void stop() {
        try {
            this.webServer.removeJAXRSPackages(JAXRSHelper.listFrom(new String[]{"org.neo4j.server.webadmin.rest"}), this.managementApiUri().toString());
        }
        catch (UnknownHostException e) {
            this.log.warn(e);
        }
    }

    private URI managementApiUri() throws UnknownHostException {
        try {
            return new URI(this.config.getString("org.neo4j.server.webadmin.management.uri", "/db/manage"));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }
}

