/*
 * Decompiled with CFR 0.152.
 */
package com.sun.el.parser;

import com.sun.el.lang.ELSupport;
import com.sun.el.lang.EvaluationContext;
import com.sun.el.parser.SimpleNode;
import com.sun.el.util.MessageFactory;
import com.sun.el.util.ReflectionUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.el.ELException;
import javax.el.ELResolver;
import javax.el.MethodInfo;
import javax.el.PropertyNotFoundException;

public final class AstValue
extends SimpleNode {
    public AstValue(int id) {
        super(id);
    }

    public Class getType(EvaluationContext ctx) throws ELException {
        Target t = this.getTarget(ctx);
        ctx.setPropertyResolved(false);
        Class<?> ret = ctx.getELResolver().getType(ctx, t.base, t.property);
        if (!ctx.isPropertyResolved()) {
            ELSupport.throwUnhandled(t.base, t.property);
        }
        return ret;
    }

    private final Target getTarget(EvaluationContext ctx) throws ELException {
        int i;
        Object base = this.children[0].getValue(ctx);
        if (base == null) {
            throw new PropertyNotFoundException(MessageFactory.get("error.unreachable.base", this.children[0].getImage()));
        }
        Object property = null;
        int propCount = this.jjtGetNumChildren() - 1;
        ELResolver resolver = ctx.getELResolver();
        if (propCount > 1) {
            for (i = 1; base != null && i < propCount; ++i) {
                property = this.children[i].getValue(ctx);
                ctx.setPropertyResolved(false);
                base = resolver.getValue(ctx, base, property);
                if (ctx.isPropertyResolved()) continue;
                ELSupport.throwUnhandled(base, property);
            }
            if (base == null || property == null) {
                throw new PropertyNotFoundException(MessageFactory.get("error.unreachable.property", property));
            }
        }
        if ((property = this.children[i].getValue(ctx)) == null) {
            throw new PropertyNotFoundException(MessageFactory.get("error.unreachable.property", this.children[i]));
        }
        Target t = new Target();
        t.base = base;
        t.property = property;
        return t;
    }

    public Object getValue(EvaluationContext ctx) throws ELException {
        Object base = this.children[0].getValue(ctx);
        int propCount = this.jjtGetNumChildren();
        Object property = null;
        ELResolver resolver = ctx.getELResolver();
        for (int i = 1; base != null && i < propCount; ++i) {
            property = this.children[i].getValue(ctx);
            if (property == null) {
                return null;
            }
            ctx.setPropertyResolved(false);
            base = resolver.getValue(ctx, base, property);
            if (ctx.isPropertyResolved()) continue;
            ELSupport.throwUnhandled(base, property);
        }
        return base;
    }

    public boolean isReadOnly(EvaluationContext ctx) throws ELException {
        Target t = this.getTarget(ctx);
        ctx.setPropertyResolved(false);
        boolean ret = ctx.getELResolver().isReadOnly(ctx, t.base, t.property);
        if (!ctx.isPropertyResolved()) {
            ELSupport.throwUnhandled(t.base, t.property);
        }
        return ret;
    }

    public void setValue(EvaluationContext ctx, Object value) throws ELException {
        Target t = this.getTarget(ctx);
        ctx.setPropertyResolved(false);
        ELResolver elResolver = ctx.getELResolver();
        if (value != null) {
            value = ELSupport.coerceToType(value, elResolver.getType(ctx, t.base, t.property));
        }
        elResolver.setValue(ctx, t.base, t.property, value);
        if (!ctx.isPropertyResolved()) {
            ELSupport.throwUnhandled(t.base, t.property);
        }
    }

    public MethodInfo getMethodInfo(EvaluationContext ctx, Class[] paramTypes) throws ELException {
        Target t = this.getTarget(ctx);
        Method m = ReflectionUtil.getMethod(t.base, t.property, paramTypes);
        return new MethodInfo(m.getName(), m.getReturnType(), m.getParameterTypes());
    }

    public Object invoke(EvaluationContext ctx, Class[] paramTypes, Object[] paramValues) throws ELException {
        Target t = this.getTarget(ctx);
        Method m = ReflectionUtil.getMethod(t.base, t.property, paramTypes);
        Object result = null;
        try {
            result = m.invoke(t.base, paramValues);
        }
        catch (IllegalAccessException iae) {
            throw new ELException(iae);
        }
        catch (InvocationTargetException ite) {
            throw new ELException(ite.getCause());
        }
        return result;
    }

    protected static class Target {
        protected Object base;
        protected Object property;

        protected Target() {
        }
    }
}

