/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.plugin;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.jetty.annotations.AnnotationConfiguration;
import org.eclipse.jetty.annotations.AnnotationParser;
import org.eclipse.jetty.annotations.ClassNameResolver;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.webapp.MetaData;
import org.eclipse.jetty.webapp.WebAppContext;
import org.mortbay.jetty.plugin.JettyWebAppContext;

public class MavenAnnotationConfiguration
extends AnnotationConfiguration {
    public void parseWebInfClasses(final WebAppContext context, AnnotationParser parser) throws Exception {
        JettyWebAppContext jwac = (JettyWebAppContext)context;
        if (jwac.getClassPathFiles() == null) {
            super.parseWebInfClasses(context, parser);
        } else {
            Log.debug((String)"Scanning classes ");
            MetaData metaData = context.getMetaData();
            if (metaData == null) {
                throw new IllegalStateException("No metadata");
            }
            this.clearAnnotationList(parser.getAnnotationHandlers());
            for (File f : jwac.getClassPathFiles()) {
                if (!f.isDirectory() || !f.exists()) continue;
                parser.parse(Resource.newResource((URL)f.toURL()), new ClassNameResolver(){

                    public boolean isExcluded(String name) {
                        if (context.isSystemClass(name)) {
                            return true;
                        }
                        if (context.isServerClass(name)) {
                            return false;
                        }
                        return false;
                    }

                    public boolean shouldOverride(String name) {
                        return !context.isParentLoaderPriority();
                    }
                });
            }
            ArrayList annotations = new ArrayList();
            this.gatherAnnotations(annotations, parser.getAnnotationHandlers());
            metaData.addDiscoveredAnnotations(annotations);
        }
    }
}

