/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.cometd;

import dojox.cometd.Channel;
import dojox.cometd.Client;
import dojox.cometd.DataFilter;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.mortbay.cometd.AbstractBayeux;
import org.mortbay.cometd.ChannelId;
import org.mortbay.cometd.ClientImpl;
import org.mortbay.log.Log;
import org.mortbay.util.LazyList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChannelImpl
implements Channel {
    private AbstractBayeux _bayeux;
    private ClientImpl[] _subscribers = new ClientImpl[0];
    private DataFilter[] _dataFilters = new DataFilter[0];
    private ChannelId _id;
    private ConcurrentMap<String, ChannelImpl> _children = new ConcurrentHashMap<String, ChannelImpl>();
    private ChannelImpl _wild;
    private ChannelImpl _wildWild;
    private boolean _persistent;

    ChannelImpl(String id, AbstractBayeux bayeux) {
        this._id = new ChannelId(id);
        this._bayeux = bayeux;
    }

    public void addChild(ChannelImpl channel) {
        ChannelId child = channel.getChannelId();
        if (!this._id.isParentOf(child)) {
            throw new IllegalArgumentException(this._id + " not parent of " + child);
        }
        String next = child.getSegment(this._id.depth());
        if (child.depth() - this._id.depth() == 1) {
            ChannelImpl old = this._children.putIfAbsent(next, channel);
            if (old != null) {
                throw new IllegalArgumentException("Already Exists");
            }
            if ("*".equals(next)) {
                this._wild = channel;
            } else if ("**".equals(next)) {
                this._wildWild = channel;
            }
        } else {
            ChannelImpl branch = (ChannelImpl)this._children.get(next);
            branch = (ChannelImpl)this._bayeux.getChannel((this._id.depth() == 0 ? "/" : this._id.toString() + "/") + next, true);
            branch.addChild(channel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDataFilter(DataFilter filter) {
        ChannelImpl channelImpl = this;
        synchronized (channelImpl) {
            this._dataFilters = (DataFilter[])LazyList.addToArray((Object[])this._dataFilters, (Object)filter, null);
        }
    }

    public ChannelId getChannelId() {
        return this._id;
    }

    public ChannelImpl getChild(ChannelId id) {
        String next = id.getSegment(this._id.depth());
        if (next == null) {
            return null;
        }
        ChannelImpl channel = (ChannelImpl)this._children.get(next);
        if (channel == null || channel.getChannelId().depth() == id.depth()) {
            return channel;
        }
        return channel.getChild(id);
    }

    @Override
    public String getId() {
        return this._id.toString();
    }

    public String getToken(Client client, boolean subscribe, boolean send, boolean oneTime) {
        String token = Long.toString(this._bayeux.getRandom(client.hashCode()), 36);
        return token;
    }

    @Override
    public boolean isPersistent() {
        return this._persistent;
    }

    @Override
    public void publish(Client fromClient, Object data, String msgId) {
        this._bayeux.publish(this.getChannelId(), fromClient, data, msgId);
    }

    @Override
    public boolean remove() {
        return this._bayeux.removeChannel(this.getChannelId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDataFilter(DataFilter filter) {
        ChannelImpl channelImpl = this;
        synchronized (channelImpl) {
            this._dataFilters = (DataFilter[])LazyList.removeFromArray((Object[])this._dataFilters, (Object)filter);
        }
    }

    @Override
    public void setPersistent(boolean persistent) {
        this._persistent = persistent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void subscribe(Client client) {
        if (!(client instanceof ClientImpl)) {
            throw new IllegalArgumentException("Client instance not obtained from Bayeux.newClient()");
        }
        ((ClientImpl)client).addSubscription(this);
        ChannelImpl channelImpl = this;
        synchronized (channelImpl) {
            this._subscribers = (ClientImpl[])LazyList.addToArray((Object[])this._subscribers, (Object)client, null);
        }
    }

    public String toString() {
        return this._id.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unsubscribe(Client client) {
        if (!(client instanceof ClientImpl)) {
            throw new IllegalArgumentException("Client instance not obtained from Bayeux.newClient()");
        }
        ((ClientImpl)client).addSubscription(this);
        ChannelImpl channelImpl = this;
        synchronized (channelImpl) {
            this._subscribers = (ClientImpl[])LazyList.removeFromArray((Object[])this._subscribers, (Object)client);
            if (!this._persistent && this._subscribers.length == 0 && this._children.size() == 0) {
                this.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected void publish(ChannelId to, Client from, Map<String, Object> msg) {
        String next;
        ChannelImpl channel;
        Object old;
        Object data;
        int tail;
        block32: {
            tail = to.depth() - this._id.depth();
            old = data = msg.get("data");
            DataFilter[] filters = null;
            try {
                block13 : switch (tail) {
                    case 0: {
                        ChannelImpl channelImpl = this;
                        // MONITORENTER : channelImpl
                        filters = this._dataFilters;
                        // MONITOREXIT : channelImpl
                        for (DataFilter filter : filters) {
                            data = filter.filter(from, this, data);
                        }
                        break block32;
                    }
                    case 1: {
                        DataFilter[] arr$;
                        if (this._wild != null) {
                            arr$ = this._wild;
                            // MONITORENTER : this._wild
                            filters = this._wild._dataFilters;
                            // MONITOREXIT : arr$
                            for (DataFilter filter : filters) {
                                data = filter.filter(from, this, data);
                            }
                        }
                    }
                    default: {
                        if (this._wildWild == null) break block32;
                        DataFilter[] arr$ = this._wildWild;
                        // MONITORENTER : arr$
                        filters = this._wildWild._dataFilters;
                        // MONITOREXIT : arr$
                        arr$ = filters;
                        int len$ = arr$.length;
                        int i$ = 0;
                        while (i$ < len$) {
                            DataFilter filter;
                            filter = arr$[i$];
                            data = filter.filter(from, this, data);
                            ++i$;
                            break block13;
                        }
                        break block32;
                    }
                }
                {
                    continue;
                    break;
                }
            }
            catch (IllegalStateException e) {
                Log.debug((Throwable)e);
                return;
            }
        }
        if (data != old) {
            msg.put("data", data);
        }
        boolean delivered = false;
        switch (tail) {
            case 0: {
                ChannelImpl i$ = this;
                // MONITORENTER : i$
                ClientImpl[] subscribers = this._subscribers;
                // MONITOREXIT : i$
                ClientImpl[] arr$ = subscribers;
                int len$ = arr$.length;
                int i$2 = 0;
                while (i$2 < len$) {
                    ClientImpl client = arr$[i$2];
                    client.deliver(from, msg);
                    delivered = true;
                    ++i$2;
                }
                return;
            }
            case 1: {
                if (this._wild == null) break;
                ClientImpl[] arr$ = this._wild;
                // MONITORENTER : this._wild
                ClientImpl[] subscribers = this._wild._subscribers;
                // MONITOREXIT : arr$
                arr$ = subscribers;
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    ClientImpl client = arr$[i$];
                    client.deliver(from, msg);
                    delivered = true;
                }
                break;
            }
        }
        if (this._wildWild != null) {
            ClientImpl[] arr$ = this._wildWild;
            // MONITORENTER : this._wildWild
            ClientImpl[] subscribers = this._wildWild._subscribers;
            // MONITOREXIT : arr$
            for (ClientImpl client : subscribers) {
                client.deliver(from, msg);
                delivered = true;
            }
        }
        if ((channel = (ChannelImpl)this._children.get(next = to.getSegment(this._id.depth()))) == null) return;
        if (delivered) {
            msg = new HashMap<String, Object>(msg);
        }
        channel.publish(to, from, msg);
    }
}

