/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.internal;

import com.mongodb.MongoNamespace;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.ClientSession;
import com.mongodb.client.DistinctIterable;
import com.mongodb.client.cursor.TimeoutMode;
import com.mongodb.client.internal.MongoIterableImpl;
import com.mongodb.client.internal.OperationExecutor;
import com.mongodb.client.model.Collation;
import com.mongodb.internal.TimeoutSettings;
import com.mongodb.internal.operation.Operations;
import com.mongodb.internal.operation.ReadOperationCursor;
import com.mongodb.lang.Nullable;
import java.util.concurrent.TimeUnit;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;

class DistinctIterableImpl<TDocument, TResult>
extends MongoIterableImpl<TResult>
implements DistinctIterable<TResult> {
    private final Operations<TDocument> operations;
    private final Class<TResult> resultClass;
    private final String fieldName;
    private Bson filter;
    private long maxTimeMS;
    private Collation collation;
    private BsonValue comment;
    private Bson hint;
    private String hintString;

    DistinctIterableImpl(@Nullable ClientSession clientSession, MongoNamespace namespace, Class<TDocument> documentClass, Class<TResult> resultClass, CodecRegistry codecRegistry, ReadPreference readPreference, ReadConcern readConcern, OperationExecutor executor, String fieldName, Bson filter, boolean retryReads, TimeoutSettings timeoutSettings) {
        super(clientSession, executor, readConcern, readPreference, retryReads, timeoutSettings);
        this.operations = new Operations(namespace, documentClass, readPreference, codecRegistry, retryReads, timeoutSettings);
        this.resultClass = (Class)Assertions.notNull((String)"resultClass", resultClass);
        this.fieldName = (String)Assertions.notNull((String)"mapFunction", (Object)fieldName);
        this.filter = filter;
    }

    @Override
    public DistinctIterable<TResult> filter(@Nullable Bson filter) {
        this.filter = filter;
        return this;
    }

    @Override
    public DistinctIterable<TResult> maxTime(long maxTime, TimeUnit timeUnit) {
        Assertions.notNull((String)"timeUnit", (Object)((Object)timeUnit));
        this.maxTimeMS = TimeUnit.MILLISECONDS.convert(maxTime, timeUnit);
        return this;
    }

    @Override
    public DistinctIterable<TResult> batchSize(int batchSize) {
        super.batchSize(batchSize);
        return this;
    }

    @Override
    public DistinctIterable<TResult> timeoutMode(TimeoutMode timeoutMode) {
        super.timeoutMode(timeoutMode);
        return this;
    }

    @Override
    public DistinctIterable<TResult> collation(@Nullable Collation collation) {
        this.collation = collation;
        return this;
    }

    @Override
    public DistinctIterable<TResult> comment(@Nullable String comment) {
        this.comment = comment == null ? null : new BsonString(comment);
        return this;
    }

    @Override
    public DistinctIterable<TResult> comment(@Nullable BsonValue comment) {
        this.comment = comment;
        return this;
    }

    @Override
    public DistinctIterable<TResult> hint(@Nullable Bson hint) {
        this.hint = hint;
        return this;
    }

    @Override
    public DistinctIterable<TResult> hintString(@Nullable String hint) {
        this.hintString = hint;
        return this;
    }

    @Override
    public ReadOperationCursor<TResult> asReadOperation() {
        return this.operations.distinct(this.fieldName, this.filter, this.resultClass, this.collation, this.comment, this.hint, this.hintString);
    }

    @Override
    protected OperationExecutor getExecutor() {
        return this.getExecutor(this.operations.createTimeoutSettings(this.maxTimeMS));
    }
}

