/*
 * Decompiled with CFR 0.152.
 */
package org.jinterop.dcom.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import ndr.NdrBuffer;
import ndr.NetworkDataRepresentation;
import org.jinterop.dcom.common.JIException;
import org.jinterop.dcom.common.JISystem;
import org.jinterop.dcom.core.IJIComObject;
import org.jinterop.dcom.core.JIArray;
import org.jinterop.dcom.core.JICallBuilder;
import org.jinterop.dcom.core.JIComObjectImpl;
import org.jinterop.dcom.core.JIComOxidRuntime;
import org.jinterop.dcom.core.JIComServer;
import org.jinterop.dcom.core.JIInterfacePointer;
import org.jinterop.dcom.core.JILocalCoClass;
import org.jinterop.dcom.core.JIOxid;
import org.jinterop.dcom.core.JISession;

public final class JIFrameworkHelper {
    static /* synthetic */ Class class$org$jinterop$dcom$core$IJIComObject;
    static /* synthetic */ Class class$java$lang$Integer;

    static void link2Sessions(JISession src, JISession target) {
        if (src == null || target == null) {
            throw new NullPointerException();
        }
        JISession.linkTwoSessions(src, target);
    }

    static void unLinkSession(JISession src, JISession unlinkedSession) {
        if (src == null || unlinkedSession == null) {
            throw new NullPointerException();
        }
        JISession.unLinkSession(src, unlinkedSession);
    }

    static JISession resolveSessionForOXID(byte[] oxid) {
        return JISession.resolveSessionForOxid(new JIOxid(oxid));
    }

    static JIInterfacePointer getInterfacePointerOfStub(JISession session) {
        return session.getStub().getServerInterfacePointer();
    }

    static IJIComObject instantiateComObject(JISession session, JIInterfacePointer ptr) throws JIException {
        IJIComObject retval = JIFrameworkHelper.instantiateComObject2(session, ptr);
        JIFrameworkHelper.addComObjectToSession(retval.getAssociatedSession(), retval);
        return retval;
    }

    static IJIComObject instantiateComObject2(JISession session, JIInterfacePointer ptr) throws JIException {
        if (ptr == null) {
            throw new IllegalArgumentException(JISystem.getLocalizedMessage(4113));
        }
        IJIComObject retval = null;
        JIInterfacePointer stubPtr = JIFrameworkHelper.getInterfacePointerOfStub(session);
        if (!JIInterfacePointer.isOxidEqual(stubPtr, ptr)) {
            JISession newsession;
            if (JISystem.getLogger().isLoggable(Level.WARNING)) {
                JISystem.getLogger().warning("NEW SESSION IDENTIFIED ! for ptr " + ptr);
            }
            if ((newsession = JIFrameworkHelper.resolveSessionForOXID(ptr.getOXID())) == null) {
                newsession = JISession.createSession(session);
                newsession.setGlobalSocketTimeout(session.getGlobalSocketTimeout());
                newsession.useSessionSecurity(session.isSessionSecurityEnabled());
                JIComServer comServer = new JIComServer(newsession, ptr, null);
                retval = comServer.getInstance();
                JIFrameworkHelper.link2Sessions(session, newsession);
            }
            session = newsession;
        }
        if (retval == null) {
            retval = new JIComObjectImpl(session, ptr);
        }
        return retval;
    }

    static void addComObjectToSession(JISession session, IJIComObject comObject) {
        session.addToSession(comObject, comObject.internal_getInterfacePointer().getOID());
    }

    public static IJIComObject instantiateLocalComObject(JISession session, JILocalCoClass javaComponent) throws JIException {
        return new JIComObjectImpl(session, JIComOxidRuntime.getInterfacePointer(session, javaComponent), true);
    }

    public static IJIComObject instantiateComObject(JISession session, byte[] rawBytes, String ipAddress) throws JIException {
        NetworkDataRepresentation ndr = new NetworkDataRepresentation();
        NdrBuffer ndrBuffer = new NdrBuffer(rawBytes, 0);
        ndr.setBuffer(ndrBuffer);
        ndrBuffer.length = rawBytes.length;
        if (session.getStub() == null) {
            JIComServer comServer = new JIComServer(session, JIInterfacePointer.decode(ndr, new ArrayList(), 32768, new HashMap()), ipAddress);
            return comServer.getInstance();
        }
        IJIComObject retval = JIFrameworkHelper.instantiateComObject(session, JIInterfacePointer.decode(ndr, new ArrayList(), 32768, new HashMap()));
        retval.addRef();
        return retval;
    }

    public static IJIComObject instantiateComObject(JISession session, IJIComObject comObject) throws JIException {
        if (comObject.getAssociatedSession() != null) {
            throw new IllegalArgumentException(JISystem.getLocalizedMessage(4168));
        }
        if (comObject.isLocalReference()) {
            throw new IllegalArgumentException(JISystem.getLocalizedMessage(4169));
        }
        return JIFrameworkHelper.instantiateComObject(session, comObject.internal_getInterfacePointer());
    }

    public static void detachEventHandler(IJIComObject comObject, String identifier) throws JIException {
        Object[] connectionInfo = comObject.internal_getConnectionInfo(identifier);
        if (connectionInfo == null) {
            throw new JIException(4146);
        }
        if (JISystem.getLogger().isLoggable(Level.INFO)) {
            JISystem.getLogger().info("Detaching event handler for  comObject: " + comObject.getInterfaceIdentifier() + " , identifier: " + identifier);
        }
        IJIComObject connectionPointer = (IJIComObject)connectionInfo[0];
        JICallBuilder object = new JICallBuilder(true);
        object.setOpnum(3);
        object.addInParamAsInt((Integer)connectionInfo[1], 0);
        connectionPointer.call(object);
        connectionPointer.release();
    }

    public static String attachEventHandler(IJIComObject comObject, String sourceUUID, IJIComObject eventListener) throws JIException {
        if (eventListener == null || comObject == null || sourceUUID == null || sourceUUID.equalsIgnoreCase("")) {
            throw new IllegalArgumentException(JISystem.getLocalizedMessage(4152));
        }
        if (JISystem.getLogger().isLoggable(Level.INFO)) {
            JISystem.getLogger().info("Attaching event handler for  comObject: " + comObject.getInterfaceIdentifier() + " , sourceUUID: " + sourceUUID + " , eventListener: " + eventListener.getInterfaceIdentifier() + " and eventListner IPID: " + eventListener.getIpid());
        }
        IJIComObject connectionPointContainer = comObject.queryInterface("B196B284-BAB4-101A-B69C-00AA00341D07");
        JICallBuilder object = new JICallBuilder(true);
        object.setOpnum(1);
        object.addInParamAsUUID(sourceUUID, 0);
        object.addOutParamAsObject(class$org$jinterop$dcom$core$IJIComObject == null ? (class$org$jinterop$dcom$core$IJIComObject = JIFrameworkHelper.class$("org.jinterop.dcom.core.IJIComObject")) : class$org$jinterop$dcom$core$IJIComObject, 0);
        Object[] objects = connectionPointContainer.call(object);
        IJIComObject connectionPointer = (IJIComObject)objects[0];
        object.reInit();
        object.setOpnum(2);
        object.addInParamAsComObject(eventListener, 0);
        object.addOutParamAsType(class$java$lang$Integer == null ? (class$java$lang$Integer = JIFrameworkHelper.class$("java.lang.Integer")) : class$java$lang$Integer, 0);
        Object[] obj = connectionPointer.call(object);
        Integer dwcookie = (Integer)obj[0];
        if (JISystem.getLogger().isLoggable(Level.INFO)) {
            JISystem.getLogger().info("Event handler returned cookie " + dwcookie);
        }
        connectionPointContainer.release();
        return comObject.internal_setConnectionInfo(connectionPointer, dwcookie);
    }

    public static int reverseArrayForDispatch(JIArray arrayToReverse) {
        return arrayToReverse.reverseArrayForDispatch();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

