/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.social.linkedin;

import org.keycloak.broker.oidc.OIDCIdentityProviderConfig;
import org.keycloak.crypto.PublicKeysWrapper;
import org.keycloak.jose.jwk.JSONWebKeySet;
import org.keycloak.jose.jwk.JWK;
import org.keycloak.keys.PublicKeyLoader;
import org.keycloak.models.KeycloakSession;
import org.keycloak.protocol.oidc.utils.JWKSHttpUtils;
import org.keycloak.util.JWKSUtils;

public class LinkedInPublicKeyLoader
implements PublicKeyLoader {
    private final KeycloakSession session;
    private final OIDCIdentityProviderConfig config;

    public LinkedInPublicKeyLoader(KeycloakSession session, OIDCIdentityProviderConfig config) {
        this.session = session;
        this.config = config;
    }

    public PublicKeysWrapper loadKeys() throws Exception {
        String jwksUrl = this.config.getJwksUrl();
        JSONWebKeySet jwks = JWKSHttpUtils.sendJwksRequest(this.session, jwksUrl);
        return JWKSUtils.getKeyWrappersForUse((JSONWebKeySet)jwks, (JWK.Use)JWK.Use.SIG, (boolean)true);
    }
}

