/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.localizer;

import com.sun.codemodel.CodeWriter;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JPackage;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import com.sun.codemodel.writer.FileCodeWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import org.apache.tools.ant.DirectoryScanner;
import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.Reporter;
import org.jvnet.localizer.ResourceBundleHolder;

public class Generator {
    private final JCodeModel cm = new JCodeModel();
    private final File outputDirectory;
    private final Reporter reporter;

    public Generator(File outputDirectory, Reporter reporter) {
        this.outputDirectory = outputDirectory;
        this.reporter = reporter;
    }

    public void generate(File baseDir, DirectoryScanner ds) throws IOException {
        for (String relPath : ds.getIncludedFiles()) {
            File f = new File(baseDir, relPath);
            if (!f.getName().endsWith(".properties") || f.getName().contains("_")) continue;
            try {
                this.generate(f, relPath);
            }
            catch (IOException e) {
                IOException x = new IOException("Failed to generate a class from " + f);
                x.initCause(e);
                throw x;
            }
        }
    }

    public void generate(File propertyFile, String relPath) throws IOException {
        String className = this.toClassName(relPath);
        File sourceFile = new File(this.outputDirectory, className.replace('.', '/') + ".java");
        if (sourceFile.exists() && sourceFile.lastModified() > propertyFile.lastModified()) {
            this.reporter.debug(sourceFile + " is up to date");
            return;
        }
        Properties props = new Properties();
        FileInputStream in = new FileInputStream(propertyFile);
        try {
            props.load(in);
        }
        catch (IOException e) {
            in.close();
        }
        try {
            JDefinedClass c = this.cm._class(className);
            c.annotate(SuppressWarnings.class).paramArray("value").param("").param("PMD");
            JFieldVar holder = c.field(28, ResourceBundleHolder.class, "holder", (JExpression)this.cm.ref(ResourceBundleHolder.class).staticInvoke("get").arg(c.dotclass()));
            for (Map.Entry<Object, Object> e : props.entrySet()) {
                String key = e.getKey().toString();
                String value = e.getValue().toString();
                int n = this.countArgs(value);
                ArrayList<JVar> args = new ArrayList<JVar>();
                JMethod m = c.method(17, (JType)this.cm.ref(String.class), this.toJavaIdentifier(key));
                for (int i = 1; i <= n; ++i) {
                    args.add(m.param(Object.class, "arg" + i));
                }
                JInvocation inv = holder.invoke("format").arg(key);
                for (JVar arg : args) {
                    inv.arg((JExpression)arg);
                }
                m.body()._return((JExpression)inv);
                m.javadoc().add((Object)this.escape(value));
                args.clear();
                m = c.method(17, (JType)this.cm.ref(Localizable.class), '_' + this.toJavaIdentifier(key));
                for (int i = 1; i <= n; ++i) {
                    args.add(m.param(Object.class, "arg" + i));
                }
                inv = JExpr._new((JClass)this.cm.ref(Localizable.class)).arg((JExpression)holder).arg(key);
                for (JVar arg : args) {
                    inv.arg((JExpression)arg);
                }
                m.body()._return((JExpression)inv);
                m.javadoc().add((Object)this.escape(value));
            }
        }
        catch (JClassAlreadyExistsException e) {
            throw new AssertionError((Object)e);
        }
    }

    private String escape(String value) {
        return value.replace("&", "&amp;").replace("<", "&lt;");
    }

    protected int countArgs(String formatString) {
        return new MessageFormat(formatString).getFormatsByArgumentIndex().length;
    }

    protected String toJavaIdentifier(String key) {
        return key.replace('.', '_').replace('-', '_').replace('/', '_');
    }

    protected String toClassName(String relPath) {
        relPath = relPath.substring(0, relPath.length() - ".properties".length());
        return relPath.replace(File.separatorChar, '.');
    }

    public JCodeModel getCodeModel() {
        return this.cm;
    }

    public void build() throws IOException {
        this.outputDirectory.mkdirs();
        this.cm.build(new CodeWriter(){
            private final CodeWriter delegate;
            {
                this.delegate = new FileCodeWriter(Generator.this.outputDirectory);
            }

            public Writer openSource(JPackage pkg, String fileName) throws IOException {
                Writer w = super.openSource(pkg, fileName);
                new PrintWriter(w).println("// CHECKSTYLE:OFF");
                return w;
            }

            public void close() throws IOException {
                this.delegate.close();
            }

            public OutputStream openBinary(JPackage pkg, String fileName) throws IOException {
                return this.delegate.openBinary(pkg, fileName);
            }
        });
    }
}

