/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxb2.maven2;

import com.sun.org.apache.xml.internal.resolver.tools.CatalogResolver;
import java.io.File;
import java.net.URL;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.jfrog.maven.annomojo.annotations.MojoComponent;
import org.jfrog.maven.annomojo.annotations.MojoParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractXJC2Mojo
extends AbstractMojo {
    private String schemaLanguage;
    private File schemaDirectory;
    private String[] schemaIncludes = new String[]{"*.xsd"};
    private String[] schemaExcludes;
    private File bindingDirectory;
    private String[] bindingIncludes = new String[]{"*.xjb"};
    private String[] bindingExcludes;
    private boolean disableDefaultExcludes;
    private File catalog;
    protected String catalogResolver = CatalogResolver.class.getName();
    private String generatePackage;
    private File generateDirectory;
    private boolean readOnly;
    private boolean extension;
    private boolean strict;
    private boolean writeCode = true;
    private boolean verbose;
    private boolean debug;
    private List<String> args = new LinkedList<String>();
    private boolean forceRegenerate;
    private boolean removeOldOutput;
    private String[] produces = new String[]{"**/*.*", "**/*.java", "**/bgm.ser", "**/jaxb.properties"};
    private File[] otherDepends;
    private File episodeFile;
    private boolean episode = true;
    private List classpathElements;
    protected Dependency[] plugins;
    private Dependency[] episodes;
    private MavenProject project;
    private ArtifactResolver artifactResolver;
    private ArtifactMetadataSource artifactMetadataSource;
    private ArtifactFactory artifactFactory;
    private ArtifactRepository localRepository;
    private MavenProjectBuilder mavenProjectBuilder;
    private List<Artifact> pluginArtifacts;
    private String specVersion = "2.1";
    private static final String XML_SCHEMA_CLASS_NAME = "XmlSchema";
    private static final String XML_SCHEMA_CLASS_QNAME = "javax.xml.bind.annotation.XmlSchema";
    private static final String XML_SCHEMA_RESOURCE_NAME = "XmlSchema.class";
    private static final String XML_SCHEMA_RESOURCE_QNAME = "/javax/xml/bind/annotation/XmlSchema.class";
    private static final String XML_ELEMENT_REF_CLASS_NAME = "XmlElementRef";
    private static final String XML_ELEMENT_REF_CLASS_QNAME = "javax.xml.bind.annotation.XmlElementRef";

    @MojoParameter(expression="${maven.xjc2.schemaLanguage}")
    public String getSchemaLanguage() {
        return this.schemaLanguage;
    }

    public void setSchemaLanguage(String schemaLanguage) {
        this.schemaLanguage = schemaLanguage;
    }

    @MojoParameter(defaultValue="src/main/resources", expression="${maven.xjc2.schemaDirectory}", required=true)
    public File getSchemaDirectory() {
        return this.schemaDirectory;
    }

    public void setSchemaDirectory(File schemaDirectory) {
        this.schemaDirectory = schemaDirectory;
    }

    @MojoParameter
    public String[] getSchemaIncludes() {
        return this.schemaIncludes;
    }

    public void setSchemaIncludes(String[] schemaIncludes) {
        this.schemaIncludes = schemaIncludes;
    }

    @MojoParameter
    public String[] getSchemaExcludes() {
        return this.schemaExcludes;
    }

    public void setSchemaExcludes(String[] schemaExcludes) {
        this.schemaExcludes = schemaExcludes;
    }

    public void setBindingDirectory(File bindingDirectory) {
        this.bindingDirectory = bindingDirectory;
    }

    @MojoParameter(expression="${maven.xjc2.bindingDirectory}")
    public File getBindingDirectory() {
        return this.bindingDirectory != null ? this.bindingDirectory : this.getSchemaDirectory();
    }

    @MojoParameter
    public String[] getBindingIncludes() {
        return this.bindingIncludes;
    }

    public void setBindingIncludes(String[] bindingIncludes) {
        this.bindingIncludes = bindingIncludes;
    }

    @MojoParameter
    public String[] getBindingExcludes() {
        return this.bindingExcludes;
    }

    public void setBindingExcludes(String[] bindingExcludes) {
        this.bindingExcludes = bindingExcludes;
    }

    @MojoParameter(defaultValue="false", expression="${maven.xjc2.disableDefaultExcludes}")
    public boolean getDisableDefaultExcludes() {
        return this.disableDefaultExcludes;
    }

    public void setDisableDefaultExcludes(boolean disableDefaultExcludes) {
        this.disableDefaultExcludes = disableDefaultExcludes;
    }

    @MojoParameter(expression="${maven.xjc2.catalog}")
    public File getCatalog() {
        return this.catalog;
    }

    public void setCatalog(File catalog) {
        this.catalog = catalog;
    }

    @MojoParameter(expression="${maven.xjc2.catalogResolver}")
    public String getCatalogResolver() {
        return this.catalogResolver;
    }

    public void setCatalogResolver(String catalogResolver) {
        this.catalogResolver = catalogResolver;
    }

    @MojoParameter(expression="${maven.xjc2.generatePackage}")
    public String getGeneratePackage() {
        return this.generatePackage;
    }

    public void setGeneratePackage(String generatePackage) {
        this.generatePackage = generatePackage;
    }

    @MojoParameter(defaultValue="${project.build.directory}/generated-sources/xjc", expression="${maven.xjc2.generateDirectory}", required=true)
    public File getGenerateDirectory() {
        return this.generateDirectory;
    }

    public void setGenerateDirectory(File generateDirectory) {
        this.generateDirectory = generateDirectory;
        if (this.getEpisodeFile() == null) {
            File episodeFile = new File(this.getGenerateDirectory(), "META-INF" + File.separator + "sun-jaxb.episode");
            this.setEpisodeFile(episodeFile);
        }
    }

    @MojoParameter(defaultValue="false", expression="${maven.xjc2.readOnly}")
    public boolean getReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    @MojoParameter(defaultValue="false", expression="${maven.xjc2.extension}")
    public boolean getExtension() {
        return this.extension;
    }

    public void setExtension(boolean extension) {
        this.extension = extension;
    }

    @MojoParameter(defaultValue="true", expression="${maven.xjc2.strict}")
    public boolean getStrict() {
        return this.strict;
    }

    public void setStrict(boolean strict) {
        this.strict = strict;
    }

    @MojoParameter(defaultValue="true", expression="${maven.xjc2.writeCode}")
    public boolean getWriteCode() {
        return this.writeCode;
    }

    public void setWriteCode(boolean writeCode) {
        this.writeCode = writeCode;
    }

    @MojoParameter(defaultValue="false", expression="${maven.xjc2.verbose}")
    public boolean getVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    @MojoParameter(defaultValue="false", expression="${maven.xjc2.debug}")
    public boolean getDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    @MojoParameter
    public List<String> getArgs() {
        return this.args;
    }

    public void setArgs(List<String> args) {
        this.args.addAll(args);
    }

    @MojoParameter(defaultValue="false", expression="${maven.xjc2.forceRegenerate}")
    public boolean getForceRegenerate() {
        return this.forceRegenerate;
    }

    public void setForceRegenerate(boolean forceRegenerate) {
        this.forceRegenerate = forceRegenerate;
    }

    @MojoParameter(defaultValue="false", expression="${maven.xjc2.removeOldOutput}")
    public boolean getRemoveOldOutput() {
        return this.removeOldOutput;
    }

    public void setRemoveOldOutput(boolean removeOldOutput) {
        this.removeOldOutput = removeOldOutput;
    }

    @MojoParameter
    public String[] getProduces() {
        return this.produces;
    }

    public void setProduces(String[] produces) {
        this.produces = produces;
    }

    @MojoParameter
    public File[] getOtherDepends() {
        return this.otherDepends;
    }

    public void setOtherDepends(File[] otherDepends) {
        this.otherDepends = otherDepends;
    }

    @MojoParameter(expression="${maven.xjc2.episodeFile}")
    public File getEpisodeFile() {
        return this.episodeFile;
    }

    public void setEpisodeFile(File episodeFile) {
        this.episodeFile = episodeFile;
    }

    @MojoParameter(expression="${maven.xjc2.episode}", defaultValue="true")
    public boolean getEpisode() {
        return this.episode;
    }

    public void setEpisode(boolean episode) {
        this.episode = episode;
    }

    @MojoParameter(expression="${project.compileClasspathElements}", required=true, readonly=true)
    public List getClasspathElements() {
        return this.classpathElements;
    }

    public void setClasspathElements(List classpathElements) {
        this.classpathElements = classpathElements;
    }

    @MojoParameter
    public Dependency[] getPlugins() {
        return this.plugins;
    }

    public void setPlugins(Dependency[] plugins) {
        this.plugins = plugins;
    }

    @MojoParameter
    public Dependency[] getEpisodes() {
        return this.episodes;
    }

    public void setEpisodes(Dependency[] episodes) {
        this.episodes = episodes;
    }

    @MojoParameter(defaultValue="2.1")
    public String getSpecVersion() {
        return this.specVersion;
    }

    public void setSpecVersion(String specVersion) {
        this.specVersion = specVersion;
    }

    protected void logConfiguration() throws MojoExecutionException {
        this.logApiConfiguration();
        this.getLog().info((CharSequence)("pluginArtifacts:" + this.getPluginArtifacts()));
        this.getLog().info((CharSequence)("schemaLanguage:" + this.getSchemaLanguage()));
        this.getLog().info((CharSequence)("schemaDirectory:" + this.getSchemaDirectory()));
        this.getLog().info((CharSequence)("schemaIncludes:" + this.getSchemaIncludes()));
        this.getLog().info((CharSequence)("schemaExcludes:" + this.getSchemaExcludes()));
        this.getLog().info((CharSequence)("bindingDirectory:" + this.getBindingDirectory()));
        this.getLog().info((CharSequence)("bindingIncludes:" + this.getBindingIncludes()));
        this.getLog().info((CharSequence)("bindingExcludes:" + this.getBindingExcludes()));
        this.getLog().info((CharSequence)("disableDefaultExcludes:" + this.getDisableDefaultExcludes()));
        this.getLog().info((CharSequence)("catalog:" + this.getCatalog()));
        this.getLog().info((CharSequence)("catalogResolver:" + this.getCatalogResolver()));
        this.getLog().info((CharSequence)("generatePackage:" + this.getGeneratePackage()));
        this.getLog().info((CharSequence)("generateDirectory:" + this.getGenerateDirectory()));
        this.getLog().info((CharSequence)("readOnly:" + this.getReadOnly()));
        this.getLog().info((CharSequence)("extension:" + this.getExtension()));
        this.getLog().info((CharSequence)("strict:" + this.getStrict()));
        this.getLog().info((CharSequence)("writeCode:" + this.getWriteCode()));
        this.getLog().info((CharSequence)("verbose:" + this.getVerbose()));
        this.getLog().info((CharSequence)("debug:" + this.getDebug()));
        this.getLog().info((CharSequence)("args:" + this.getArgs()));
        this.getLog().info((CharSequence)("forceRegenerate:" + this.getForceRegenerate()));
        this.getLog().info((CharSequence)("removeOldOutput:" + this.getRemoveOldOutput()));
        this.getLog().info((CharSequence)("produces:" + Arrays.toString(this.getProduces())));
        this.getLog().info((CharSequence)("otherDepends:" + this.getOtherDepends()));
        this.getLog().info((CharSequence)("episodeFile:" + this.getEpisodeFile()));
        this.getLog().info((CharSequence)("episode:" + this.getEpisode()));
        this.getLog().info((CharSequence)("classpathElements:" + this.getClasspathElements()));
        this.getLog().info((CharSequence)("plugins:" + this.getPlugins()));
        this.getLog().info((CharSequence)("episodes:" + this.getEpisodes()));
        this.getLog().info((CharSequence)("xjcPlugins:" + this.getPlugins()));
        this.getLog().info((CharSequence)("episodes:" + this.getEpisodes()));
        this.getLog().info((CharSequence)("specVersion:" + this.getSpecVersion()));
    }

    @MojoParameter(expression="${project}", required=true, readonly=true)
    public MavenProject getProject() {
        return this.project;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    @MojoComponent
    public ArtifactResolver getArtifactResolver() {
        return this.artifactResolver;
    }

    public void setArtifactResolver(ArtifactResolver artifactResolver) {
        this.artifactResolver = artifactResolver;
    }

    @MojoComponent
    public ArtifactMetadataSource getArtifactMetadataSource() {
        return this.artifactMetadataSource;
    }

    public void setArtifactMetadataSource(ArtifactMetadataSource artifactMetadataSource) {
        this.artifactMetadataSource = artifactMetadataSource;
    }

    @MojoComponent
    public ArtifactFactory getArtifactFactory() {
        return this.artifactFactory;
    }

    public void setArtifactFactory(ArtifactFactory artifactFactory) {
        this.artifactFactory = artifactFactory;
    }

    @MojoParameter(expression="${localRepository}", required=true)
    public ArtifactRepository getLocalRepository() {
        return this.localRepository;
    }

    public void setLocalRepository(ArtifactRepository localRepository) {
        this.localRepository = localRepository;
    }

    @MojoComponent(role="org.apache.maven.project.MavenProjectBuilder")
    public MavenProjectBuilder getMavenProjectBuilder() {
        return this.mavenProjectBuilder;
    }

    public void setMavenProjectBuilder(MavenProjectBuilder mavenProjectBuilder) {
        this.mavenProjectBuilder = mavenProjectBuilder;
    }

    protected void logApiConfiguration() {
        try {
            Class<?> xmlSchemaClass = Class.forName(XML_SCHEMA_CLASS_QNAME);
            URL resource = xmlSchemaClass.getResource(XML_SCHEMA_RESOURCE_NAME);
            String draftLocation = resource.toExternalForm();
            String location = draftLocation.endsWith(XML_SCHEMA_RESOURCE_QNAME) ? draftLocation.substring(0, draftLocation.length() - XML_SCHEMA_RESOURCE_QNAME.length()) : draftLocation;
            this.getLog().info((CharSequence)("JAXB API is loaded from the [" + location + "]."));
            try {
                xmlSchemaClass.getMethod("location", new Class[0]);
                Class<?> xmlElementRefClass = Class.forName(XML_ELEMENT_REF_CLASS_QNAME);
                try {
                    xmlElementRefClass.getMethod("required", new Class[0]);
                    this.getLog().info((CharSequence)"Detected JAXB API version [2.2].");
                }
                catch (NoSuchMethodException nsmex2) {
                    this.getLog().info((CharSequence)"Detected JAXB API version [2.1].");
                }
            }
            catch (NoSuchMethodException nsmex1) {
                this.getLog().info((CharSequence)"Detected JAXB API version [2.0].");
            }
        }
        catch (ClassNotFoundException cnfex) {
            this.getLog().error((CharSequence)"Could not find JAXB 2.x API classes. Make sure JAXB 2.x API is on the classpath.");
        }
    }

    @MojoParameter(expression="${plugin.artifacts}", required=true)
    public List<Artifact> getPluginArtifacts() {
        return this.pluginArtifacts;
    }

    public void setPluginArtifacts(List<Artifact> plugingArtifacts) {
        this.pluginArtifacts = plugingArtifacts;
    }
}

