/*
 * Decompiled with CFR 0.152.
 */
package netx.jnlp.runtime;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import netx.jnlp.ExtensionDesc;
import netx.jnlp.JARDesc;
import netx.jnlp.JNLPFile;
import netx.jnlp.ParseException;
import netx.jnlp.ResourcesDesc;
import netx.jnlp.SecurityDesc;
import netx.jnlp.cache.CacheUtil;
import netx.jnlp.cache.ResourceTracker;
import netx.jnlp.cache.UpdatePolicy;
import netx.jnlp.runtime.ApplicationInstance;
import netx.jnlp.runtime.JNLPRuntime;

public class JNLPClassLoader
extends URLClassLoader {
    private static Map urlToLoader = new HashMap();
    private static int nativeCounter = 0;
    private File nativeDir = null;
    private AccessControlContext acc = AccessController.getContext();
    private List resourcePermissions;
    private ApplicationInstance app = null;
    private JNLPClassLoader[] loaders = null;
    private boolean strict = true;
    private ResourceTracker tracker = new ResourceTracker(true);
    private UpdatePolicy updatePolicy;
    private JNLPFile file;
    private ResourcesDesc resources;
    private SecurityDesc security;
    private List available = new ArrayList();
    static /* synthetic */ Class class$netx$jnlp$runtime$JNLPClassLoader;

    protected JNLPClassLoader(JNLPFile file, UpdatePolicy policy) {
        super(new URL[]{}, (class$netx$jnlp$runtime$JNLPClassLoader == null ? (class$netx$jnlp$runtime$JNLPClassLoader = JNLPClassLoader.class$("netx.jnlp.runtime.JNLPClassLoader")) : class$netx$jnlp$runtime$JNLPClassLoader).getClassLoader());
        if (JNLPRuntime.isDebug()) {
            System.out.println("New classloader: " + file.getFileLocation());
        }
        this.file = file;
        this.updatePolicy = policy;
        this.resources = file.getResources();
        this.security = file.getSecurity();
        this.initializeExtensions();
        this.initializePermissions();
        this.initializeResources();
    }

    public static JNLPClassLoader getInstance(JNLPFile file, UpdatePolicy policy) {
        JNLPClassLoader loader = null;
        URL location = file.getFileLocation();
        if (location != null) {
            loader = (JNLPClassLoader)urlToLoader.get(location);
        }
        if (loader == null) {
            loader = new JNLPClassLoader(file, policy);
        }
        if (file.getInformation().isSharingAllowed()) {
            urlToLoader.put(location, loader);
        }
        return loader;
    }

    public static JNLPClassLoader getInstance(URL location, UpdatePolicy policy) throws IOException, ParseException {
        JNLPClassLoader loader = (JNLPClassLoader)urlToLoader.get(location);
        if (loader == null) {
            loader = JNLPClassLoader.getInstance(new JNLPFile(location, false, policy), policy);
        }
        return loader;
    }

    void initializeExtensions() {
        ExtensionDesc[] ext = this.resources.getExtensions();
        ArrayList<JNLPClassLoader> loaderList = new ArrayList<JNLPClassLoader>();
        loaderList.add(this);
        for (int i = 0; i < ext.length; ++i) {
            try {
                JNLPClassLoader loader = JNLPClassLoader.getInstance(ext[i].getLocation(), this.updatePolicy);
                loaderList.add(loader);
                continue;
            }
            catch (Exception ex) {
                if (!JNLPRuntime.isDebug()) continue;
                ex.printStackTrace();
            }
        }
        this.loaders = loaderList.toArray(new JNLPClassLoader[loaderList.size()]);
    }

    void initializePermissions() {
        this.resourcePermissions = new ArrayList();
        JARDesc[] jars = this.resources.getJARs();
        for (int i = 0; i < jars.length; ++i) {
            Permission p = CacheUtil.getReadPermission(jars[i].getLocation(), jars[i].getVersion());
            if (p == null) continue;
            this.resourcePermissions.add(p);
        }
    }

    void initializeResources() {
        JARDesc[] jars = this.resources.getJARs();
        ArrayList<JARDesc> initialJars = new ArrayList<JARDesc>();
        for (int i = 0; i < jars.length; ++i) {
            this.available.add(jars[i]);
            if (jars[i].isEager()) {
                initialJars.add(jars[i]);
            }
            this.tracker.addResource(jars[i].getLocation(), jars[i].getVersion(), JNLPRuntime.getDefaultUpdatePolicy());
        }
        if (this.strict) {
            this.fillInPartJars(initialJars);
        }
        this.activateJars(initialJars);
    }

    public void enableCodeBase() {
        this.addURL(this.file.getCodeBase());
    }

    public void setApplication(ApplicationInstance app) {
        if (this.app != null) {
            if (JNLPRuntime.isDebug()) {
                IllegalStateException ex = new IllegalStateException("Application can only be set once");
                ex.printStackTrace();
            }
            return;
        }
        this.app = app;
    }

    public ApplicationInstance getApplication() {
        return this.app;
    }

    public JNLPFile getJNLPFile() {
        return this.file;
    }

    protected PermissionCollection getPermissions(CodeSource cs) {
        Permissions result = new Permissions();
        Enumeration<Permission> e = this.security.getPermissions().elements();
        while (e.hasMoreElements()) {
            result.add(e.nextElement());
        }
        for (int i = 0; i < this.resourcePermissions.size(); ++i) {
            result.add((Permission)this.resourcePermissions.get(i));
        }
        return result;
    }

    protected void fillInPartJars(List jars) {
        for (int i = 0; i < jars.size(); ++i) {
            String part = ((JARDesc)jars.get(i)).getPart();
            for (int a = 0; a < this.available.size(); ++a) {
                JARDesc jar = (JARDesc)this.available.get(a);
                if (part == null || !part.equals(jar.getPart()) || jars.contains(jar)) continue;
                jars.add(jar);
            }
        }
    }

    protected void activateJars(final List jars) {
        PrivilegedAction activate = new PrivilegedAction(){

            public Object run() {
                JNLPClassLoader.this.waitForJars(jars);
                for (int i = 0; i < jars.size(); ++i) {
                    JARDesc jar;
                    block5: {
                        jar = (JARDesc)jars.get(i);
                        JNLPClassLoader.this.available.remove(jar);
                        File localFile = JNLPClassLoader.this.tracker.getCacheFile(jar.getLocation());
                        try {
                            URL location = jar.getLocation();
                            if (localFile != null) {
                                location = localFile.toURL();
                            }
                            JNLPClassLoader.this.addURL(location);
                            if (JNLPRuntime.isDebug()) {
                                System.err.println("Activate jar: " + location);
                            }
                        }
                        catch (Exception ex) {
                            if (!JNLPRuntime.isDebug()) break block5;
                            ex.printStackTrace();
                        }
                    }
                    if (!jar.isNative()) continue;
                    JNLPClassLoader.this.activateNative(jar);
                }
                return null;
            }
        };
        AccessController.doPrivileged(activate, this.acc);
    }

    protected void activateNative(JARDesc jar) {
        block6: {
            File localFile;
            if (JNLPRuntime.isDebug()) {
                System.out.println("Activate native: " + jar.getLocation());
            }
            if ((localFile = this.tracker.getCacheFile(jar.getLocation())) == null) {
                return;
            }
            if (this.nativeDir == null) {
                this.nativeDir = this.getNativeDir();
            }
            try {
                JarFile jarFile = new JarFile(localFile, false);
                Enumeration<JarEntry> entries = jarFile.entries();
                while (entries.hasMoreElements()) {
                    JarEntry e = entries.nextElement();
                    if (e.isDirectory() || e.getName().indexOf(47) != -1) continue;
                    File outFile = new File(this.nativeDir, e.getName());
                    CacheUtil.streamCopy(jarFile.getInputStream(e), new FileOutputStream(outFile));
                }
            }
            catch (IOException ex) {
                if (!JNLPRuntime.isDebug()) break block6;
                ex.printStackTrace();
            }
        }
    }

    protected File getNativeDir() {
        this.nativeDir = new File(System.getProperty("java.io.tmpdir") + File.separator + "netx-native-" + (new Random().nextInt() & 0xFFFF));
        if (!this.nativeDir.mkdirs()) {
            return null;
        }
        return this.nativeDir;
    }

    protected String findLibrary(String lib) {
        if (this.nativeDir == null) {
            return null;
        }
        String syslib = System.mapLibraryName(lib);
        File target = new File(this.nativeDir, syslib);
        if (target.exists()) {
            return target.toString();
        }
        String result = super.findLibrary(lib);
        if (result != null) {
            return result;
        }
        return this.findLibraryExt(lib);
    }

    protected String findLibraryExt(String lib) {
        for (int i = 0; i < this.loaders.length; ++i) {
            String result = null;
            if (this.loaders[i] != this) {
                result = this.loaders[i].findLibrary(lib);
            }
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private void waitForJars(List jars) {
        URL[] urls = new URL[jars.size()];
        for (int i = 0; i < jars.size(); ++i) {
            JARDesc jar = (JARDesc)jars.get(i);
            urls[i] = jar.getLocation();
        }
        CacheUtil.waitForResources(this.app, this.tracker, urls, this.file.getTitle());
    }

    protected Class findLoadedClassAll(String name) {
        for (int i = 0; i < this.loaders.length; ++i) {
            Class result = null;
            result = this.loaders[i] == this ? super.findLoadedClass(name) : this.loaders[i].findLoadedClassAll(name);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public Class loadClass(String name) throws ClassNotFoundException {
        Class result = this.findLoadedClassAll(name);
        if (result == null) {
            try {
                ClassLoader parent = this.getParent();
                if (parent == null) {
                    parent = ClassLoader.getSystemClassLoader();
                }
                return parent.loadClass(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (result == null) {
            result = this.loadClassExt(name);
        }
        return result;
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        for (int i = 0; i < this.loaders.length; ++i) {
            try {
                if (this.loaders[i] == this) {
                    return super.findClass(name);
                }
                return this.loaders[i].findClass(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
                continue;
            }
        }
        throw new ClassNotFoundException(name);
    }

    private Class loadClassExt(String name) throws ClassNotFoundException {
        this.addAvailable();
        try {
            return this.findClass(name);
        }
        catch (ClassNotFoundException ex) {
            while (true) {
                JNLPClassLoader addedTo;
                if ((addedTo = this.addNextResource()) == null) {
                    throw new ClassNotFoundException(name);
                }
                try {
                    return addedTo.findClass(name);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    continue;
                }
                break;
            }
        }
    }

    public URL getResource(String name) {
        URL result = super.getResource(name);
        for (int i = 1; i < this.loaders.length; ++i) {
            if (result != null) continue;
            result = this.loaders[i].getResource(name);
        }
        return result;
    }

    public Enumeration findResources(String name) throws IOException {
        Vector resources = new Vector();
        for (int i = 0; i < this.loaders.length; ++i) {
            Enumeration e = this.loaders[i] == this ? super.findResources(name) : this.loaders[i].findResources(name);
            while (e.hasMoreElements()) {
                resources.add(e.nextElement());
            }
        }
        return resources.elements();
    }

    protected void addAvailable() {
        for (int i = 1; i < this.loaders.length; ++i) {
            this.loaders[i].addAvailable();
        }
    }

    protected JNLPClassLoader addNextResource() {
        if (this.available.size() == 0) {
            for (int i = 1; i < this.loaders.length; ++i) {
                JNLPClassLoader result = this.loaders[i].addNextResource();
                if (result == null) continue;
                return result;
            }
            return null;
        }
        ArrayList jars = new ArrayList();
        jars.add(this.available.get(0));
        this.fillInPartJars(jars);
        this.activateJars(jars);
        return this;
    }

    public String getExtensionName() {
        String result = this.file.getInformation().getTitle();
        if (result == null) {
            result = this.file.getInformation().getDescription();
        }
        if (result == null && this.file.getFileLocation() != null) {
            result = this.file.getFileLocation().toString();
        }
        if (result == null && this.file.getCodeBase() != null) {
            result = this.file.getCodeBase().toString();
        }
        return result;
    }

    public String getExtensionHREF() {
        return this.file.getFileLocation().toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

