/*
 * Decompiled with CFR 0.152.
 */
package netx.jnlp.runtime;

import java.awt.Window;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.swing.event.EventListenerList;
import netx.jnlp.JNLPFile;
import netx.jnlp.PropertyDesc;
import netx.jnlp.event.ApplicationEvent;
import netx.jnlp.event.ApplicationListener;
import netx.jnlp.runtime.JNLPRuntime;
import netx.jnlp.util.WeakList;

public class ApplicationInstance {
    private JNLPFile file;
    private ThreadGroup group;
    private ClassLoader loader;
    private boolean stopped = false;
    private WeakList weakWindows = new WeakList();
    private EventListenerList listeners = new EventListenerList();
    static /* synthetic */ Class class$netx$jnlp$event$ApplicationListener;

    public ApplicationInstance(JNLPFile file, ThreadGroup group, ClassLoader loader) {
        this.file = file;
        this.group = group;
        this.loader = loader;
    }

    public void addApplicationListener(ApplicationListener listener) {
        this.listeners.add(class$netx$jnlp$event$ApplicationListener == null ? (class$netx$jnlp$event$ApplicationListener = ApplicationInstance.class$("netx.jnlp.event.ApplicationListener")) : class$netx$jnlp$event$ApplicationListener, listener);
    }

    public void removeApplicationListener(ApplicationListener listener) {
        this.listeners.remove(class$netx$jnlp$event$ApplicationListener == null ? (class$netx$jnlp$event$ApplicationListener = ApplicationInstance.class$("netx.jnlp.event.ApplicationListener")) : class$netx$jnlp$event$ApplicationListener, listener);
    }

    protected void fireDestroyed() {
        Object[] list = this.listeners.getListenerList();
        ApplicationEvent event = null;
        for (int i = list.length - 1; i > 0; i -= 2) {
            if (event == null) {
                event = new ApplicationEvent(this);
            }
            ((ApplicationListener)list[i]).applicationDestroyed(event);
        }
    }

    public void initialize() {
        this.installEnvironment();
    }

    public void finalize() {
        this.destroy();
    }

    void installEnvironment() {
        final PropertyDesc[] props = this.file.getResources().getProperties();
        PrivilegedAction installProps = new PrivilegedAction(){

            public Object run() {
                for (int i = 0; i < props.length; ++i) {
                    System.setProperty(props[i].getKey(), props[i].getValue());
                }
                return null;
            }
        };
        AccessController.doPrivileged(installProps);
    }

    public JNLPFile getJNLPFile() {
        return this.file;
    }

    public String getTitle() {
        return this.file.getTitle();
    }

    public boolean isRunning() {
        return !this.stopped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        if (this.stopped) {
            return;
        }
        try {
            int i;
            for (int i2 = 0; i2 < this.weakWindows.size(); ++i2) {
                Window w = (Window)this.weakWindows.get(i2);
                if (w == null) continue;
                w.dispose();
            }
            this.weakWindows.clear();
            Thread[] threads = new Thread[this.group.activeCount() * 2];
            int nthreads = this.group.enumerate(threads);
            for (i = 0; i < nthreads; ++i) {
                if (JNLPRuntime.isDebug()) {
                    System.out.println("Interrupt thread: " + threads[i]);
                }
                threads[i].interrupt();
            }
            Thread.currentThread();
            Thread.yield();
            nthreads = this.group.enumerate(threads);
            for (i = 0; i < nthreads; ++i) {
                if (JNLPRuntime.isDebug()) {
                    System.out.println("Stop thread: " + threads[i]);
                }
                threads[i].stop();
            }
        }
        finally {
            this.stopped = true;
            this.fireDestroyed();
        }
    }

    public ThreadGroup getThreadGroup() throws IllegalStateException {
        if (this.stopped) {
            throw new IllegalStateException();
        }
        return this.group;
    }

    public ClassLoader getClassLoader() throws IllegalStateException {
        if (this.stopped) {
            throw new IllegalStateException();
        }
        return this.loader;
    }

    protected void addWindow(Window window) {
        this.weakWindows.add(window);
        this.weakWindows.trimToSize();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

