/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.persistence.correlation;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Version;
import org.jbpm.persistence.correlation.CorrelationKeyInfo;
import org.kie.internal.process.CorrelationProperty;

@Entity
@SequenceGenerator(name="correlationPropertyInfoIdSeq", sequenceName="CORRELATION_PROP_ID_SEQ")
public class CorrelationPropertyInfo
implements CorrelationProperty<String> {
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="correlationPropertyInfoIdSeq")
    @Column(name="propertyId")
    private long id;
    @Version
    @Column(name="OPTLOCK")
    private int version;
    @ManyToOne
    private CorrelationKeyInfo correlationKey;
    private String name;
    private String value;

    public CorrelationPropertyInfo() {
    }

    public CorrelationPropertyInfo(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return String.class.getName();
    }

    public String getValue() {
        return this.value;
    }

    public CorrelationKeyInfo getCorrelationKey() {
        return this.correlationKey;
    }

    public void setCorrelationKey(CorrelationKeyInfo correlationKey) {
        this.correlationKey = correlationKey;
    }

    public String toString() {
        return "CorrelationPropertyInfo [name=" + this.name + ", value=" + this.value + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.correlationKey == null ? 0 : (int)(this.correlationKey.getId() ^ this.correlationKey.getId() >>> 32));
        result = 31 * result + (int)(this.id ^ this.id >>> 32);
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        result = 31 * result + this.version;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CorrelationPropertyInfo other = (CorrelationPropertyInfo)obj;
        if (this.correlationKey == null ? other.correlationKey != null : this.correlationKey.getId() != other.correlationKey.getId()) {
            return false;
        }
        if (this.id != other.id) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.value == null ? other.value != null : !this.value.equals(other.value)) {
            return false;
        }
        return this.version == other.version;
    }
}

