/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.xml;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.jboss.weld.logging.messages.XmlMessage;
import org.jboss.weld.resources.spi.ResourceLoader;
import org.jboss.weld.resources.spi.ResourceLoadingException;
import org.jboss.weld.util.dom.NodeListIterable;
import org.jboss.weld.xml.WeldXmlException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeansXmlElement {
    private URL file;
    private Element element;

    private BeansXmlElement(URL file, Element element) {
        this.file = file;
        this.element = element;
    }

    private String getClassNameFromNode(Node node) {
        if (node instanceof Element && node.getChildNodes().getLength() == 1 && node.getChildNodes().item(0) instanceof Text) {
            String className = ((Text)node.getChildNodes().item(0)).getData();
            return className;
        }
        return null;
    }

    public static BeansXmlElement of(URL file, Node element) {
        return new BeansXmlElement(file, (Element)element);
    }

    public List<Class<?>> getClasses(ResourceLoader resourceLoader) {
        ArrayList classes = new ArrayList();
        for (Node child : new NodeListIterable(this.element.getChildNodes())) {
            String className = this.getClassNameFromNode(child);
            if (className == null) continue;
            try {
                classes.add(resourceLoader.classForName(className));
            }
            catch (ResourceLoadingException e) {
                throw new WeldXmlException(XmlMessage.CANNOT_LOAD_CLASS, className, this.file);
            }
        }
        return classes;
    }

    public URL getFile() {
        return this.file;
    }

    public Element getElement() {
        return this.element;
    }

    public String toString() {
        return "File: " + this.getFile() + "; Node: " + this.getElement();
    }
}

