/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.exceptions;

import java.util.List;
import org.jboss.weld.exceptions.WeldExceptionMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeldException
extends RuntimeException {
    private static final long serialVersionUID = 2L;
    private WeldExceptionMessage message;

    public WeldException(Throwable throwable) {
        super(throwable);
        this.message = new WeldExceptionMessage(throwable.getLocalizedMessage());
    }

    public <E extends Enum<?>> WeldException(E key, Object ... args) {
        this.message = new WeldExceptionMessage(key, args);
    }

    public <E extends Enum<?>> WeldException(E key, Throwable throwable, Object ... args) {
        super(throwable);
        this.message = new WeldExceptionMessage(key, args);
    }

    public WeldException(List<Throwable> errors) {
        StringBuilder errorMessage = new StringBuilder();
        int i = 0;
        for (Throwable throwable : errors) {
            if (i > 0) {
                errorMessage.append('\n');
            }
            errorMessage.append("Exception #").append(i).append(" :");
            errorMessage.append(throwable.getLocalizedMessage());
            ++i;
        }
        this.message = new WeldExceptionMessage(errorMessage.toString());
    }

    @Override
    public String getLocalizedMessage() {
        return this.getMessage();
    }

    @Override
    public String getMessage() {
        return this.message.getAsString();
    }
}

