/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.CreationException;
import javax.enterprise.inject.Disposes;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.Producer;
import org.jboss.weld.bean.AbstractBean;
import org.jboss.weld.bean.AbstractClassBean;
import org.jboss.weld.bean.AbstractProducerBean;
import org.jboss.weld.bean.DisposalMethod;
import org.jboss.weld.bean.SessionBean;
import org.jboss.weld.bootstrap.BeanDeployerEnvironment;
import org.jboss.weld.exceptions.DefinitionException;
import org.jboss.weld.exceptions.ForbiddenStateException;
import org.jboss.weld.injection.MethodInjectionPoint;
import org.jboss.weld.injection.ParameterInjectionPoint;
import org.jboss.weld.introspector.WeldMethod;
import org.jboss.weld.logging.messages.BeanMessage;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.util.AnnotatedTypes;
import org.jboss.weld.util.reflection.SecureReflections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProducerMethod<X, T>
extends AbstractProducerBean<X, T, Method> {
    private MethodInjectionPoint<T, ? super X> method;
    private DisposalMethod<X, ?> disposalMethodBean;
    private ProducerMethod<?, ?> specializedBean;
    private final String id;

    public static <X, T> ProducerMethod<X, T> of(WeldMethod<T, ? super X> method, AbstractClassBean<X> declaringBean, BeanManagerImpl beanManager) {
        return new ProducerMethod<X, T>(method, declaringBean, beanManager);
    }

    protected ProducerMethod(WeldMethod<T, ? super X> method, AbstractClassBean<X> declaringBean, BeanManagerImpl beanManager) {
        super(ProducerMethod.class.getSimpleName() + "-" + declaringBean.getWeldAnnotated().getName() + "." + method.getSignature().toString(), declaringBean, beanManager);
        this.method = MethodInjectionPoint.of(this, method);
        this.initType();
        this.initTypes();
        this.initQualifiers();
        this.id = this.createId(method, declaringBean);
        this.initStereotypes();
        this.initProducerMethodInjectableParameters();
    }

    protected String createId(WeldMethod<T, ? super X> method, AbstractClassBean<X> declaringBean) {
        if (declaringBean.getWeldAnnotated().isDiscovered()) {
            StringBuilder sb = new StringBuilder();
            sb.append(BEAN_ID_PREFIX);
            sb.append(ProducerMethod.class.getSimpleName());
            sb.append("-");
            sb.append(declaringBean.getWeldAnnotated().getName());
            sb.append(this.getWeldAnnotated().getSignature().toString());
            return sb.toString();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(BEAN_ID_PREFIX);
        sb.append(ProducerMethod.class.getSimpleName());
        sb.append("-");
        sb.append(AnnotatedTypes.createTypeId(declaringBean.getWeldAnnotated()));
        sb.append(AnnotatedTypes.createCallableId(method));
        return sb.toString();
    }

    @Override
    public void initialize(BeanDeployerEnvironment environment) {
        if (!this.isInitialized()) {
            super.initialize(environment);
            this.checkProducerMethod();
            this.initDisposalMethod(environment);
            this.setProducer(new Producer<T>(){

                @Override
                public void dispose(T instance) {
                    if (ProducerMethod.this.disposalMethodBean != null) {
                        ProducerMethod.this.disposalMethodBean.invokeDisposeMethod(instance);
                    }
                }

                @Override
                public Set<InjectionPoint> getInjectionPoints() {
                    return ProducerMethod.this.getWeldInjectionPoints();
                }

                @Override
                public T produce(CreationalContext<T> creationalContext) {
                    Object receiver = ProducerMethod.this.getReceiver(creationalContext);
                    if (receiver != null) {
                        return ProducerMethod.this.method.invokeOnInstance(receiver, ProducerMethod.this.beanManager, creationalContext, CreationException.class);
                    }
                    return ProducerMethod.this.method.invoke(receiver, ProducerMethod.this.beanManager, creationalContext, CreationException.class);
                }
            });
        }
    }

    protected void initProducerMethodInjectableParameters() {
        for (ParameterInjectionPoint<?, ? super X> parameterInjectionPoint : this.method.getWeldParameters()) {
            this.addInjectionPoint(ParameterInjectionPoint.of(this, parameterInjectionPoint));
        }
    }

    protected void checkProducerMethod() {
        if (this.getWeldAnnotated().getWeldParameters(Observes.class).size() > 0) {
            throw new DefinitionException(BeanMessage.INCONSISTENT_ANNOTATIONS_ON_METHOD, "@Produces", "@Observes");
        }
        if (this.getWeldAnnotated().getWeldParameters(Disposes.class).size() > 0) {
            throw new DefinitionException(BeanMessage.INCONSISTENT_ANNOTATIONS_ON_METHOD, "@Produces", "@Disposes");
        }
        if (this.getDeclaringBean() instanceof SessionBean) {
            boolean methodDeclaredOnTypes = false;
            for (Type type : this.getDeclaringBean().getTypes()) {
                if (!(type instanceof Class) || !SecureReflections.isMethodExists((Class)type, this.getWeldAnnotated().getName(), this.getWeldAnnotated().getParameterTypesAsArray())) continue;
                methodDeclaredOnTypes = true;
            }
            if (!methodDeclaredOnTypes) {
                throw new DefinitionException(BeanMessage.METHOD_NOT_BUSINESS_METHOD, this, this.getDeclaringBean());
            }
        }
    }

    protected void initDisposalMethod(BeanDeployerEnvironment environment) {
        Set disposalBeans = environment.resolveDisposalBeans(this.getTypes(), this.getQualifiers(), this.getDeclaringBean());
        if (disposalBeans.size() == 1) {
            this.disposalMethodBean = disposalBeans.iterator().next();
        } else if (disposalBeans.size() > 1) {
            throw new DefinitionException(BeanMessage.MULTIPLE_DISPOSAL_METHODS, this, disposalBeans);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy(T instance, CreationalContext<T> creationalContext) {
        try {
            this.getProducer().dispose(instance);
        }
        finally {
            if (this.getDeclaringBean().isDependent()) {
                creationalContext.release();
            }
        }
    }

    @Override
    public WeldMethod<T, ? super X> getWeldAnnotated() {
        return this.method;
    }

    @Override
    protected String getDefaultName() {
        return this.method.getPropertyName();
    }

    public DisposalMethod<X, ?> getDisposalMethod() {
        return this.disposalMethodBean;
    }

    @Override
    public AbstractBean<?, ?> getSpecializedBean() {
        return this.specializedBean;
    }

    @Override
    protected void preSpecialize(BeanDeployerEnvironment environment) {
        if (this.getDeclaringBean().getWeldAnnotated().getWeldSuperclass().getDeclaredWeldMethod((Method)this.getWeldAnnotated().getJavaMember()) == null) {
            throw new DefinitionException(BeanMessage.PRODUCER_METHOD_NOT_SPECIALIZING, this);
        }
    }

    @Override
    protected void specialize(BeanDeployerEnvironment environment) {
        WeldMethod<?, ?> superClassMethod = this.getDeclaringBean().getWeldAnnotated().getWeldSuperclass().getWeldMethod((Method)this.getWeldAnnotated().getJavaMember());
        if (environment.getProducerMethod(superClassMethod) == null) {
            throw new ForbiddenStateException(BeanMessage.PRODUCER_METHOD_NOT_SPECIALIZING, this);
        }
        this.specializedBean = environment.getProducerMethod(superClassMethod);
    }

    @Override
    public String getId() {
        return this.id;
    }
}

