/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean;

import java.lang.reflect.Field;
import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.Producer;
import javax.inject.Inject;
import org.jboss.interceptor.util.InterceptionUtils;
import org.jboss.weld.bean.AbstractBean;
import org.jboss.weld.bean.AbstractClassBean;
import org.jboss.weld.bean.AbstractProducerBean;
import org.jboss.weld.bean.SessionBean;
import org.jboss.weld.bootstrap.BeanDeployerEnvironment;
import org.jboss.weld.exceptions.DefinitionException;
import org.jboss.weld.introspector.WeldField;
import org.jboss.weld.logging.Category;
import org.jboss.weld.logging.LoggerFactory;
import org.jboss.weld.logging.messages.BeanMessage;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.util.AnnotatedTypes;
import org.slf4j.cal10n.LocLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProducerField<X, T>
extends AbstractProducerBean<X, T, Field> {
    private static final LocLogger log = LoggerFactory.loggerFactory().getLogger(Category.BEAN);
    private WeldField<T, ? super X> field;

    public static <X, T> ProducerField<X, T> of(WeldField<T, ? super X> field, AbstractClassBean<X> declaringBean, BeanManagerImpl beanManager) {
        return new ProducerField<X, T>(field, declaringBean, beanManager);
    }

    protected ProducerField(WeldField<T, ? super X> field, AbstractClassBean<X> declaringBean, BeanManagerImpl manager) {
        super(ProducerField.createId(field, declaringBean), declaringBean, manager);
        this.field = field;
        this.initType();
        this.initTypes();
        this.initQualifiers();
        this.initStereotypes();
    }

    protected static String createId(WeldField<?, ?> field, AbstractClassBean<?> declaringBean) {
        if (declaringBean.getWeldAnnotated().isDiscovered()) {
            StringBuilder sb = new StringBuilder();
            sb.append(ProducerField.class.getSimpleName());
            sb.append("-");
            sb.append(declaringBean.getWeldAnnotated().getName());
            sb.append(".");
            sb.append(field.getName());
            return sb.toString();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(ProducerField.class.getSimpleName());
        sb.append("-");
        sb.append(AnnotatedTypes.createTypeId(declaringBean.getWeldAnnotated()));
        sb.append(".");
        sb.append(AnnotatedTypes.createFieldId(field));
        return sb.toString();
    }

    @Override
    public void initialize(BeanDeployerEnvironment environment) {
        if (!this.isInitialized()) {
            super.initialize(environment);
            this.setProducer(new Producer<T>(){

                @Override
                public void dispose(T instance) {
                    ProducerField.this.defaultDispose(instance);
                }

                @Override
                public Set<InjectionPoint> getInjectionPoints() {
                    return ProducerField.this.getWeldInjectionPoints();
                }

                @Override
                public T produce(CreationalContext<T> creationalContext) {
                    return ProducerField.this.field.get(InterceptionUtils.getRawInstance(ProducerField.this.getReceiver(creationalContext)));
                }
            });
            this.checkProducerField();
        }
    }

    protected void checkProducerField() {
        if (this.getWeldAnnotated().isAnnotationPresent(Inject.class)) {
            throw new DefinitionException(BeanMessage.INJECTED_FIELD_CANNOT_BE_PRODUCER, this.getWeldAnnotated(), this.getWeldAnnotated().getDeclaringType());
        }
        if (this.getDeclaringBean() instanceof SessionBean && !this.field.isStatic()) {
            throw new DefinitionException(BeanMessage.PRODUCER_FIELD_ON_SESSION_BEAN_MUST_BE_STATIC, this.getWeldAnnotated(), this.getWeldAnnotated().getDeclaringType());
        }
    }

    protected void defaultDispose(T instance) {
    }

    @Override
    public void destroy(T instance, CreationalContext<T> creationalContext) {
        this.getProducer().dispose(instance);
    }

    @Override
    public WeldField<T, ? super X> getWeldAnnotated() {
        return this.field;
    }

    @Override
    protected String getDefaultName() {
        return this.field.getPropertyName();
    }

    @Override
    public AbstractBean<?, ?> getSpecializedBean() {
        return null;
    }

    @Override
    public boolean isSpecializing() {
        return false;
    }
}

