/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.interceptor.model;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.interceptor.InterceptorException;
import org.jboss.interceptor.model.InterceptionModel;
import org.jboss.interceptor.model.InterceptionType;
import org.jboss.interceptor.model.MethodHolder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterceptionModelImpl<T, I>
implements InterceptionModel<T, I> {
    private Map<InterceptionType, List<I>> globalInterceptors = new HashMap<InterceptionType, List<I>>();
    private Map<InterceptionType, Map<MethodHolder, List<I>>> methodBoundInterceptors = new HashMap<InterceptionType, Map<MethodHolder, List<I>>>();
    private Set<MethodHolder> methodsIgnoringGlobals = new HashSet<MethodHolder>();
    private Set<I> allInterceptors = new LinkedHashSet<I>();
    private T interceptedEntity;

    public InterceptionModelImpl(T interceptedEntity) {
        this.interceptedEntity = interceptedEntity;
    }

    @Override
    public List<I> getInterceptors(InterceptionType interceptionType, Method method) {
        if (interceptionType.isLifecycleCallback() && method != null) {
            throw new IllegalArgumentException("On a lifecycle callback, the associated method must be null");
        }
        if (!interceptionType.isLifecycleCallback() && method == null) {
            throw new IllegalArgumentException("Around-invoke and around-timeout interceptors are defined for a given method");
        }
        if (interceptionType.isLifecycleCallback()) {
            if (this.globalInterceptors.containsKey((Object)interceptionType)) {
                return this.globalInterceptors.get((Object)interceptionType);
            }
        } else {
            ArrayList returnedInterceptors = new ArrayList();
            if (!this.methodsIgnoringGlobals.contains(InterceptionModelImpl.methodHolder(method)) && this.globalInterceptors.containsKey((Object)interceptionType)) {
                returnedInterceptors.addAll(this.globalInterceptors.get((Object)interceptionType));
            }
            if (this.methodBoundInterceptors.containsKey((Object)interceptionType) && this.methodBoundInterceptors.get((Object)interceptionType).containsKey(InterceptionModelImpl.methodHolder(method))) {
                returnedInterceptors.addAll(this.methodBoundInterceptors.get((Object)interceptionType).get(InterceptionModelImpl.methodHolder(method)));
            }
            return returnedInterceptors;
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public Set<I> getAllInterceptors() {
        return Collections.unmodifiableSet(this.allInterceptors);
    }

    @Override
    public T getInterceptedEntity() {
        return this.interceptedEntity;
    }

    public void setIgnoresGlobals(Method method, boolean ignoresGlobals) {
        if (ignoresGlobals) {
            this.methodsIgnoringGlobals.add(InterceptionModelImpl.methodHolder(method));
        } else {
            this.methodsIgnoringGlobals.remove(InterceptionModelImpl.methodHolder(method));
        }
    }

    public void appendInterceptors(InterceptionType interceptionType, Method method, I ... interceptors) {
        if (null == method) {
            List<I> interceptorsList = this.globalInterceptors.get((Object)interceptionType);
            if (interceptorsList == null) {
                interceptorsList = new ArrayList<I>();
                this.globalInterceptors.put(interceptionType, interceptorsList);
            }
            this.appendInterceptorClassesToList(interceptionType, interceptorsList, interceptors);
        } else {
            List<I> interceptorsList;
            if (null == this.methodBoundInterceptors.get((Object)interceptionType)) {
                this.methodBoundInterceptors.put(interceptionType, new HashMap());
            }
            if ((interceptorsList = this.methodBoundInterceptors.get((Object)interceptionType).get(InterceptionModelImpl.methodHolder(method))) == null) {
                interceptorsList = new ArrayList<I>();
                this.methodBoundInterceptors.get((Object)interceptionType).put(InterceptionModelImpl.methodHolder(method), interceptorsList);
            }
            if (this.globalInterceptors.containsKey((Object)interceptionType)) {
                this.validateDuplicateInterceptors(interceptionType, this.globalInterceptors.get((Object)interceptionType), interceptors);
            }
            this.appendInterceptorClassesToList(interceptionType, interceptorsList, interceptors);
        }
        this.allInterceptors.addAll(Arrays.asList(interceptors));
    }

    private void appendInterceptorClassesToList(InterceptionType interceptionType, List<I> interceptorsList, I ... interceptors) {
        this.validateDuplicateInterceptors(interceptionType, interceptorsList, interceptors);
        interceptorsList.addAll(Arrays.asList(interceptors));
    }

    private void validateDuplicateInterceptors(InterceptionType interceptionType, List<I> interceptorsList, I[] interceptors) {
        for (I interceptor : interceptors) {
            if (!interceptorsList.contains(interceptor) || interceptionType == null) continue;
            throw new InterceptorException("Duplicate interceptor class definition when binding" + interceptor + " on " + interceptionType.name());
        }
    }

    private static MethodHolder methodHolder(Method method) {
        return MethodHolder.of(method, true);
    }
}

