/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.junit;

import java.util.function.Function;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.jboss.weld.injection.spi.JpaInjectionServices;
import org.jboss.weld.injection.spi.ResourceReference;
import org.jboss.weld.injection.spi.ResourceReferenceFactory;
import org.jboss.weld.injection.spi.helpers.SimpleResourceReference;

public class MockJpaInjectionServices
implements JpaInjectionServices {
    private final Function<InjectionPoint, Object> persistenceUnitFactory;
    private final Function<InjectionPoint, Object> persistenceContextFactory;

    public MockJpaInjectionServices(Function<InjectionPoint, Object> persistenceUnitFactory, Function<InjectionPoint, Object> persistenceContextFactory) {
        this.persistenceUnitFactory = persistenceUnitFactory;
        this.persistenceContextFactory = persistenceContextFactory;
    }

    public ResourceReferenceFactory<EntityManager> registerPersistenceContextInjectionPoint(final InjectionPoint injectionPoint) {
        return new ResourceReferenceFactory<EntityManager>(){

            public ResourceReference<EntityManager> createResource() {
                return new SimpleResourceReference((Object)MockJpaInjectionServices.this.resolvePersistenceContext(injectionPoint));
            }
        };
    }

    public ResourceReferenceFactory<EntityManagerFactory> registerPersistenceUnitInjectionPoint(final InjectionPoint injectionPoint) {
        return new ResourceReferenceFactory<EntityManagerFactory>(){

            public ResourceReference<EntityManagerFactory> createResource() {
                return new SimpleResourceReference((Object)MockJpaInjectionServices.this.resolvePersistenceUnit(injectionPoint));
            }
        };
    }

    public EntityManager resolvePersistenceContext(InjectionPoint injectionPoint) {
        if (this.persistenceContextFactory == null) {
            throw new IllegalStateException("Persistent context factory not set, cannot resolve injection point: " + injectionPoint);
        }
        Object context = this.persistenceContextFactory.apply(injectionPoint);
        if (context == null || context instanceof EntityManager) {
            return (EntityManager)context;
        }
        throw new IllegalStateException("Not an EntityManager instance: " + context);
    }

    public EntityManagerFactory resolvePersistenceUnit(InjectionPoint injectionPoint) {
        if (this.persistenceUnitFactory == null) {
            throw new IllegalStateException("Persistent unit factory not set, cannot resolve injection point: " + injectionPoint);
        }
        Object unit = this.persistenceUnitFactory.apply(injectionPoint);
        if (unit == null || unit instanceof EntityManagerFactory) {
            return (EntityManagerFactory)unit;
        }
        throw new IllegalStateException("Not an EntityManagerFactory instance: " + unit);
    }

    public void cleanup() {
    }
}

