/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean.interceptor;

import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.jboss.weld.Container;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedMethod;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedType;
import org.jboss.weld.annotated.slim.SlimAnnotatedType;
import org.jboss.weld.bean.interceptor.WeldAnnotatedMethodReader;
import org.jboss.weld.exceptions.InvalidObjectException;
import org.jboss.weld.interceptor.reader.DefaultMethodMetadata;
import org.jboss.weld.interceptor.spi.metadata.ClassMetadata;
import org.jboss.weld.interceptor.spi.metadata.MethodMetadata;
import org.jboss.weld.logging.messages.BeanMessage;
import org.jboss.weld.resources.ClassTransformer;
import org.jboss.weld.util.collections.WeldCollections;

public class WeldInterceptorClassMetadata<T>
implements ClassMetadata<T>,
Serializable {
    private static final long serialVersionUID = -5087425231467781559L;
    private final SlimAnnotatedType<T> type;
    private final WeldInterceptorClassMetadata<?> superclass;
    private final Map<Method, MethodMetadata> methodMetadata;

    private WeldInterceptorClassMetadata(EnhancedAnnotatedType<T> weldClass) {
        this.type = weldClass.slim();
        HashMap<Member, MethodMetadata> methodMetadataMap = new HashMap<Member, MethodMetadata>();
        for (EnhancedAnnotatedMethod<?, T> method : weldClass.getDeclaredEnhancedMethods()) {
            MethodMetadata methodMetadata = DefaultMethodMetadata.of(method, WeldAnnotatedMethodReader.getInstance());
            if (methodMetadata.getSupportedInterceptionTypes() == null || methodMetadata.getSupportedInterceptionTypes().size() == 0) continue;
            methodMetadataMap.put(method.getJavaMember(), methodMetadata);
        }
        this.methodMetadata = WeldCollections.immutableMap(methodMetadataMap);
        this.superclass = weldClass.getEnhancedSuperclass() == null || weldClass.getEnhancedSuperclass().getJavaClass().equals(Object.class) ? null : WeldInterceptorClassMetadata.of(weldClass.getEnhancedSuperclass());
    }

    public static <T> WeldInterceptorClassMetadata<T> of(EnhancedAnnotatedType<T> weldClass) {
        return new WeldInterceptorClassMetadata<T>(weldClass);
    }

    @Override
    public String getClassName() {
        return this.getJavaClass().getName();
    }

    @Override
    public Iterable<MethodMetadata> getDeclaredMethods() {
        return this.methodMetadata.values();
    }

    @Override
    public MethodMetadata getDeclaredMethod(Method method) {
        return this.methodMetadata.get(method);
    }

    @Override
    public Class<T> getJavaClass() {
        return this.type.getJavaClass();
    }

    @Override
    public ClassMetadata<?> getSuperclass() {
        return this.superclass;
    }

    private Object writeReplace() throws ObjectStreamException {
        return new SerializationProxy<T>(this.type);
    }

    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw new InvalidObjectException(BeanMessage.PROXY_REQUIRED, new Object[0]);
    }

    public String toString() {
        return "WeldInterceptorClassMetadata [type=" + this.type + "]";
    }

    private static class SerializationProxy<T>
    implements Serializable {
        private static final long serialVersionUID = 514950313251775936L;
        private final SlimAnnotatedType<T> type;

        public SerializationProxy(SlimAnnotatedType<T> type) {
            this.type = type;
        }

        private Object readResolve() throws ObjectStreamException {
            EnhancedAnnotatedType<T> enhancedType = Container.instance().services().get(ClassTransformer.class).getEnhancedAnnotatedType(this.type);
            return new WeldInterceptorClassMetadata(enhancedType);
        }
    }
}

