/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.web;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;
import org.jboss.seam.web.Pattern;
import org.jboss.seam.web.Rewrite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RewritingResponse
extends HttpServletResponseWrapper {
    private static LogProvider log = Logging.getLogProvider(RewritingResponse.class);
    private HttpServletRequest request;
    private Collection<Pattern> patterns;

    public RewritingResponse(HttpServletRequest request, HttpServletResponse response, Collection<Pattern> patterns) {
        super(response);
        this.request = request;
        this.patterns = patterns;
    }

    public String encodeRedirectUrl(String url) {
        return this.encodeRedirectURL(url);
    }

    public String encodeUrl(String url) {
        return this.encodeURL(url);
    }

    public String encodeRedirectURL(String url) {
        String result = this.rewriteURL(url);
        log.debug("encodeRedirectURL " + url + " -> " + result);
        return this.wrappedEncodeRedirectURL(result);
    }

    private String wrappedEncodeRedirectURL(String result) {
        ServletResponse response = this.getResponse();
        if (response instanceof HttpServletResponse) {
            return ((HttpServletResponse)response).encodeRedirectURL(result);
        }
        return result;
    }

    public String encodeURL(String url) {
        String result = super.encodeUrl(this.rewriteURL(url));
        log.debug("encodeURL " + url + " -> " + result);
        return this.wrappedEncodeURL(result);
    }

    private String wrappedEncodeURL(String result) {
        ServletResponse response = this.getResponse();
        if (response instanceof HttpServletResponse) {
            return ((HttpServletResponse)response).encodeRedirectURL(result);
        }
        return result;
    }

    public boolean isLocalURL(URL url) {
        return url.getHost().equals(this.request.getServerName());
    }

    public String rewritePath(String originalPath) {
        String contextPath = this.request.getContextPath();
        String path = originalPath.startsWith(contextPath) ? originalPath.substring(contextPath.length()) : originalPath;
        for (Pattern pattern : this.patterns) {
            Rewrite rewrite = pattern.matchOutgoing(path);
            if (rewrite == null) continue;
            return this.request.getContextPath() + rewrite.rewrite();
        }
        return originalPath;
    }

    public String rewriteURL(String originalUrl) {
        if (originalUrl.startsWith("http://") || originalUrl.startsWith("https://")) {
            try {
                URL url = new URL(originalUrl);
                if (this.isLocalURL(url)) {
                    URL newUrl = new URL(url, this.rewritePath(url.getFile()));
                    return newUrl.toExternalForm();
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return this.rewritePath(originalUrl);
    }
}

