/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.ioc.spring;

import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.core.Events;
import org.jboss.seam.ioc.spring.SpringComponent;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.config.Scope;

public class SeamScope
implements Scope {
    private static final LogProvider log = Logging.getLogProvider(SeamScope.class);
    private ScopeType scope;

    public SeamScope(ScopeType scope) {
        this.scope = scope;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(String name, ObjectFactory objectFactory) {
        try {
            SpringComponent.setObjectFactory(objectFactory);
            SpringComponent component = SpringComponent.forSpringBeanName(name);
            Object object = Component.getInstance((String)component.getName(), (ScopeType)this.scope, (boolean)true);
            return object;
        }
        finally {
            SpringComponent.setObjectFactory(null);
        }
    }

    public String getConversationId() {
        return null;
    }

    public void registerDestructionCallback(String name, Runnable callback) {
        SpringComponent.forSpringBeanName(name).registerDestroyCallback(name, callback);
    }

    public Object remove(String name) {
        log.debug((Object)("destroying: " + name));
        SpringComponent component = SpringComponent.forSpringBeanName(name);
        Object bean = null;
        if (component != null) {
            bean = this.scope.getContext().get(component.getName());
            if (bean != null) {
                if (Events.exists()) {
                    Events.instance().raiseEvent("org.jboss.seam.preDestroy." + name, new Object[0]);
                }
                try {
                    if (component.hasDestroyMethod()) {
                        component.callComponentMethod(bean, component.getDestroyMethod(), new Object[0]);
                    }
                }
                catch (Exception e) {
                    log.warn((Object)("Could not destroy component: " + component.getName()), (Throwable)e);
                }
            }
            this.scope.getContext().remove(component.getName());
        }
        return bean;
    }
}

