/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3.remote;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.Serializable;
import java.util.Arrays;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;
import org.jboss.remoting3.ChannelBusyException;
import org.jboss.remoting3.NotOpenException;
import org.jboss.remoting3.remote.RemoteConnection;
import org.jboss.remoting3.remote.RemoteLogger;

public class RemoteLogger_$logger
extends DelegatingBasicLogger
implements Serializable,
BasicLogger,
RemoteLogger {
    private static final long serialVersionUID = 1L;
    private static final String projectCode = "JBREM";
    private static final String FQCN = RemoteLogger_$logger.class.getName();
    private static final String exceptionInUserHandler = "An exception occurred in a message handler";
    private static final String writeInterrupted = "Write operation interrupted";
    private static final String channelNotOpen = "Channel is not open";
    private static final String failedToAccept = "Failed to accept a connection: %s";
    private static final String connectionError = "Remote connection failed: %s";
    private static final String abruptClose = "Abrupt close on %s";
    private static final String unknownProtocolId = "Message with unknown protocol ID %d received";
    private static final String bufferUnderflow = "Buffer underflow parsing message with protocol ID %02x";
    private static final String invalidMessage = "Received invalid message on %s";
    private static final String bufferUnderflowRaw = "Message missing protocol byte";
    private static final String channelBusy = "Failed to send a message (channel is busy)";

    public RemoteLogger_$logger(Logger log) {
        super(log);
    }

    @Override
    public final void exceptionInUserHandler(Throwable throwable) {
        this.log.logf(FQCN, Logger.Level.ERROR, throwable, "JBREM000209: " + this.exceptionInUserHandler$str(), new Object[0]);
    }

    protected String exceptionInUserHandler$str() {
        return exceptionInUserHandler;
    }

    @Override
    public final InterruptedIOException writeInterrupted() {
        InterruptedIOException result = new InterruptedIOException("JBREM000208: " + this.writeInterrupted$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String writeInterrupted$str() {
        return writeInterrupted;
    }

    @Override
    public final NotOpenException channelNotOpen() {
        NotOpenException result = new NotOpenException("JBREM000206: " + this.channelNotOpen$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String channelNotOpen$str() {
        return channelNotOpen;
    }

    @Override
    public final void failedToAccept(IOException e) {
        this.log.logf(FQCN, Logger.Level.WARN, null, "JBREM000205: " + this.failedToAccept$str(), (Object)e);
    }

    protected String failedToAccept$str() {
        return failedToAccept;
    }

    @Override
    public final void connectionError(IOException cause) {
        this.log.logf(FQCN, Logger.Level.ERROR, null, "JBREM000200: " + this.connectionError$str(), (Object)cause);
    }

    protected String connectionError$str() {
        return connectionError;
    }

    @Override
    public final IOException abruptClose(RemoteConnection connection) {
        IOException result = new IOException(String.format("JBREM000202: " + this.abruptClose$str(), connection));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String abruptClose$str() {
        return abruptClose;
    }

    @Override
    public final void unknownProtocolId(int id) {
        this.log.logf(FQCN, Logger.Level.TRACE, null, this.unknownProtocolId$str(), (Object)id);
    }

    protected String unknownProtocolId$str() {
        return unknownProtocolId;
    }

    @Override
    public final void bufferUnderflow(int id) {
        this.log.logf(FQCN, Logger.Level.WARN, null, "JBREM000204: " + this.bufferUnderflow$str(), (Object)id);
    }

    protected String bufferUnderflow$str() {
        return bufferUnderflow;
    }

    @Override
    public final IOException invalidMessage(RemoteConnection connection) {
        IOException result = new IOException(String.format("JBREM000201: " + this.invalidMessage$str(), connection));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidMessage$str() {
        return invalidMessage;
    }

    @Override
    public final void bufferUnderflowRaw() {
        this.log.logf(FQCN, Logger.Level.WARN, null, "JBREM000203: " + this.bufferUnderflowRaw$str(), new Object[0]);
    }

    protected String bufferUnderflowRaw$str() {
        return bufferUnderflowRaw;
    }

    @Override
    public final ChannelBusyException channelBusy() {
        ChannelBusyException result = new ChannelBusyException("JBREM000207: " + this.channelBusy$str());
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String channelBusy$str() {
        return channelBusy;
    }
}

