/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.narayana.jta.jms;

import com.arjuna.ats.arjuna.common.arjPropertyManager;
import com.arjuna.ats.jta.logging.jtaLogger;
import jakarta.jms.JMSException;
import jakarta.transaction.RollbackException;
import jakarta.transaction.Synchronization;
import jakarta.transaction.SystemException;
import jakarta.transaction.Transaction;
import jakarta.transaction.TransactionManager;
import javax.transaction.xa.XAResource;
import org.jboss.narayana.jta.jms.TransactionHelper;

public class TransactionHelperImpl
implements TransactionHelper {
    private final TransactionManager transactionManager;

    public TransactionHelperImpl(TransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    @Override
    public boolean isTransactionAvailable() throws JMSException {
        try {
            return this.transactionManager.getStatus() != 6;
        }
        catch (SystemException e) {
            if (arjPropertyManager.getCoreEnvironmentBean().isLogAndRethrow()) {
                jtaLogger.i18NLogger.warn_failed_to_get_transaction_status((Exception)((Object)e));
            }
            throw this.getJmsException(jtaLogger.i18NLogger.get_failed_to_get_transaction_status(), (Exception)((Object)e));
        }
    }

    @Override
    public void registerSynchronization(Synchronization synchronization) throws JMSException {
        try {
            this.getTransaction().registerSynchronization(synchronization);
        }
        catch (RollbackException | SystemException | IllegalStateException e) {
            if (arjPropertyManager.getCoreEnvironmentBean().isLogAndRethrow()) {
                jtaLogger.i18NLogger.warn_failed_to_register_synchronization((Exception)e);
            }
            throw this.getJmsException(jtaLogger.i18NLogger.get_failed_to_register_synchronization(), (Exception)e);
        }
    }

    @Override
    public void registerXAResource(XAResource xaResource) throws JMSException {
        try {
            if (!this.getTransaction().enlistResource(xaResource)) {
                if (arjPropertyManager.getCoreEnvironmentBean().isLogAndRethrow()) {
                    jtaLogger.i18NLogger.warn_failed_to_enlist_xa_resource(null);
                }
                throw this.getJmsException(jtaLogger.i18NLogger.get_failed_to_enlist_xa_resource(), null);
            }
        }
        catch (RollbackException | SystemException | IllegalStateException e) {
            if (arjPropertyManager.getCoreEnvironmentBean().isLogAndRethrow()) {
                jtaLogger.i18NLogger.warn_failed_to_enlist_xa_resource((Exception)e);
            }
            throw this.getJmsException(jtaLogger.i18NLogger.get_failed_to_enlist_xa_resource(), (Exception)e);
        }
    }

    @Override
    public void deregisterXAResource(XAResource xaResource) throws JMSException {
        try {
            if (!this.getTransaction().delistResource(xaResource, 0x4000000)) {
                if (arjPropertyManager.getCoreEnvironmentBean().isLogAndRethrow()) {
                    jtaLogger.i18NLogger.warn_failed_to_delist_xa_resource(null);
                }
                throw this.getJmsException(jtaLogger.i18NLogger.get_failed_to_delist_xa_resource(), null);
            }
        }
        catch (SystemException | IllegalStateException e) {
            if (arjPropertyManager.getCoreEnvironmentBean().isLogAndRethrow()) {
                jtaLogger.i18NLogger.warn_failed_to_delist_xa_resource((Exception)e);
            }
            throw this.getJmsException(jtaLogger.i18NLogger.get_failed_to_delist_xa_resource(), (Exception)e);
        }
    }

    private Transaction getTransaction() throws JMSException {
        try {
            return this.transactionManager.getTransaction();
        }
        catch (SystemException e) {
            if (arjPropertyManager.getCoreEnvironmentBean().isLogAndRethrow()) {
                jtaLogger.i18NLogger.warn_failed_to_get_transaction((Exception)((Object)e));
            }
            throw this.getJmsException(jtaLogger.i18NLogger.get_failed_to_get_transaction(), (Exception)((Object)e));
        }
    }

    private JMSException getJmsException(String message, Exception cause) {
        JMSException jmsException = new JMSException(message);
        jmsException.setLinkedException(cause);
        return jmsException;
    }
}

