/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dependency.plugins;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import org.jboss.dependency.spi.CallbackItem;
import org.jboss.dependency.spi.Controller;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.dependency.spi.DependencyInfo;
import org.jboss.dependency.spi.DependencyItem;
import org.jboss.dependency.spi.LifecycleCallbackItem;
import org.jboss.util.JBossObject;
import org.jboss.util.JBossStringBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractDependencyInfo
extends JBossObject
implements DependencyInfo {
    private Set<DependencyItem> iDependOn = new CopyOnWriteArraySet<DependencyItem>();
    private Set<DependencyItem> dependsOnMe = new CopyOnWriteArraySet<DependencyItem>();
    private Set<CallbackItem<?>> installCallbacks = new CopyOnWriteArraySet();
    private Set<CallbackItem<?>> uninstallCallbacks = new CopyOnWriteArraySet();
    private List<LifecycleCallbackItem> lifecycleCallbacks = new CopyOnWriteArrayList<LifecycleCallbackItem>();
    private boolean autowireCandidate = true;

    @Override
    public Set<DependencyItem> getIDependOn(Class<?> type) {
        if (type == null || this.iDependOn.isEmpty()) {
            return this.iDependOn;
        }
        HashSet<DependencyItem> set = new HashSet<DependencyItem>();
        for (DependencyItem item : this.iDependOn) {
            if (!type.isInstance(item)) continue;
            set.add(item);
        }
        return set;
    }

    @Override
    public void addIDependOn(DependencyItem dependency) {
        this.iDependOn.add(dependency);
        this.flushJBossObjectCache();
    }

    @Override
    public void removeIDependOn(DependencyItem dependency) {
        this.iDependOn.remove(dependency);
        this.flushJBossObjectCache();
    }

    @Override
    public Set<DependencyItem> getDependsOnMe(Class<?> type) {
        if (type == null || this.dependsOnMe.isEmpty()) {
            return this.dependsOnMe;
        }
        HashSet<DependencyItem> set = new HashSet<DependencyItem>();
        for (DependencyItem item : this.dependsOnMe) {
            if (!type.isInstance(item)) continue;
            set.add(item);
        }
        return set;
    }

    @Override
    public void addDependsOnMe(DependencyItem dependency) {
        this.dependsOnMe.add(dependency);
        this.flushJBossObjectCache();
    }

    @Override
    public void removeDependsOnMe(DependencyItem dependency) {
        this.dependsOnMe.remove(dependency);
        this.flushJBossObjectCache();
    }

    @Override
    public boolean resolveDependencies(Controller controller, ControllerState state) {
        boolean resolved = true;
        Set<DependencyItem> items = this.getUnresolvedDependencies(state);
        if (!items.isEmpty()) {
            for (DependencyItem item : items) {
                if (item.resolve(controller)) continue;
                resolved = false;
            }
        }
        return resolved;
    }

    @Override
    public Set<DependencyItem> getUnresolvedDependencies(ControllerState state) {
        if (this.iDependOn.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<DependencyItem> result = null;
        for (DependencyItem item : this.iDependOn) {
            if (state != null && !state.equals(item.getWhenRequired()) || item.isResolved()) continue;
            if (result == null) {
                result = new HashSet<DependencyItem>();
            }
            result.add(item);
        }
        if (result == null) {
            return Collections.emptySet();
        }
        return result;
    }

    @Override
    public <T> void addInstallItem(CallbackItem<T> callbackItem) {
        this.installCallbacks.add(callbackItem);
        this.flushJBossObjectCache();
    }

    @Override
    public <T> void removeInstallItem(CallbackItem<T> callbackItem) {
        this.installCallbacks.remove(callbackItem);
        this.flushJBossObjectCache();
    }

    @Override
    public Set<CallbackItem<?>> getInstallItems() {
        return this.installCallbacks;
    }

    @Override
    public <T> void addUninstallItem(CallbackItem<T> callbackItem) {
        this.uninstallCallbacks.add(callbackItem);
        this.flushJBossObjectCache();
    }

    @Override
    public <T> void removeUninstallItem(CallbackItem<T> callbackItem) {
        this.uninstallCallbacks.remove(callbackItem);
        this.flushJBossObjectCache();
    }

    @Override
    public Set<CallbackItem<?>> getUninstallItems() {
        return this.uninstallCallbacks;
    }

    @Override
    public void addLifecycleCallback(LifecycleCallbackItem lifecycleCallbackItem) {
        this.lifecycleCallbacks.add(lifecycleCallbackItem);
    }

    @Override
    public List<LifecycleCallbackItem> getLifecycleCallbacks() {
        return this.lifecycleCallbacks;
    }

    @Override
    public boolean isAutowireCandidate() {
        return this.autowireCandidate;
    }

    @Override
    public void setAutowireCandidate(boolean candidate) {
        this.autowireCandidate = candidate;
    }

    public void toString(JBossStringBuilder buffer) {
        buffer.append("idependOn=").append(this.iDependOn);
        try {
            Set<DependencyItem> unresolved = this.getUnresolvedDependencies(null);
            if (!unresolved.isEmpty()) {
                buffer.append(" unresolved=").append(unresolved);
            }
        }
        catch (Throwable ignored) {
            buffer.append(" unresolved=" + ignored);
        }
    }
}

