/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.server.profileservice.repository.clustered.sync;

import org.jboss.system.server.profileservice.repository.clustered.metadata.RepositoryContentMetadata;
import org.jboss.system.server.profileservice.repository.clustered.metadata.RepositoryItemMetadata;
import org.jboss.system.server.profileservice.repository.clustered.metadata.RepositoryRootMetadata;
import org.jboss.system.server.profileservice.repository.clustered.sync.SynchronizationPolicy;

public abstract class AbstractSynchronizationPolicy
implements SynchronizationPolicy {
    public static final long DEFAULT_REMOVAL_TRACKING_TIME = 2592000000L;
    private long removalTrackingTime = 2592000000L;
    private Boolean allowJoinAdditions;
    private Boolean allowJoinReincarnations;
    private Boolean allowJoinUpdates;
    private Boolean allowJoinRemovals;
    private Boolean allowMergeAdditions;
    private Boolean allowMergeReincarnations;
    private Boolean allowMergeUpdates;
    private Boolean allowMergeRemovals;
    private boolean developerMode = false;

    public Boolean getAllowJoinAdditions() {
        return this.allowJoinAdditions;
    }

    public void setAllowJoinAdditions(Boolean allow) {
        this.allowJoinAdditions = allow;
    }

    public Boolean getAllowJoinReincarnations() {
        return this.allowJoinReincarnations;
    }

    public void setAllowJoinReincarnations(Boolean allow) {
        this.allowJoinReincarnations = allow;
    }

    public Boolean getAllowJoinUpdates() {
        return this.allowJoinUpdates;
    }

    public void setAllowJoinUpdates(Boolean allow) {
        this.allowJoinUpdates = allow;
    }

    public Boolean getAllowJoinRemovals() {
        return this.allowJoinRemovals;
    }

    public void setAllowJoinRemovals(Boolean allow) {
        this.allowJoinRemovals = allow;
    }

    public Boolean getAllowMergeAdditions() {
        return this.allowMergeAdditions;
    }

    public void setAllowMergeAdditions(Boolean allow) {
        this.allowMergeAdditions = allow;
    }

    public Boolean getAllowMergeReincarnations() {
        return this.allowMergeReincarnations;
    }

    public void setAllowMergeReincarnations(Boolean allow) {
        this.allowMergeReincarnations = allow;
    }

    public Boolean getAllowMergeUpdates() {
        return this.allowMergeUpdates;
    }

    public void setAllowMergeUpdates(Boolean allow) {
        this.allowMergeUpdates = allow;
    }

    public Boolean getAllowMergeRemovals() {
        return this.allowMergeRemovals;
    }

    public void setAllowMergeRemovals(Boolean allow) {
        this.allowMergeRemovals = allow;
    }

    public boolean isDeveloperMode() {
        return this.developerMode;
    }

    public void setDeveloperMode(boolean developerMode) {
        this.developerMode = developerMode;
    }

    public long getRemovalTrackingTime() {
        return this.removalTrackingTime;
    }

    public void setRemovalTrackingTime(long removalTrackingTime) {
        this.removalTrackingTime = removalTrackingTime;
    }

    public boolean acceptJoinAddition(RepositoryItemMetadata toAdd, RepositoryItemMetadata joinersPrevious) {
        if (this.allowJoinAdditions != null) {
            return this.allowJoinAdditions;
        }
        AbstractSynchronizationPolicy.validateParams("toAdd", toAdd, true, null, false);
        return this.acceptAddition(toAdd, joinersPrevious, false);
    }

    public boolean acceptJoinReincarnation(RepositoryItemMetadata reincarnation, RepositoryItemMetadata current) {
        if (this.developerMode) {
            return true;
        }
        if (this.allowJoinReincarnations != null) {
            return this.allowJoinReincarnations;
        }
        AbstractSynchronizationPolicy.validateParams("reincarnation", reincarnation, true, current, true);
        return this.acceptReincarnation(reincarnation, current, false);
    }

    public boolean acceptJoinRemoval(RepositoryItemMetadata current, RepositoryItemMetadata joinersItem) {
        if (this.developerMode) {
            return true;
        }
        if (this.allowJoinRemovals != null) {
            return this.allowJoinRemovals;
        }
        AbstractSynchronizationPolicy.validateParams("toRemove", joinersItem, false, current, true);
        return this.acceptRemoval(current, joinersItem, false);
    }

    public boolean acceptJoinUpdate(RepositoryItemMetadata update, RepositoryItemMetadata current) {
        if (this.developerMode) {
            return true;
        }
        if (this.allowJoinUpdates != null) {
            return this.allowJoinUpdates;
        }
        AbstractSynchronizationPolicy.validateParams("update", update, true, current, true);
        return this.acceptUpdate(update, current, true);
    }

    public boolean acceptMergeAddition(RepositoryItemMetadata toAdd) {
        if (this.developerMode) {
            return true;
        }
        if (this.allowMergeAdditions != null) {
            return this.allowMergeAdditions;
        }
        AbstractSynchronizationPolicy.validateParams("toAdd", toAdd, true, null, false);
        return this.acceptAddition(toAdd, null, true);
    }

    public boolean acceptMergeReincarnation(RepositoryItemMetadata reincarnation, RepositoryItemMetadata current) {
        if (this.developerMode) {
            return true;
        }
        if (this.allowMergeReincarnations != null) {
            return this.allowMergeReincarnations;
        }
        AbstractSynchronizationPolicy.validateParams("reincarnation", reincarnation, true, current, true);
        return this.acceptReincarnation(reincarnation, current, true);
    }

    public boolean acceptMergeRemoval(RepositoryItemMetadata current, RepositoryItemMetadata mergersView) {
        if (this.developerMode) {
            return true;
        }
        if (this.allowMergeRemovals != null) {
            return this.allowMergeRemovals;
        }
        AbstractSynchronizationPolicy.validateParams("toRemove", mergersView, false, current, true);
        return this.acceptRemoval(current, mergersView, true);
    }

    public boolean acceptMergeUpdate(RepositoryItemMetadata update, RepositoryItemMetadata current) {
        if (this.developerMode) {
            return true;
        }
        if (this.allowMergeUpdates != null) {
            return this.allowMergeUpdates;
        }
        AbstractSynchronizationPolicy.validateParams("update", update, true, current, true);
        return this.acceptUpdate(update, current, true);
    }

    public boolean purgeRemovedItems(RepositoryContentMetadata content) {
        if (content == null) {
            return false;
        }
        boolean purged = false;
        long oldest = this.removalTrackingTime < 1L ? 0L : System.currentTimeMillis() - this.removalTrackingTime;
        for (RepositoryRootMetadata rrmd : content.getRepositories()) {
            for (RepositoryItemMetadata rimd : rrmd.getContent()) {
                if (!rimd.isRemoved() || rimd.getTimestamp() >= oldest) continue;
                rrmd.removeItemMetadata(rimd.getRelativePathElements());
                purged = true;
            }
        }
        return purged;
    }

    protected abstract boolean acceptAddition(RepositoryItemMetadata var1, RepositoryItemMetadata var2, boolean var3);

    protected abstract boolean acceptReincarnation(RepositoryItemMetadata var1, RepositoryItemMetadata var2, boolean var3);

    protected abstract boolean acceptRemoval(RepositoryItemMetadata var1, RepositoryItemMetadata var2, boolean var3);

    protected abstract boolean acceptUpdate(RepositoryItemMetadata var1, RepositoryItemMetadata var2, boolean var3);

    private static void validateParams(String changeName, RepositoryItemMetadata change, boolean requireChange, RepositoryItemMetadata current, boolean requireCurrent) {
        if (change == null && requireChange) {
            throw new IllegalArgumentException("Null " + changeName);
        }
        if (requireCurrent && current == null) {
            throw new IllegalArgumentException("Null current");
        }
    }
}

