/*     */ package org.quartz.jobs.ee.ejb;
/*     */ 
/*     */ import java.lang.reflect.InvocationTargetException;
/*     */ import java.lang.reflect.Method;
/*     */ import java.rmi.RemoteException;
/*     */ import java.util.Hashtable;
/*     */ import javax.ejb.EJBHome;
/*     */ import javax.ejb.EJBMetaData;
/*     */ import javax.ejb.EJBObject;
/*     */ import javax.naming.InitialContext;
/*     */ import javax.naming.NamingException;
/*     */ import javax.rmi.PortableRemoteObject;
/*     */ import org.quartz.Job;
/*     */ import org.quartz.JobDataMap;
/*     */ import org.quartz.JobDetail;
/*     */ import org.quartz.JobExecutionContext;
/*     */ import org.quartz.JobExecutionException;
/*     */ 
/*     */ public class EJBInvokerJob
/*     */   implements Job
/*     */ {
/*     */   public static final String EJB_JNDI_NAME_KEY = "ejb";
/*     */   public static final String EJB_METHOD_KEY = "method";
/*     */   public static final String EJB_ARG_TYPES_KEY = "argTypes";
/*     */   public static final String EJB_ARGS_KEY = "args";
/*     */   public static final String INITIAL_CONTEXT_FACTORY = "java.naming.factory.initial";
/*     */   public static final String PROVIDER_URL = "java.naming.provider.url";
/*     */   public static final String PRINCIPAL = "java.naming.security.principal";
/*     */   public static final String CREDENTIALS = "java.naming.security.credentials";
/*     */ 
/*     */   public void execute(JobExecutionContext context)
/*     */     throws JobExecutionException
/*     */   {
/* 126 */     JobDetail detail = context.getJobDetail();
/*     */ 
/* 128 */     JobDataMap dataMap = detail.getJobDataMap();
/*     */ 
/* 130 */     String ejb = dataMap.getString("ejb");
/* 131 */     String method = dataMap.getString("method");
/* 132 */     Object[] arguments = (Object[])dataMap.get("args");
/* 133 */     if (arguments == null) {
/* 134 */       arguments = new Object[0];
/*     */     }
/*     */ 
/* 137 */     if (ejb == null)
/*     */     {
/* 139 */       throw new JobExecutionException();
/*     */     }
/* 141 */     InitialContext jndiContext = null;
/*     */     try
/*     */     {
/* 145 */       jndiContext = getInitialContext(dataMap);
/*     */     } catch (NamingException ne) {
/* 147 */       throw new JobExecutionException(ne);
/*     */     }
/*     */ 
/* 150 */     Object value = null;
/*     */     try
/*     */     {
/* 154 */       value = jndiContext.lookup(ejb);
/*     */     } catch (NamingException ne) {
/* 156 */       throw new JobExecutionException(ne);
/*     */     } finally {
/* 158 */       if (jndiContext != null) {
/*     */         try {
/* 160 */           jndiContext.close();
/*     */         }
/*     */         catch (NamingException e)
/*     */         {
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/* 168 */     EJBHome ejbHome = (EJBHome)PortableRemoteObject.narrow(value, EJBHome.class);
/*     */ 
/* 172 */     EJBMetaData metaData = null;
/*     */     try
/*     */     {
/* 175 */       metaData = ejbHome.getEJBMetaData();
/*     */     } catch (RemoteException re) {
/* 177 */       throw new JobExecutionException(re);
/*     */     }
/*     */ 
/* 181 */     Class homeClass = metaData.getHomeInterfaceClass();
/*     */ 
/* 184 */     Class remoteClass = metaData.getRemoteInterfaceClass();
/*     */ 
/* 187 */     ejbHome = (EJBHome)PortableRemoteObject.narrow(ejbHome, homeClass);
/*     */ 
/* 189 */     Method methodCreate = null;
/*     */     try
/*     */     {
/* 193 */       methodCreate = homeClass.getDeclaredMethod("create", (Class[])null);
/*     */     } catch (NoSuchMethodException nsme) {
/* 195 */       throw new JobExecutionException(nsme);
/*     */     }
/*     */ 
/* 199 */     EJBObject remoteObj = null;
/*     */     try
/*     */     {
/* 203 */       remoteObj = (EJBObject)methodCreate.invoke(ejbHome, (Object[])null);
/*     */     } catch (IllegalAccessException iae) {
/* 205 */       throw new JobExecutionException(iae);
/*     */     } catch (InvocationTargetException ite) {
/* 207 */       throw new JobExecutionException(ite);
/*     */     }
/*     */ 
/* 211 */     Method methodExecute = null;
/*     */     try
/*     */     {
/* 216 */       Class[] argTypes = (Class[])dataMap.get("argTypes");
/* 217 */       if (argTypes == null) {
/* 218 */         argTypes = new Class[arguments.length];
/* 219 */         for (int i = 0; i < arguments.length; i++) {
/* 220 */           argTypes[i] = arguments[i].getClass();
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/* 225 */       methodExecute = remoteClass.getMethod(method, argTypes);
/*     */     } catch (NoSuchMethodException nsme) {
/* 227 */       throw new JobExecutionException(nsme);
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 232 */       methodExecute.invoke(remoteObj, arguments);
/*     */     } catch (IllegalAccessException iae) {
/* 234 */       throw new JobExecutionException(iae);
/*     */     } catch (InvocationTargetException ite) {
/* 236 */       throw new JobExecutionException(ite);
/*     */     }
/*     */   }
/*     */ 
/*     */   private InitialContext getInitialContext(JobDataMap jobDataMap) throws NamingException
/*     */   {
/* 242 */     Hashtable params = new Hashtable(2);
/*     */ 
/* 244 */     String initialContextFactory = jobDataMap.getString("java.naming.factory.initial");
/*     */ 
/* 246 */     if (initialContextFactory != null) {
/* 247 */       params.put("java.naming.factory.initial", initialContextFactory);
/*     */     }
/*     */ 
/* 250 */     String providerUrl = jobDataMap.getString("java.naming.provider.url");
/* 251 */     if (providerUrl != null) {
/* 252 */       params.put("java.naming.provider.url", providerUrl);
/*     */     }
/*     */ 
/* 255 */     String principal = jobDataMap.getString("java.naming.security.principal");
/* 256 */     if (principal != null) {
/* 257 */       params.put("java.naming.security.principal", principal);
/*     */     }
/*     */ 
/* 260 */     String credentials = jobDataMap.getString("java.naming.security.credentials");
/* 261 */     if (credentials != null) {
/* 262 */       params.put("java.naming.security.credentials", credentials);
/*     */     }
/*     */ 
/* 265 */     if (params.size() == 0)
/*     */     {
/* 267 */       return new InitialContext();
/*     */     }
/*     */ 
/* 271 */     return new InitialContext(params);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.quartz.jobs.ee.ejb.EJBInvokerJob
 * JD-Core Version:    0.6.0
 */