/*     */ package org.quartz.impl;
/*     */ 
/*     */ import java.util.Collection;
/*     */ import org.apache.commons.logging.Log;
/*     */ import org.apache.commons.logging.LogFactory;
/*     */ import org.quartz.Scheduler;
/*     */ import org.quartz.SchedulerException;
/*     */ import org.quartz.SchedulerFactory;
/*     */ import org.quartz.core.JobRunShellFactory;
/*     */ import org.quartz.core.QuartzScheduler;
/*     */ import org.quartz.core.QuartzSchedulerResources;
/*     */ import org.quartz.core.SchedulingContext;
/*     */ import org.quartz.simpl.CascadingClassLoadHelper;
/*     */ import org.quartz.simpl.RAMJobStore;
/*     */ import org.quartz.simpl.SimpleThreadPool;
/*     */ import org.quartz.spi.ClassLoadHelper;
/*     */ import org.quartz.spi.JobStore;
/*     */ import org.quartz.spi.ThreadPool;
/*     */ 
/*     */ public class DirectSchedulerFactory
/*     */   implements SchedulerFactory
/*     */ {
/*     */   public static final String DEFAULT_INSTANCE_ID = "SIMPLE_NON_CLUSTERED";
/*     */   public static final String DEFAULT_SCHEDULER_NAME = "SimpleQuartzScheduler";
/* 115 */   private boolean initialized = false;
/*     */ 
/* 117 */   private static DirectSchedulerFactory instance = new DirectSchedulerFactory();
/*     */ 
/*     */   private Log getLog()
/*     */   {
/* 128 */     return LogFactory.getLog(DirectSchedulerFactory.class);
/*     */   }
/*     */ 
/*     */   public static DirectSchedulerFactory getInstance()
/*     */   {
/* 146 */     return instance;
/*     */   }
/*     */ 
/*     */   public void createVolatileScheduler(int maxThreads)
/*     */     throws SchedulerException
/*     */   {
/* 160 */     SimpleThreadPool threadPool = new SimpleThreadPool(maxThreads, 5);
/*     */ 
/* 162 */     threadPool.initialize();
/* 163 */     JobStore jobStore = new RAMJobStore();
/* 164 */     createScheduler(threadPool, jobStore);
/*     */   }
/*     */ 
/*     */   /** @deprecated */
/*     */   public void createVolatileSchduler(int maxThreads)
/*     */     throws SchedulerException
/*     */   {
/* 174 */     createVolatileScheduler(maxThreads);
/*     */   }
/*     */ 
/*     */   public void createRemoteScheduler(String rmiHost, int rmiPort)
/*     */     throws SchedulerException
/*     */   {
/* 190 */     createRemoteScheduler("SimpleQuartzScheduler", "SIMPLE_NON_CLUSTERED", rmiHost, rmiPort);
/*     */ 
/* 192 */     this.initialized = true;
/*     */   }
/*     */ 
/*     */   protected void createRemoteScheduler(String schedulerName, String schedulerInstanceId, String rmiHost, int rmiPort)
/*     */     throws SchedulerException
/*     */   {
/* 216 */     SchedulingContext schedCtxt = new SchedulingContext();
/* 217 */     schedCtxt.setInstanceId(schedulerInstanceId);
/*     */ 
/* 219 */     String uid = QuartzSchedulerResources.getUniqueIdentifier(schedulerName, schedulerInstanceId);
/*     */ 
/* 222 */     RemoteScheduler remoteScheduler = new RemoteScheduler(schedCtxt, uid, rmiHost, rmiPort);
/*     */ 
/* 225 */     SchedulerRepository schedRep = SchedulerRepository.getInstance();
/* 226 */     schedRep.bind(remoteScheduler);
/*     */   }
/*     */ 
/*     */   public void createScheduler(ThreadPool threadPool, JobStore jobStore)
/*     */     throws SchedulerException
/*     */   {
/* 243 */     createScheduler("SimpleQuartzScheduler", "SIMPLE_NON_CLUSTERED", threadPool, jobStore);
/*     */ 
/* 245 */     this.initialized = true;
/*     */   }
/*     */ 
/*     */   public void createScheduler(String schedulerName, String schedulerInstanceId, ThreadPool threadPool, JobStore jobStore)
/*     */     throws SchedulerException
/*     */   {
/* 269 */     createScheduler(schedulerName, schedulerInstanceId, threadPool, jobStore, null, 0, -1L, -1L);
/*     */   }
/*     */ 
/*     */   public void createScheduler(String schedulerName, String schedulerInstanceId, ThreadPool threadPool, JobStore jobStore, String rmiRegistryHost, int rmiRegistryPort, long idleWaitTime, long dbFailureRetryInterval)
/*     */     throws SchedulerException
/*     */   {
/* 302 */     JobRunShellFactory jrsf = new StdJobRunShellFactory();
/*     */ 
/* 306 */     SchedulingContext schedCtxt = new SchedulingContext();
/* 307 */     schedCtxt.setInstanceId(schedulerInstanceId);
/*     */ 
/* 309 */     QuartzSchedulerResources qrs = new QuartzSchedulerResources();
/*     */ 
/* 311 */     qrs.setName(schedulerName);
/* 312 */     qrs.setInstanceId(schedulerInstanceId);
/* 313 */     qrs.setJobRunShellFactory(jrsf);
/* 314 */     qrs.setThreadPool(threadPool);
/* 315 */     qrs.setJobStore(jobStore);
/* 316 */     qrs.setRMIRegistryHost(rmiRegistryHost);
/* 317 */     qrs.setRMIRegistryPort(rmiRegistryPort);
/*     */ 
/* 319 */     QuartzScheduler qs = new QuartzScheduler(qrs, schedCtxt, idleWaitTime, dbFailureRetryInterval);
/*     */ 
/* 322 */     ClassLoadHelper cch = new CascadingClassLoadHelper();
/* 323 */     cch.initialize();
/*     */ 
/* 325 */     jobStore.initialize(cch, qs.getSchedulerSignaler());
/*     */ 
/* 327 */     Scheduler scheduler = new StdScheduler(qs, schedCtxt);
/*     */ 
/* 329 */     jrsf.initialize(scheduler, schedCtxt);
/*     */ 
/* 331 */     getLog().info("Quartz scheduler '" + scheduler.getSchedulerName());
/*     */ 
/* 333 */     getLog().info("Quartz scheduler version: " + qs.getVersion());
/*     */ 
/* 335 */     SchedulerRepository schedRep = SchedulerRepository.getInstance();
/*     */ 
/* 337 */     qs.addNoGCObject(schedRep);
/*     */ 
/* 340 */     schedRep.bind(scheduler);
/*     */   }
/*     */ 
/*     */   public Scheduler getScheduler()
/*     */     throws SchedulerException
/*     */   {
/* 362 */     if (!this.initialized) throw new SchedulerException("you must call createRemoteScheduler or createScheduler methods before calling getScheduler()");
/*     */ 
/* 364 */     SchedulerRepository schedRep = SchedulerRepository.getInstance();
/*     */ 
/* 366 */     return schedRep.lookup("SimpleQuartzScheduler");
/*     */   }
/*     */ 
/*     */   public Scheduler getScheduler(String schedName)
/*     */     throws SchedulerException
/*     */   {
/* 375 */     SchedulerRepository schedRep = SchedulerRepository.getInstance();
/*     */ 
/* 377 */     return schedRep.lookup(schedName);
/*     */   }
/*     */ 
/*     */   public Collection getAllSchedulers()
/*     */     throws SchedulerException
/*     */   {
/* 387 */     return SchedulerRepository.getInstance().lookupAll();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.quartz.impl.DirectSchedulerFactory
 * JD-Core Version:    0.6.0
 */