/*     */ package org.quartz.ee.jta;
/*     */ 
/*     */ import javax.naming.InitialContext;
/*     */ import javax.transaction.UserTransaction;
/*     */ import org.quartz.SchedulerConfigException;
/*     */ import org.quartz.SchedulerException;
/*     */ 
/*     */ public class UserTransactionHelper
/*     */ {
/*     */   public static final String DEFAULT_USER_TX_LOCATION = "java:comp/UserTransaction";
/*     */   private InitialContext ctxt;
/*     */   private UserTransaction ut;
/*     */   private String userTxURL;
/*     */ 
/*     */   public UserTransactionHelper(String userTxURL)
/*     */     throws SchedulerConfigException
/*     */   {
/*     */     try
/*     */     {
/*  80 */       this.ctxt = new InitialContext();
/*     */     } catch (Exception e) {
/*  82 */       throw new SchedulerConfigException("JTAJobRunShellFactory initialization failed.", e);
/*     */     }
/*     */ 
/*  85 */     setUserTxLocation(userTxURL);
/*     */   }
/*     */ 
/*     */   public String getUserTxLocation()
/*     */   {
/*  97 */     return this.userTxURL;
/*     */   }
/*     */ 
/*     */   public void setUserTxLocation(String userTxURL)
/*     */   {
/* 106 */     if (userTxURL == null) userTxURL = "java:comp/UserTransaction";
/*     */ 
/* 108 */     this.userTxURL = userTxURL;
/*     */   }
/*     */ 
/*     */   public UserTransaction lookup() throws SchedulerException {
/*     */     try {
/* 113 */       return (UserTransaction)this.ctxt.lookup(this.userTxURL); } catch (Exception nse) {
/*     */     }
/* 115 */     throw new SchedulerException("UserTransactionHelper could not lookup/create UserTransaction.", nse);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.quartz.ee.jta.UserTransactionHelper
 * JD-Core Version:    0.6.0
 */