/*     */ package org.quartz.ee.jta;
/*     */ 
/*     */ import javax.transaction.SystemException;
/*     */ import javax.transaction.UserTransaction;
/*     */ import org.apache.commons.logging.Log;
/*     */ import org.quartz.Scheduler;
/*     */ import org.quartz.SchedulerException;
/*     */ import org.quartz.core.JobRunShell;
/*     */ import org.quartz.core.JobRunShellFactory;
/*     */ import org.quartz.core.SchedulingContext;
/*     */ 
/*     */ public class JTAJobRunShell extends JobRunShell
/*     */ {
/*     */   private UserTransaction ut;
/*     */   private UserTransactionHelper userTxHelper;
/*     */ 
/*     */   public JTAJobRunShell(JobRunShellFactory jobRunShellFactory, Scheduler scheduler, SchedulingContext schdCtxt, UserTransactionHelper userTxHelper)
/*     */   {
/*  75 */     super(jobRunShellFactory, scheduler, schdCtxt);
/*     */ 
/*  77 */     this.userTxHelper = userTxHelper;
/*     */   }
/*     */ 
/*     */   protected void begin()
/*     */     throws SchedulerException
/*     */   {
/*     */     try
/*     */     {
/*  90 */       this.log.debug("Looking up UserTransaction.");
/*  91 */       this.ut = this.userTxHelper.lookup();
/*     */ 
/*  93 */       this.log.debug("Beginning UserTransaction.");
/*  94 */       this.ut.begin();
/*     */     } catch (SchedulerException se) {
/*  96 */       throw se;
/*     */     }
/*     */     catch (Exception nse) {
/*  99 */       throw new SchedulerException("JTAJobRunShell could not start UserTransaction.", nse);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void complete(boolean successfulExecution)
/*     */     throws SchedulerException
/*     */   {
/* 107 */     if (this.ut == null) return;
/*     */     try
/*     */     {
/* 110 */       if (this.ut.getStatus() == 1) {
/* 111 */         this.log.debug("UserTransaction marked for rollback only.");
/* 112 */         successfulExecution = false;
/*     */       }
/*     */     } catch (SystemException e) {
/* 115 */       throw new SchedulerException("JTAJobRunShell could not read UserTransaction status.", e);
/*     */     }
/*     */ 
/* 119 */     if (successfulExecution)
/*     */       try {
/* 121 */         this.log.debug("Committing UserTransaction.");
/* 122 */         this.ut.commit();
/*     */       } catch (Exception nse) {
/* 124 */         throw new SchedulerException("JTAJobRunShell could not commit UserTransaction.", nse);
/*     */       }
/*     */     else {
/*     */       try
/*     */       {
/* 129 */         this.log.debug("Rolling-back UserTransaction.");
/* 130 */         this.ut.rollback();
/*     */       } catch (Exception nse) {
/* 132 */         throw new SchedulerException("JTAJobRunShell could not rollback UserTransaction.", nse);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 138 */     this.ut = null;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.quartz.ee.jta.JTAJobRunShell
 * JD-Core Version:    0.6.0
 */