package org.quartz.core;

import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.quartz.Calendar;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobListener;
import org.quartz.SchedulerContext;
import org.quartz.SchedulerException;
import org.quartz.SchedulerListener;
import org.quartz.Trigger;
import org.quartz.TriggerListener;
import org.quartz.UnableToInterruptJobException;

public abstract interface RemotableQuartzScheduler extends Remote
{
  public abstract String getSchedulerName()
    throws RemoteException;

  public abstract String getSchedulerInstanceId()
    throws RemoteException;

  public abstract SchedulerContext getSchedulerContext()
    throws SchedulerException, RemoteException;

  public abstract void start()
    throws SchedulerException, RemoteException;

  public abstract void standby()
    throws RemoteException;

  public abstract boolean isInStandbyMode()
    throws RemoteException;

  public abstract void shutdown()
    throws RemoteException;

  public abstract void shutdown(boolean paramBoolean)
    throws RemoteException;

  public abstract boolean isShutdown()
    throws RemoteException;

  public abstract Date runningSince()
    throws RemoteException;

  public abstract String getVersion()
    throws RemoteException;

  public abstract int numJobsExecuted()
    throws RemoteException;

  public abstract Class getJobStoreClass()
    throws RemoteException;

  public abstract boolean supportsPersistence()
    throws RemoteException;

  public abstract Class getThreadPoolClass()
    throws RemoteException;

  public abstract int getThreadPoolSize()
    throws RemoteException;

  public abstract List getCurrentlyExecutingJobs()
    throws SchedulerException, RemoteException;

  public abstract Date scheduleJob(SchedulingContext paramSchedulingContext, JobDetail paramJobDetail, Trigger paramTrigger)
    throws SchedulerException, RemoteException;

  public abstract Date scheduleJob(SchedulingContext paramSchedulingContext, Trigger paramTrigger)
    throws SchedulerException, RemoteException;

  public abstract void addJob(SchedulingContext paramSchedulingContext, JobDetail paramJobDetail, boolean paramBoolean)
    throws SchedulerException, RemoteException;

  public abstract boolean deleteJob(SchedulingContext paramSchedulingContext, String paramString1, String paramString2)
    throws SchedulerException, RemoteException;

  public abstract boolean unscheduleJob(SchedulingContext paramSchedulingContext, String paramString1, String paramString2)
    throws SchedulerException, RemoteException;

  public abstract Date rescheduleJob(SchedulingContext paramSchedulingContext, String paramString1, String paramString2, Trigger paramTrigger)
    throws SchedulerException, RemoteException;

  public abstract void triggerJob(SchedulingContext paramSchedulingContext, String paramString1, String paramString2, JobDataMap paramJobDataMap)
    throws SchedulerException, RemoteException;

  public abstract void triggerJobWithVolatileTrigger(SchedulingContext paramSchedulingContext, String paramString1, String paramString2, JobDataMap paramJobDataMap)
    throws SchedulerException, RemoteException;

  public abstract void pauseTrigger(SchedulingContext paramSchedulingContext, String paramString1, String paramString2)
    throws SchedulerException, RemoteException;

  public abstract void pauseTriggerGroup(SchedulingContext paramSchedulingContext, String paramString)
    throws SchedulerException, RemoteException;

  public abstract void pauseJob(SchedulingContext paramSchedulingContext, String paramString1, String paramString2)
    throws SchedulerException, RemoteException;

  public abstract void pauseJobGroup(SchedulingContext paramSchedulingContext, String paramString)
    throws SchedulerException, RemoteException;

  public abstract void resumeTrigger(SchedulingContext paramSchedulingContext, String paramString1, String paramString2)
    throws SchedulerException, RemoteException;

  public abstract void resumeTriggerGroup(SchedulingContext paramSchedulingContext, String paramString)
    throws SchedulerException, RemoteException;

  public abstract Set getPausedTriggerGroups(SchedulingContext paramSchedulingContext)
    throws SchedulerException, RemoteException;

  public abstract void resumeJob(SchedulingContext paramSchedulingContext, String paramString1, String paramString2)
    throws SchedulerException, RemoteException;

  public abstract void resumeJobGroup(SchedulingContext paramSchedulingContext, String paramString)
    throws SchedulerException, RemoteException;

  public abstract void pauseAll(SchedulingContext paramSchedulingContext)
    throws SchedulerException, RemoteException;

  public abstract void resumeAll(SchedulingContext paramSchedulingContext)
    throws SchedulerException, RemoteException;

  public abstract String[] getJobGroupNames(SchedulingContext paramSchedulingContext)
    throws SchedulerException, RemoteException;

  public abstract String[] getJobNames(SchedulingContext paramSchedulingContext, String paramString)
    throws SchedulerException, RemoteException;

  public abstract Trigger[] getTriggersOfJob(SchedulingContext paramSchedulingContext, String paramString1, String paramString2)
    throws SchedulerException, RemoteException;

  public abstract String[] getTriggerGroupNames(SchedulingContext paramSchedulingContext)
    throws SchedulerException, RemoteException;

  public abstract String[] getTriggerNames(SchedulingContext paramSchedulingContext, String paramString)
    throws SchedulerException, RemoteException;

  public abstract JobDetail getJobDetail(SchedulingContext paramSchedulingContext, String paramString1, String paramString2)
    throws SchedulerException, RemoteException;

  public abstract Trigger getTrigger(SchedulingContext paramSchedulingContext, String paramString1, String paramString2)
    throws SchedulerException, RemoteException;

  public abstract int getTriggerState(SchedulingContext paramSchedulingContext, String paramString1, String paramString2)
    throws SchedulerException, RemoteException;

  public abstract void addCalendar(SchedulingContext paramSchedulingContext, String paramString, Calendar paramCalendar, boolean paramBoolean1, boolean paramBoolean2)
    throws SchedulerException, RemoteException;

  public abstract boolean deleteCalendar(SchedulingContext paramSchedulingContext, String paramString)
    throws SchedulerException, RemoteException;

  public abstract Calendar getCalendar(SchedulingContext paramSchedulingContext, String paramString)
    throws SchedulerException, RemoteException;

  public abstract String[] getCalendarNames(SchedulingContext paramSchedulingContext)
    throws SchedulerException, RemoteException;

  public abstract void addGlobalJobListener(JobListener paramJobListener)
    throws RemoteException;

  public abstract void addJobListener(JobListener paramJobListener)
    throws RemoteException;

  public abstract boolean removeGlobalJobListener(JobListener paramJobListener)
    throws RemoteException;

  public abstract boolean removeJobListener(String paramString)
    throws RemoteException;

  public abstract List getGlobalJobListeners()
    throws RemoteException;

  public abstract Set getJobListenerNames()
    throws RemoteException;

  public abstract JobListener getJobListener(String paramString)
    throws RemoteException;

  public abstract void addGlobalTriggerListener(TriggerListener paramTriggerListener)
    throws RemoteException;

  public abstract void addTriggerListener(TriggerListener paramTriggerListener)
    throws RemoteException;

  public abstract boolean removeGlobalTriggerListener(TriggerListener paramTriggerListener)
    throws RemoteException;

  public abstract boolean removeTriggerListener(String paramString)
    throws RemoteException;

  public abstract List getGlobalTriggerListeners()
    throws RemoteException;

  public abstract Set getTriggerListenerNames()
    throws RemoteException;

  public abstract TriggerListener getTriggerListener(String paramString)
    throws RemoteException;

  public abstract void addSchedulerListener(SchedulerListener paramSchedulerListener)
    throws RemoteException;

  public abstract boolean removeSchedulerListener(SchedulerListener paramSchedulerListener)
    throws RemoteException;

  public abstract List getSchedulerListeners()
    throws RemoteException;

  public abstract boolean interrupt(SchedulingContext paramSchedulingContext, String paramString1, String paramString2)
    throws UnableToInterruptJobException, RemoteException;
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.quartz.core.RemotableQuartzScheduler
 * JD-Core Version:    0.6.0
 */