package org.hsqldb.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class SqlTool
{
  private static final String DEFAULT_RCFILE = System.getProperty("user.home") + "/sqltool.rc";
  private static String revnum = null;
  public static final int SQLTOOLERR_EXITVAL = 1;
  public static final int SYNTAXERR_EXITVAL = 11;
  public static final int RCERR_EXITVAL = 2;
  public static final int SQLERR_EXITVAL = 3;
  public static final int IOERR_EXITVAL = 4;
  public static final int FILEERR_EXITVAL = 5;
  public static final int INPUTERR_EXITVAL = 6;
  public static final int CONNECTERR_EXITVAL = 7;
  private static String CMDLINE_ID = "cmdline";
  private static SqltoolRB rb = null;
  public static String LS;
  private static BadCmdline bcl;

  private static String promptForPassword(String paramString)
    throws SqlTool.PrivateException
  {
    String str = null;
    try
    {
      BufferedReader localBufferedReader = new BufferedReader(new InputStreamReader(System.in));
      System.out.print(rb.getString(SqltoolRB.PASSWORDFOR_PROMPT, RCData.expandSysPropVars(paramString)));
      str = localBufferedReader.readLine();
      if (str == null)
        str = "";
      else
        str = str.trim();
    }
    catch (IOException localIOException)
    {
      throw new PrivateException(localIOException.getMessage());
    }
    return str;
  }

  private static void varParser(String paramString, Map paramMap, boolean paramBoolean)
    throws SqlTool.PrivateException
  {
    if ((paramMap == null) || (paramString == null))
      throw new IllegalArgumentException("varMap or varString are null in SqlTool.varParser call");
    String[] arrayOfString = paramString.split("\\s*,\\s*");
    for (int j = 0; j < arrayOfString.length; j++)
    {
      int i = arrayOfString[j].indexOf('=');
      if (i < 1)
        throw new PrivateException(rb.getString(SqltoolRB.SQLTOOL_VARSET_BADFORMAT));
      String str1 = arrayOfString[j].substring(0, i).trim();
      String str2 = arrayOfString[j].substring(i + 1).trim();
      if (str1.length() < 1)
        throw new PrivateException(rb.getString(SqltoolRB.SQLTOOL_VARSET_BADFORMAT));
      if (paramBoolean)
        str1 = str1.toLowerCase();
      paramMap.put(str1, str2);
    }
  }

  public static void main(String[] paramArrayOfString)
  {
    try
    {
      objectMain(paramArrayOfString);
    }
    catch (SqlToolException localSqlToolException)
    {
      if (localSqlToolException.getMessage() != null)
        System.err.println(localSqlToolException.getMessage());
      System.exit(localSqlToolException.exitValue);
    }
    System.exit(0);
  }

  public static void objectMain(String[] paramArrayOfString)
    throws SqlTool.SqlToolException
  {
    String str1 = null;
    File localFile1 = null;
    String str2 = null;
    String str3 = null;
    String str4 = null;
    String str5 = null;
    int i = 0;
    Object localObject1 = null;
    int j = -1;
    int k = 0;
    boolean bool1 = false;
    int m = 0;
    int n = 0;
    boolean bool2 = false;
    Boolean localBoolean1 = null;
    Boolean localBoolean2 = null;
    String str6 = null;
    String str7 = null;
    String str8 = null;
    String str9 = null;
    String str10 = null;
    String str11 = null;
    HashMap localHashMap1 = null;
    try
    {
      while ((j + 1 < paramArrayOfString.length) && (paramArrayOfString[(j + 1)].startsWith("--")))
      {
        j++;
        if (paramArrayOfString[j].length() == 2)
          break;
        String str12 = paramArrayOfString[j].substring(2).toLowerCase();
        if (str12.equals("help"))
        {
          System.out.println(rb.getString(SqltoolRB.SQLTOOL_SYNTAX, revnum, "org.hsqldb.jdbcDriver"));
          return;
        }
        if (str12.equals("abortonerr"))
        {
          if (localBoolean1 != null)
            throw new SqlToolException(11, rb.getString(SqltoolRB.SQLTOOL_ABORTCONTINUE_MUTUALLYEXCLUSIVE));
          localBoolean1 = Boolean.FALSE;
          continue;
        }
        if (str12.equals("continueonerr"))
        {
          if (localBoolean1 != null)
            throw new SqlToolException(11, rb.getString(SqltoolRB.SQLTOOL_ABORTCONTINUE_MUTUALLYEXCLUSIVE));
          localBoolean1 = Boolean.TRUE;
          continue;
        }
        if (str12.equals("list"))
        {
          k = 1;
          continue;
        }
        if (str12.equals("rcfile"))
        {
          j++;
          if (j == paramArrayOfString.length)
            throw bcl;
          str1 = paramArrayOfString[j];
          continue;
        }
        if (str12.equals("setvar"))
        {
          j++;
          if (j == paramArrayOfString.length)
            throw bcl;
          str5 = paramArrayOfString[j];
          continue;
        }
        if (str12.equals("sql"))
        {
          m = 1;
          j++;
          if (j == paramArrayOfString.length)
            throw bcl;
          str2 = paramArrayOfString[j];
          continue;
        }
        if (str12.equals("debug"))
        {
          i = 1;
          continue;
        }
        if (str12.equals("noautofile"))
        {
          n = 1;
          continue;
        }
        if (str12.equals("autocommit"))
        {
          bool2 = true;
          continue;
        }
        if (str12.equals("stdinput"))
        {
          m = 0;
          localBoolean2 = Boolean.TRUE;
          continue;
        }
        if (str12.equals("noinput"))
        {
          m = 1;
          localBoolean2 = Boolean.FALSE;
          continue;
        }
        if (str12.equals("driver"))
        {
          j++;
          if (j == paramArrayOfString.length)
            throw bcl;
          str3 = paramArrayOfString[j];
          continue;
        }
        if (str12.equals("inlinerc"))
        {
          j++;
          if (j == paramArrayOfString.length)
            throw bcl;
          str6 = paramArrayOfString[j];
          continue;
        }
        throw bcl;
      }
      if ((k == 0) && (str6 == null))
      {
        j++;
        if (j == paramArrayOfString.length)
          throw bcl;
        str4 = paramArrayOfString[j];
      }
      int i1 = 0;
      if (str2 != null)
        try
        {
          localFile1 = File.createTempFile("sqltool-", ".sql");
          FileWriter localFileWriter = new FileWriter(localFile1);
          try
          {
            localFileWriter.write("/* " + new Date() + ".  " + SqlTool.class.getName() + " command-line SQL. */" + LS + LS);
            localFileWriter.write(str2 + LS);
            localFileWriter.flush();
          }
          finally
          {
            localFileWriter.close();
          }
        }
        catch (IOException localIOException1)
        {
          throw new SqlToolException(4, rb.getString(SqltoolRB.SQLTEMPFILE_FAIL, localIOException1.toString()));
        }
      if (localBoolean2 != null)
        m = !localBoolean2.booleanValue() ? 1 : 0;
      bool1 = (m == 0) && (paramArrayOfString.length <= j + 1);
      if ((paramArrayOfString.length == j + 2) && (paramArrayOfString[(j + 1)].equals("-")))
      {
        if (localBoolean2 == null)
          m = 0;
      }
      else if (paramArrayOfString.length > j + 1)
      {
        localObject1 = new File[paramArrayOfString.length - j - 1 + ((localBoolean2 == null) || (!localBoolean2.booleanValue()) ? 0 : 1)];
        if (i != 0)
          System.err.println("scriptFiles has " + localObject1.length + " elements");
        while (j + 1 < paramArrayOfString.length)
        {
          j++;
          localObject1[(i1++)] = new File(paramArrayOfString[j]);
        }
        if ((localBoolean2 != null) && (localBoolean2.booleanValue()))
        {
          localObject1[(i1++)] = null;
          m = 1;
        }
      }
    }
    catch (BadCmdline localBadCmdline)
    {
      throw new SqlToolException(11, rb.getString(SqltoolRB.SQLTOOL_SYNTAX, revnum, "org.hsqldb.jdbcDriver"));
    }
    RCData localRCData = null;
    if (str6 != null)
    {
      localHashMap1 = new HashMap();
      try
      {
        varParser(str6, localHashMap1, true);
      }
      catch (PrivateException localPrivateException1)
      {
        throw new SqlToolException(11, localPrivateException1.getMessage());
      }
      str7 = (String)localHashMap1.remove("url");
      str8 = (String)localHashMap1.remove("user");
      str10 = (String)localHashMap1.remove("charset");
      str11 = (String)localHashMap1.remove("truststore");
      str9 = (String)localHashMap1.remove("password");
      if ((str7 == null) || (str7.length() < 1))
        throw new SqlToolException(2, rb.getString(SqltoolRB.RCDATA_INLINEURL_MISSING));
      if ((str8 == null) || (str8.length() < 1))
        throw new SqlToolException(2, rb.getString(SqltoolRB.RCDATA_INLINEUSERNAME_MISSING));
      if ((str9 != null) && (str9.length() > 0))
        throw new SqlToolException(2, rb.getString(SqltoolRB.RCDATA_PASSWORD_VISIBLE));
      if (localHashMap1.size() > 0)
        throw new SqlToolException(6, rb.getString(SqltoolRB.RCDATA_INLINE_EXTRAVARS, localHashMap1.keySet().toString()));
      if (str9 == null)
        try
        {
          str9 = promptForPassword(str8);
        }
        catch (PrivateException localPrivateException2)
        {
          throw new SqlToolException(6, rb.getString(SqltoolRB.PASSWORD_READFAIL, localPrivateException2.getMessage()));
        }
      try
      {
        localRCData = new RCData(CMDLINE_ID, str7, str8, str9, str3, str10, str11);
      }
      catch (Exception localException1)
      {
        throw new SqlToolException(2, rb.getString(SqltoolRB.RCDATA_GENFROMVALUES_FAIL, localException1.getMessage()));
      }
    }
    else
    {
      try
      {
        localRCData = new RCData(new File(str1 == null ? DEFAULT_RCFILE : str1), str4);
      }
      catch (Exception localException2)
      {
        throw new SqlToolException(2, rb.getString(SqltoolRB.CONNDATA_RETRIEVAL_FAIL, str4, localException2.getMessage()));
      }
    }
    if (k != 0)
      return;
    if (i != 0)
      localRCData.report();
    Connection localConnection = null;
    try
    {
      localConnection = localRCData.getConnection(str3, System.getProperty("sqlfile.charset"), System.getProperty("javax.net.ssl.trustStore"));
      localConnection.setAutoCommit(bool2);
      DatabaseMetaData localDatabaseMetaData = null;
      if ((bool1) && ((localDatabaseMetaData = localConnection.getMetaData()) != null))
        System.out.println(rb.getString(SqltoolRB.JDBC_ESTABLISHED, localDatabaseMetaData.getDatabaseProductName(), localDatabaseMetaData.getDatabaseProductVersion(), localDatabaseMetaData.getUserName()));
    }
    catch (Exception localException3)
    {
      throw new SqlToolException(7, rb.getString(SqltoolRB.CONNECTION_FAIL, localRCData.url, localRCData.username, localException3.getMessage()));
    }
    File[] arrayOfFile1 = new File[0];
    File[] arrayOfFile2 = { null };
    File localFile2 = null;
    if ((bool1) && (n == 0))
    {
      localFile2 = new File(System.getProperty("user.home") + "/auto.sql");
      if ((!localFile2.isFile()) || (!localFile2.canRead()))
        localFile2 = null;
    }
    if (localObject1 == null)
      localObject1 = m != 0 ? arrayOfFile1 : arrayOfFile2;
    int i2 = localObject1.length;
    if (localFile1 != null)
      i2++;
    if (localFile2 != null)
      i2++;
    SqlFile[] arrayOfSqlFile = new SqlFile[i2];
    HashMap localHashMap2 = new HashMap();
    if (str5 != null)
      try
      {
        varParser(str5, localHashMap2, false);
      }
      catch (PrivateException localPrivateException3)
      {
        throw new SqlToolException(2, localPrivateException3.getMessage());
      }
    int i3 = -1;
    try
    {
      int i4 = 0;
      if (localFile2 != null)
        arrayOfSqlFile[(i4++)] = new SqlFile(localFile2, false, localHashMap2);
      if (localFile1 != null)
        arrayOfSqlFile[(i4++)] = new SqlFile(localFile1, false, localHashMap2);
      for (int i6 = 0; i6 < localObject1.length; i6++)
      {
        if ((i3 < 0) && (bool1))
          i3 = i4;
        arrayOfSqlFile[(i4++)] = new SqlFile(localObject1[i6], bool1, localHashMap2);
      }
    }
    catch (IOException localIOException2)
    {
      try
      {
        localConnection.close();
      }
      catch (Exception localException5)
      {
      }
      throw new SqlToolException(5, localIOException2.getMessage());
    }
    try
    {
      for (int i5 = 0; i5 < arrayOfSqlFile.length; i5++)
      {
        if (i5 == i3)
          System.out.print("SqlTool v. " + revnum + ".                        ");
        arrayOfSqlFile[i5].execute(localConnection, localBoolean1);
      }
    }
    catch (SqlToolError localSqlToolError)
    {
      throw new SqlToolException(1);
    }
    catch (SQLException localSQLException)
    {
      throw new SqlToolException(3);
    }
    finally
    {
      try
      {
        localConnection.close();
      }
      catch (Exception localException6)
      {
      }
    }
    if ((localFile1 != null) && (!localFile1.delete()))
      System.err.println(localRCData.url + rb.getString(SqltoolRB.TEMPFILE_REMOVAL_FAIL, localFile1.toString()));
  }

  static
  {
    revnum = "333";
    try
    {
      rb = new SqltoolRB();
      rb.validate();
      rb.setMissingPosValueBehavior(2);
      rb.setMissingPropertyBehavior(2);
    }
    catch (RuntimeException localRuntimeException)
    {
      System.err.println("Failed to initialize resource bundle");
      throw localRuntimeException;
    }
    LS = System.getProperty("line.separator");
    bcl = new BadCmdline();
  }

  public static class SqlToolException extends Exception
  {
    static final long serialVersionUID = 1424909871915188519L;
    int exitValue = 1;

    SqlToolException(String paramString, int paramInt)
    {
      super();
      this.exitValue = paramInt;
    }

    SqlToolException(int paramInt, String paramString)
    {
      this(paramString, paramInt);
    }

    SqlToolException(int paramInt)
    {
      this.exitValue = paramInt;
    }
  }

  private static class PrivateException extends Exception
  {
    static final long serialVersionUID = -7765061479594523462L;

    PrivateException()
    {
    }

    PrivateException(String paramString)
    {
      super();
    }
  }

  private static class BadCmdline extends Exception
  {
    static final long serialVersionUID = -2134764796788108325L;
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.hsqldb.util.SqlTool
 * JD-Core Version:    0.6.0
 */