package org.hsqldb.store;

import java.util.NoSuchElementException;
import org.hsqldb.lib.ArrayCounter;
import org.hsqldb.lib.Iterator;

public class BaseHashMap
{
  boolean isIntKey;
  boolean isLongKey;
  boolean isObjectKey;
  boolean isNoValue;
  boolean isIntValue;
  boolean isLongValue;
  boolean isObjectValue;
  protected HashIndex hashIndex;
  protected int[] intKeyTable;
  protected Object[] objectKeyTable;
  protected long[] longKeyTable;
  protected int[] intValueTable;
  protected Object[] objectValueTable;
  protected long[] longValueTable;
  int accessMin;
  int accessCount;
  int[] accessTable;
  final float loadFactor;
  final int initialCapacity;
  int threshold;
  int maxCapacity;
  protected int purgePolicy = 0;
  protected boolean minimizeOnEmpty;
  boolean hasZeroKey;
  int zeroKeyIndex = -1;
  protected static final int noKeyOrValue = 0;
  protected static final int intKeyOrValue = 1;
  protected static final int longKeyOrValue = 2;
  protected static final int objectKeyOrValue = 3;
  protected static final int NO_PURGE = 0;
  protected static final int PURGE_ALL = 1;
  protected static final int PURGE_HALF = 2;
  protected static final int PURGE_QUARTER = 3;

  protected BaseHashMap(int paramInt1, float paramFloat, int paramInt2, int paramInt3, boolean paramBoolean)
    throws IllegalArgumentException
  {
    if ((paramInt1 <= 0) || (paramFloat <= 0.0D))
      throw new IllegalArgumentException();
    this.loadFactor = paramFloat;
    this.initialCapacity = paramInt1;
    this.threshold = paramInt1;
    if (this.threshold < 3)
      this.threshold = 3;
    int i = (int)(paramInt1 * paramFloat);
    if (i < 3)
      i = 3;
    this.hashIndex = new HashIndex(i, paramInt1, true);
    int j = this.threshold;
    if (paramInt2 == 1)
    {
      this.isIntKey = true;
      this.intKeyTable = new int[j];
    }
    else if (paramInt2 == 3)
    {
      this.isObjectKey = true;
      this.objectKeyTable = new Object[j];
    }
    else
    {
      this.isLongKey = true;
      this.longKeyTable = new long[j];
    }
    if (paramInt3 == 1)
    {
      this.isIntValue = true;
      this.intValueTable = new int[j];
    }
    else if (paramInt3 == 3)
    {
      this.isObjectValue = true;
      this.objectValueTable = new Object[j];
    }
    else if (paramInt3 == 2)
    {
      this.isLongValue = true;
      this.longValueTable = new long[j];
    }
    else
    {
      this.isNoValue = true;
    }
    if (paramBoolean)
      this.accessTable = new int[j];
  }

  protected int getLookup(Object paramObject, int paramInt)
  {
    for (int i = this.hashIndex.getLookup(paramInt); i >= 0; i = this.hashIndex.getNextLookup(i))
    {
      Object localObject = this.objectKeyTable[i];
      if (paramObject.equals(localObject))
        return i;
    }
    return i;
  }

  protected int getLookup(int paramInt)
  {
    for (int i = this.hashIndex.getLookup(paramInt); i >= 0; i = this.hashIndex.getNextLookup(i))
    {
      int j = this.intKeyTable[i];
      if (paramInt == j)
        return i;
    }
    return i;
  }

  protected int getLookup(long paramLong)
  {
    for (int i = this.hashIndex.getLookup((int)paramLong); i >= 0; i = this.hashIndex.getNextLookup(i))
    {
      long l = this.longKeyTable[i];
      if (paramLong == l)
        return i;
    }
    return i;
  }

  protected Object addOrRemove(long paramLong1, long paramLong2, Object paramObject1, Object paramObject2, boolean paramBoolean)
  {
    int i = (int)paramLong1;
    if (this.isObjectKey)
    {
      if (paramObject1 == null)
        return null;
      i = paramObject1.hashCode();
    }
    int j = this.hashIndex.getHashIndex(i);
    int k = this.hashIndex.hashTable[j];
    int m = -1;
    Object localObject = null;
    while ((k >= 0) && (this.isObjectKey ? this.objectKeyTable[k].equals(paramObject1) : this.isIntKey ? paramLong1 == this.intKeyTable[k] : (!this.isLongKey) || (paramLong1 != this.longKeyTable[k])))
    {
      m = k;
      k = this.hashIndex.getNextLookup(k);
    }
    if (k >= 0)
    {
      if (paramBoolean)
      {
        if (this.isObjectKey)
        {
          this.objectKeyTable[k] = null;
        }
        else
        {
          if (paramLong1 == 0L)
          {
            this.hasZeroKey = false;
            this.zeroKeyIndex = -1;
          }
          if (this.isIntKey)
            this.intKeyTable[k] = 0;
          else
            this.longKeyTable[k] = 0L;
        }
        if (this.isObjectValue)
        {
          localObject = this.objectValueTable[k];
          this.objectValueTable[k] = null;
        }
        else if (this.isIntValue)
        {
          this.intValueTable[k] = 0;
        }
        else if (this.isLongValue)
        {
          this.longValueTable[k] = 0L;
        }
        this.hashIndex.unlinkNode(j, m, k);
        if (this.accessTable != null)
          this.accessTable[k] = 0;
        if ((this.minimizeOnEmpty) && (this.hashIndex.elementCount == 0))
          rehash(this.initialCapacity);
        return localObject;
      }
      if (this.isObjectValue)
      {
        localObject = this.objectValueTable[k];
        this.objectValueTable[k] = paramObject2;
      }
      else if (this.isIntValue)
      {
        this.intValueTable[k] = (int)paramLong2;
      }
      else if (this.isLongValue)
      {
        this.longValueTable[k] = paramLong2;
      }
      if (this.accessTable != null)
        this.accessTable[k] = (this.accessCount++);
      return localObject;
    }
    if (paramBoolean)
      return null;
    if (this.hashIndex.elementCount >= this.threshold)
    {
      if (reset())
        return addOrRemove(paramLong1, paramLong2, paramObject1, paramObject2, paramBoolean);
      return null;
    }
    k = this.hashIndex.linkNode(j, m);
    if (this.isObjectKey)
    {
      this.objectKeyTable[k] = paramObject1;
    }
    else if (this.isIntKey)
    {
      this.intKeyTable[k] = (int)paramLong1;
      if (paramLong1 == 0L)
      {
        this.hasZeroKey = true;
        this.zeroKeyIndex = k;
      }
    }
    else if (this.isLongKey)
    {
      this.longKeyTable[k] = paramLong1;
      if (paramLong1 == 0L)
      {
        this.hasZeroKey = true;
        this.zeroKeyIndex = k;
      }
    }
    if (this.isObjectValue)
      this.objectValueTable[k] = paramObject2;
    else if (this.isIntValue)
      this.intValueTable[k] = (int)paramLong2;
    else if (this.isLongValue)
      this.longValueTable[k] = paramLong2;
    if (this.accessTable != null)
      this.accessTable[k] = (this.accessCount++);
    return localObject;
  }

  protected Object addOrRemove(int paramInt, Object paramObject, boolean paramBoolean)
  {
    int i = paramInt;
    int j = this.hashIndex.getHashIndex(i);
    int k = this.hashIndex.hashTable[j];
    int m = -1;
    Object localObject = null;
    while ((k >= 0) && (paramInt != this.intKeyTable[k]))
    {
      m = k;
      k = this.hashIndex.getNextLookup(k);
    }
    if (k >= 0)
    {
      if (paramBoolean)
      {
        if (paramInt == 0)
        {
          this.hasZeroKey = false;
          this.zeroKeyIndex = -1;
        }
        this.intKeyTable[k] = 0;
        localObject = this.objectValueTable[k];
        this.objectValueTable[k] = null;
        this.hashIndex.unlinkNode(j, m, k);
        if (this.accessTable != null)
          this.accessTable[k] = 0;
        return localObject;
      }
      if (this.isObjectValue)
      {
        localObject = this.objectValueTable[k];
        this.objectValueTable[k] = paramObject;
      }
      if (this.accessTable != null)
        this.accessTable[k] = (this.accessCount++);
      return localObject;
    }
    if (paramBoolean)
      return localObject;
    if (this.hashIndex.elementCount >= this.threshold)
    {
      if (reset())
        return addOrRemove(paramInt, paramObject, paramBoolean);
      return null;
    }
    k = this.hashIndex.linkNode(j, m);
    this.intKeyTable[k] = paramInt;
    if (paramInt == 0)
    {
      this.hasZeroKey = true;
      this.zeroKeyIndex = k;
    }
    this.objectValueTable[k] = paramObject;
    if (this.accessTable != null)
      this.accessTable[k] = (this.accessCount++);
    return localObject;
  }

  protected Object removeObject(Object paramObject)
  {
    if (paramObject == null)
      return null;
    int i = paramObject.hashCode();
    int j = this.hashIndex.getHashIndex(i);
    int k = this.hashIndex.hashTable[j];
    int m = -1;
    Object localObject = null;
    while (k >= 0)
    {
      if (this.objectKeyTable[k].equals(paramObject))
      {
        this.objectKeyTable[k] = null;
        this.hashIndex.unlinkNode(j, m, k);
        if (this.isObjectValue)
        {
          localObject = this.objectValueTable[k];
          this.objectValueTable[k] = null;
        }
        return localObject;
      }
      m = k;
      k = this.hashIndex.getNextLookup(k);
    }
    return localObject;
  }

  protected boolean reset()
  {
    if ((this.maxCapacity == 0) || (this.maxCapacity > this.threshold))
    {
      rehash(this.hashIndex.hashTable.length * 2);
      return true;
    }
    if (this.purgePolicy == 1)
    {
      clear();
      return true;
    }
    if (this.purgePolicy == 3)
    {
      clear(this.threshold / 4, this.threshold >> 8);
      return true;
    }
    if (this.purgePolicy == 2)
    {
      clear(this.threshold / 2, this.threshold >> 8);
      return true;
    }
    return this.purgePolicy != 0;
  }

  protected void rehash(int paramInt)
  {
    int i = this.hashIndex.newNodePointer;
    boolean bool = this.hasZeroKey;
    int j = this.zeroKeyIndex;
    if (paramInt < this.hashIndex.elementCount)
      return;
    this.hashIndex.reset((int)(paramInt * this.loadFactor), paramInt);
    this.hasZeroKey = false;
    this.zeroKeyIndex = -1;
    this.threshold = paramInt;
    int k = -1;
    while ((k = nextLookup(k, i, bool, j)) < i)
    {
      long l1 = 0L;
      long l2 = 0L;
      Object localObject1 = null;
      Object localObject2 = null;
      if (this.isObjectKey)
        localObject1 = this.objectKeyTable[k];
      else if (this.isIntKey)
        l1 = this.intKeyTable[k];
      else
        l1 = this.longKeyTable[k];
      if (this.isObjectValue)
        localObject2 = this.objectValueTable[k];
      else if (this.isIntValue)
        l2 = this.intValueTable[k];
      else if (this.isLongValue)
        l2 = this.longValueTable[k];
      addOrRemove(l1, l2, localObject1, localObject2, false);
      if (this.accessTable == null)
        continue;
      this.accessTable[(this.hashIndex.elementCount - 1)] = this.accessTable[k];
    }
    resizeElementArrays(this.hashIndex.newNodePointer, paramInt);
  }

  private void resizeElementArrays(int paramInt1, int paramInt2)
  {
    int i = paramInt2 > paramInt1 ? paramInt1 : paramInt2;
    Object localObject;
    if (this.isIntKey)
    {
      localObject = this.intKeyTable;
      this.intKeyTable = new int[paramInt2];
      System.arraycopy(localObject, 0, this.intKeyTable, 0, i);
    }
    if (this.isIntValue)
    {
      localObject = this.intValueTable;
      this.intValueTable = new int[paramInt2];
      System.arraycopy(localObject, 0, this.intValueTable, 0, i);
    }
    if (this.isLongKey)
    {
      localObject = this.longKeyTable;
      this.longKeyTable = new long[paramInt2];
      System.arraycopy(localObject, 0, this.longKeyTable, 0, i);
    }
    if (this.isLongValue)
    {
      localObject = this.longValueTable;
      this.longValueTable = new long[paramInt2];
      System.arraycopy(localObject, 0, this.longValueTable, 0, i);
    }
    if (this.isObjectKey)
    {
      localObject = this.objectKeyTable;
      this.objectKeyTable = new Object[paramInt2];
      System.arraycopy(localObject, 0, this.objectKeyTable, 0, i);
    }
    if (this.isObjectValue)
    {
      localObject = this.objectValueTable;
      this.objectValueTable = new Object[paramInt2];
      System.arraycopy(localObject, 0, this.objectValueTable, 0, i);
    }
    if (this.accessTable != null)
    {
      localObject = this.accessTable;
      this.accessTable = new int[paramInt2];
      System.arraycopy(localObject, 0, this.accessTable, 0, i);
    }
  }

  private void clearElementArrays(int paramInt1, int paramInt2)
  {
    int i;
    if (this.isIntKey)
    {
      i = paramInt2;
      while (true)
      {
        i--;
        if (i < paramInt1)
          break;
        this.intKeyTable[i] = 0;
      }
    }
    if (this.isLongKey)
    {
      i = paramInt2;
      while (true)
      {
        i--;
        if (i < paramInt1)
          break;
        this.longKeyTable[i] = 0L;
      }
    }
    if (this.isObjectKey)
    {
      i = paramInt2;
      while (true)
      {
        i--;
        if (i < paramInt1)
          break;
        this.objectKeyTable[i] = null;
      }
    }
    if (this.isIntValue)
    {
      i = paramInt2;
      while (true)
      {
        i--;
        if (i < paramInt1)
          break;
        this.intValueTable[i] = 0;
      }
    }
    if (this.isLongValue)
    {
      i = paramInt2;
      while (true)
      {
        i--;
        if (i < paramInt1)
          break;
        this.longValueTable[i] = 0L;
      }
    }
    if (this.isObjectValue)
    {
      i = paramInt2;
      while (true)
      {
        i--;
        if (i < paramInt1)
          break;
        this.objectValueTable[i] = null;
      }
    }
    if (this.accessTable != null)
    {
      i = paramInt2;
      while (true)
      {
        i--;
        if (i < paramInt1)
          break;
        this.accessTable[i] = 0;
      }
    }
  }

  void removeFromElementArrays(int paramInt)
  {
    int i = this.hashIndex.linkTable.length;
    Object localObject;
    if (this.isIntKey)
    {
      localObject = this.intKeyTable;
      System.arraycopy(localObject, paramInt + 1, localObject, paramInt, i - paramInt - 1);
      this.intKeyTable[(i - 1)] = 0;
    }
    if (this.isLongKey)
    {
      localObject = this.longKeyTable;
      System.arraycopy(localObject, paramInt + 1, localObject, paramInt, i - paramInt - 1);
      this.longKeyTable[(i - 1)] = 0L;
    }
    if (this.isObjectKey)
    {
      localObject = this.objectKeyTable;
      System.arraycopy(localObject, paramInt + 1, localObject, paramInt, i - paramInt - 1);
      this.objectKeyTable[(i - 1)] = null;
    }
    if (this.isIntValue)
    {
      localObject = this.intValueTable;
      System.arraycopy(localObject, paramInt + 1, localObject, paramInt, i - paramInt - 1);
      this.intValueTable[(i - 1)] = 0;
    }
    if (this.isLongValue)
    {
      localObject = this.longValueTable;
      System.arraycopy(localObject, paramInt + 1, localObject, paramInt, i - paramInt - 1);
      this.longValueTable[(i - 1)] = 0L;
    }
    if (this.isObjectValue)
    {
      localObject = this.objectValueTable;
      System.arraycopy(localObject, paramInt + 1, localObject, paramInt, i - paramInt - 1);
      this.objectValueTable[(i - 1)] = null;
    }
  }

  int nextLookup(int paramInt1, int paramInt2, boolean paramBoolean, int paramInt3)
  {
    paramInt1++;
    while (paramInt1 < paramInt2)
    {
      if (this.isObjectKey)
      {
        if (this.objectKeyTable[paramInt1] != null)
          return paramInt1;
      }
      else if (this.isIntKey)
      {
        if (this.intKeyTable[paramInt1] != 0)
          return paramInt1;
        if ((paramBoolean) && (paramInt1 == paramInt3))
          return paramInt1;
      }
      else
      {
        if (this.longKeyTable[paramInt1] != 0L)
          return paramInt1;
        if ((paramBoolean) && (paramInt1 == paramInt3))
          return paramInt1;
      }
      paramInt1++;
    }
    return paramInt1;
  }

  protected int nextLookup(int paramInt)
  {
    paramInt++;
    while (paramInt < this.hashIndex.newNodePointer)
    {
      if (this.isObjectKey)
      {
        if (this.objectKeyTable[paramInt] != null)
          return paramInt;
      }
      else if (this.isIntKey)
      {
        if (this.intKeyTable[paramInt] != 0)
          return paramInt;
        if ((this.hasZeroKey) && (paramInt == this.zeroKeyIndex))
          return paramInt;
      }
      else
      {
        if (this.longKeyTable[paramInt] != 0L)
          return paramInt;
        if ((this.hasZeroKey) && (paramInt == this.zeroKeyIndex))
          return paramInt;
      }
      paramInt++;
    }
    return paramInt;
  }

  protected void removeRow(int paramInt)
  {
    this.hashIndex.removeEmptyNode(paramInt);
    removeFromElementArrays(paramInt);
  }

  protected Object removeLookup(int paramInt)
  {
    if (this.isObjectKey)
      return addOrRemove(0L, 0L, this.objectKeyTable[paramInt], null, true);
    return addOrRemove(this.intKeyTable[paramInt], 0L, null, null, true);
  }

  public void clear()
  {
    this.accessCount = 0;
    this.accessMin = this.accessCount;
    this.hasZeroKey = false;
    this.zeroKeyIndex = -1;
    clearElementArrays(0, this.hashIndex.linkTable.length);
    this.hashIndex.clear();
    if (this.minimizeOnEmpty)
      rehash(this.initialCapacity);
  }

  protected int getAccessCountCeiling(int paramInt1, int paramInt2)
  {
    return ArrayCounter.rank(this.accessTable, this.hashIndex.newNodePointer, paramInt1, this.accessMin + 1, this.accessCount, paramInt2);
  }

  protected void clear(int paramInt1, int paramInt2)
  {
    if (paramInt2 < 64)
      paramInt2 = 64;
    int i = this.hashIndex.newNodePointer;
    int j = getAccessCountCeiling(paramInt1, paramInt2);
    for (int k = 0; k < i; k++)
    {
      Object localObject = this.objectKeyTable[k];
      if ((localObject == null) || (this.accessTable[k] >= j))
        continue;
      removeObject(localObject);
    }
    this.accessMin = j;
  }

  void resetAccessCount()
  {
    if (this.accessCount < 2147483647)
      return;
    this.accessMin >>= 2;
    this.accessCount >>= 2;
    int i = this.accessTable.length;
    while (true)
    {
      i--;
      if (i < 0)
        break;
      this.accessTable[i] >>= 2;
    }
  }

  public int size()
  {
    return this.hashIndex.elementCount;
  }

  public boolean isEmpty()
  {
    return this.hashIndex.elementCount == 0;
  }

  protected boolean containsKey(Object paramObject)
  {
    if (paramObject == null)
      return false;
    int i = getLookup(paramObject, paramObject.hashCode());
    return i != -1;
  }

  protected boolean containsKey(int paramInt)
  {
    int i = getLookup(paramInt);
    return i != -1;
  }

  protected boolean containsKey(long paramLong)
  {
    int i = getLookup(paramLong);
    return i != -1;
  }

  protected boolean containsValue(Object paramObject)
  {
    int i = 0;
    if (paramObject == null)
      while (i < this.hashIndex.newNodePointer)
      {
        if (this.objectValueTable[i] == null)
          if (this.isObjectKey)
          {
            if (this.objectKeyTable[i] != null)
              return true;
          }
          else if (this.isIntKey)
          {
            if (this.intKeyTable[i] != 0)
              return true;
            if ((this.hasZeroKey) && (i == this.zeroKeyIndex))
              return true;
          }
          else
          {
            if (this.longKeyTable[i] != 0L)
              return true;
            if ((this.hasZeroKey) && (i == this.zeroKeyIndex))
              return true;
          }
        i++;
      }
    while (i < this.hashIndex.newNodePointer)
    {
      if (paramObject.equals(this.objectValueTable[i]))
        return true;
      i++;
    }
    return false;
  }

  protected class BaseHashIterator
    implements Iterator
  {
    boolean keys;
    int lookup = -1;
    int counter;
    boolean removed;

    public BaseHashIterator()
    {
    }

    public BaseHashIterator(boolean arg2)
    {
      boolean bool;
      this.keys = bool;
    }

    public boolean hasNext()
    {
      return this.counter < BaseHashMap.this.hashIndex.elementCount;
    }

    public Object next()
      throws NoSuchElementException
    {
      if (((this.keys) && (!BaseHashMap.this.isObjectKey)) || ((!this.keys) && (!BaseHashMap.this.isObjectValue)))
        throw new NoSuchElementException("Hash Iterator");
      this.removed = false;
      if (hasNext())
      {
        this.counter += 1;
        this.lookup = BaseHashMap.this.nextLookup(this.lookup);
        if (this.keys)
          return BaseHashMap.this.objectKeyTable[this.lookup];
        return BaseHashMap.this.objectValueTable[this.lookup];
      }
      throw new NoSuchElementException("Hash Iterator");
    }

    public int nextInt()
      throws NoSuchElementException
    {
      if (((this.keys) && (!BaseHashMap.this.isIntKey)) || ((!this.keys) && (!BaseHashMap.this.isIntValue)))
        throw new NoSuchElementException("Hash Iterator");
      this.removed = false;
      if (hasNext())
      {
        this.counter += 1;
        this.lookup = BaseHashMap.this.nextLookup(this.lookup);
        if (this.keys)
          return BaseHashMap.this.intKeyTable[this.lookup];
        return BaseHashMap.this.intValueTable[this.lookup];
      }
      throw new NoSuchElementException("Hash Iterator");
    }

    public long nextLong()
      throws NoSuchElementException
    {
      if ((!BaseHashMap.this.isLongKey) || (!this.keys))
        throw new NoSuchElementException("Hash Iterator");
      this.removed = false;
      if (hasNext())
      {
        this.counter += 1;
        this.lookup = BaseHashMap.this.nextLookup(this.lookup);
        if (this.keys)
          return BaseHashMap.this.longKeyTable[this.lookup];
        return BaseHashMap.this.longValueTable[this.lookup];
      }
      throw new NoSuchElementException("Hash Iterator");
    }

    public void remove()
      throws NoSuchElementException
    {
      if (this.removed)
        throw new NoSuchElementException("Hash Iterator");
      this.counter -= 1;
      this.removed = true;
      BaseHashMap.this.removeLookup(this.lookup);
    }

    public int getAccessCount()
    {
      if ((this.removed) || (BaseHashMap.this.accessTable == null))
        throw new NoSuchElementException();
      return BaseHashMap.this.accessTable[this.lookup];
    }
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.hsqldb.store.BaseHashMap
 * JD-Core Version:    0.6.0
 */