package org.hsqldb.scriptio;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.Result;
import org.hsqldb.SchemaManager;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.Trace;
import org.hsqldb.lib.FileAccess;
import org.hsqldb.lib.SimpleLog;
import org.hsqldb.lib.StringConverter;
import org.hsqldb.persist.Logger;
import org.hsqldb.rowio.RowInputTextLog;

public class ScriptReaderText extends ScriptReaderBase
{
  BufferedReader dataStreamIn;
  RowInputTextLog rowIn = new RowInputTextLog();
  boolean isInsert;

  ScriptReaderText(Database paramDatabase, String paramString)
    throws HsqlException, IOException
  {
    super(paramDatabase, paramString);
  }

  protected void openFile()
    throws IOException
  {
    InputStream localInputStream = this.db.isFilesInJar() ? getClass().getResourceAsStream(this.fileName) : this.db.getFileAccess().openInputStreamElement(this.fileName);
    this.dataStreamIn = new BufferedReader(new InputStreamReader(new BufferedInputStream(localInputStream)));
  }

  protected void readDDL(Session paramSession)
    throws IOException, HsqlException
  {
    while (readLoggedStatement(paramSession))
      if (this.rowIn.getStatementType() == 3)
      {
        this.isInsert = true;
      }
      else
      {
        Result localResult = paramSession.sqlExecuteDirectNoPreChecks(this.statement);
        if ((localResult == null) || (!localResult.isError()))
          continue;
        this.db.logger.appLog.logContext(SimpleLog.LOG_ERROR, localResult.getMainString());
        HsqlException localHsqlException = Trace.error(78, 113, new Object[] { new Integer(this.lineCount), localResult.getMainString() });
        throw localHsqlException;
      }
  }

  protected void readExistingData(Session paramSession)
    throws IOException, HsqlException
  {
    try
    {
      Object localObject = null;
      this.db.setReferentialIntegrity(false);
      while ((this.isInsert) || (readLoggedStatement(paramSession)))
      {
        if (this.statementType == 7)
        {
          paramSession.setSchema(this.currentSchema);
        }
        else if (this.statementType == 3)
        {
          if (!this.rowIn.getTableName().equals(localObject))
          {
            localObject = this.rowIn.getTableName();
            String str = paramSession.getSchemaName(this.currentSchema);
            this.currentTable = this.db.schemaManager.getUserTable(paramSession, (String)localObject, str);
          }
          this.currentTable.insertFromScript(this.rowData);
        }
        this.isInsert = false;
      }
      this.db.setReferentialIntegrity(true);
    }
    catch (Exception localException)
    {
      this.db.logger.appLog.logContext(localException, null);
      throw Trace.error(78, 114, new Object[] { new Integer(this.lineCount), localException.toString() });
    }
  }

  public boolean readLoggedStatement(Session paramSession)
    throws IOException
  {
    String str = this.dataStreamIn.readLine();
    this.lineCount += 1;
    this.statement = StringConverter.asciiToUnicode(str);
    if (this.statement == null)
      return false;
    processStatement(paramSession);
    return true;
  }

  private void processStatement(Session paramSession)
    throws IOException
  {
    try
    {
      if (this.statement.startsWith("/*C"))
      {
        int i = this.statement.indexOf('*', 4);
        this.sessionNumber = Integer.parseInt(this.statement.substring(3, i));
        this.statement = this.statement.substring(i + 2);
      }
      this.rowIn.setSource(this.statement);
      this.statementType = this.rowIn.getStatementType();
      if (this.statementType == 1)
      {
        this.rowData = null;
        this.currentTable = null;
        return;
      }
      if (this.statementType == 5)
      {
        this.rowData = null;
        this.currentTable = null;
        return;
      }
      if (this.statementType == 7)
      {
        this.rowData = null;
        this.currentTable = null;
        this.currentSchema = this.rowIn.getSchemaName();
        return;
      }
      String str1 = this.rowIn.getTableName();
      String str2 = paramSession.getSchemaName(null);
      this.currentTable = this.db.schemaManager.getUserTable(paramSession, str1, str2);
      int[] arrayOfInt;
      if (this.statementType == 3)
        arrayOfInt = this.currentTable.getColumnTypes();
      else if (this.currentTable.hasPrimaryKey())
        arrayOfInt = this.currentTable.getPrimaryKeyTypes();
      else
        arrayOfInt = this.currentTable.getColumnTypes();
      this.rowData = this.rowIn.readData(arrayOfInt);
    }
    catch (Exception localException)
    {
      throw new IOException(localException.toString());
    }
  }

  public void close()
  {
    try
    {
      this.dataStreamIn.close();
    }
    catch (Exception localException)
    {
    }
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.hsqldb.scriptio.ScriptReaderText
 * JD-Core Version:    0.6.0
 */