package org.hsqldb.rowio;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.hsqldb.Column;
import org.hsqldb.HsqlNameManager.HsqlName;
import org.hsqldb.Table;
import org.hsqldb.Trace;
import org.hsqldb.Types;
import org.hsqldb.lib.HashMappedList;
import org.hsqldb.lib.HsqlByteArrayOutputStream;
import org.hsqldb.types.Binary;
import org.hsqldb.types.JavaObject;

public abstract class RowOutputBase extends HsqlByteArrayOutputStream
  implements RowOutputInterface
{
  public static final int CACHED_ROW_160 = 0;
  public static final int CACHED_ROW_170 = 1;
  protected boolean skipSystemId = false;

  public RowOutputBase()
  {
  }

  public RowOutputBase(int paramInt)
  {
    super(paramInt);
  }

  public RowOutputBase(byte[] paramArrayOfByte)
  {
    super(paramArrayOfByte);
  }

  public abstract void writeEnd();

  public abstract void writeSize(int paramInt);

  public abstract void writeType(int paramInt);

  public abstract void writeShortData(short paramShort);

  public abstract void writeIntData(int paramInt);

  public abstract void writeIntData(int paramInt1, int paramInt2);

  public abstract void writeString(String paramString);

  protected void writeFieldPrefix()
  {
  }

  protected abstract void writeFieldType(int paramInt);

  protected abstract void writeNull(int paramInt);

  protected abstract void writeChar(String paramString, int paramInt);

  protected abstract void writeSmallint(Number paramNumber);

  protected abstract void writeInteger(Number paramNumber);

  protected abstract void writeBigint(Number paramNumber);

  protected abstract void writeReal(Double paramDouble, int paramInt);

  protected abstract void writeDecimal(BigDecimal paramBigDecimal);

  protected abstract void writeBit(Boolean paramBoolean);

  protected abstract void writeDate(Date paramDate);

  protected abstract void writeTime(Time paramTime);

  protected abstract void writeTimestamp(Timestamp paramTimestamp);

  protected abstract void writeOther(JavaObject paramJavaObject);

  protected abstract void writeBinary(Binary paramBinary, int paramInt);

  public void writeRow(Object[] paramArrayOfObject, Table paramTable)
  {
    writeSize(0);
    writeData(paramArrayOfObject, paramTable);
    writeIntData(size(), 0);
  }

  public void writeData(Object[] paramArrayOfObject, Table paramTable)
  {
    int[] arrayOfInt = paramTable.getColumnTypes();
    int i = paramTable.getColumnCount();
    writeData(i, arrayOfInt, paramArrayOfObject, null, null);
  }

  public void writeData(int paramInt, int[] paramArrayOfInt1, Object[] paramArrayOfObject, HashMappedList paramHashMappedList, int[] paramArrayOfInt2)
  {
    int i = (paramArrayOfInt2 != null) && (paramArrayOfInt2.length != 0) ? 1 : 0;
    int j = i != 0 ? paramArrayOfInt2.length : paramInt;
    for (int k = 0; k < j; k++)
    {
      int m = i != 0 ? paramArrayOfInt2[k] : k;
      Object localObject = paramArrayOfObject[m];
      int n = paramArrayOfInt1[m];
      if (paramHashMappedList != null)
      {
        Column localColumn = (Column)paramHashMappedList.get(m);
        writeFieldPrefix();
        writeString(localColumn.columnName.statementName);
      }
      if (localObject == null)
      {
        writeNull(n);
      }
      else
      {
        writeFieldType(n);
        switch (n)
        {
        case -1:
        case 0:
        case 1:
        case 12:
        case 100:
          writeChar((String)localObject, n);
          break;
        case -6:
        case 5:
          writeSmallint((Number)localObject);
          break;
        case 4:
          writeInteger((Number)localObject);
          break;
        case -5:
          writeBigint((Number)localObject);
          break;
        case 6:
        case 7:
        case 8:
          writeReal((Double)localObject, n);
          break;
        case 2:
        case 3:
          writeDecimal((BigDecimal)localObject);
          break;
        case 16:
          writeBit((Boolean)localObject);
          break;
        case 91:
          writeDate((Date)localObject);
          break;
        case 92:
          writeTime((Time)localObject);
          break;
        case 93:
          writeTimestamp((Timestamp)localObject);
          break;
        case 1111:
          writeOther((JavaObject)localObject);
          break;
        case -4:
        case -3:
        case -2:
          writeBinary((Binary)localObject, n);
          break;
        default:
          throw Trace.runtimeError(20, Types.getTypeString(n));
        }
      }
    }
  }

  public HsqlByteArrayOutputStream getOutputStream()
  {
    return this;
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.hsqldb.rowio.RowOutputBase
 * JD-Core Version:    0.6.0
 */