package org.hsqldb.lib;

import java.util.NoSuchElementException;

public class HsqlDeque extends BaseList
  implements HsqlList
{
  private Object[] list = new Object[10];
  private int firstindex = 0;
  private int endindex = 0;
  private static final int DEFAULT_INITIAL_CAPACITY = 10;

  public int size()
  {
    return this.elementCount;
  }

  public Object getFirst()
    throws NoSuchElementException
  {
    if (this.elementCount == 0)
      throw new NoSuchElementException();
    return this.list[this.firstindex];
  }

  public Object getLast()
    throws NoSuchElementException
  {
    if (this.elementCount == 0)
      throw new NoSuchElementException();
    return this.list[(this.endindex - 1)];
  }

  public Object get(int paramInt)
    throws IndexOutOfBoundsException
  {
    int i = getInternalIndex(paramInt);
    return this.list[i];
  }

  public void add(int paramInt, Object paramObject)
    throws IndexOutOfBoundsException
  {
    throw new RuntimeException();
  }

  public Object set(int paramInt, Object paramObject)
    throws IndexOutOfBoundsException
  {
    int i = getInternalIndex(paramInt);
    Object localObject = this.list[i];
    this.list[i] = paramObject;
    return localObject;
  }

  public Object removeFirst()
    throws NoSuchElementException
  {
    if (this.elementCount == 0)
      throw new NoSuchElementException();
    Object localObject = this.list[this.firstindex];
    this.list[this.firstindex] = null;
    this.firstindex += 1;
    this.elementCount -= 1;
    if (this.elementCount == 0)
      this.firstindex = (this.endindex = 0);
    else if (this.firstindex == this.list.length)
      this.firstindex = 0;
    return localObject;
  }

  public Object removeLast()
    throws NoSuchElementException
  {
    if (this.elementCount == 0)
      throw new NoSuchElementException();
    this.endindex -= 1;
    Object localObject = this.list[this.endindex];
    this.list[this.endindex] = null;
    this.elementCount -= 1;
    if (this.elementCount == 0)
      this.firstindex = (this.endindex = 0);
    else if (this.endindex == 0)
      this.endindex = this.list.length;
    return localObject;
  }

  public boolean add(Object paramObject)
  {
    resetCapacity();
    if (this.endindex == this.list.length)
      this.endindex = 0;
    this.list[this.endindex] = paramObject;
    this.elementCount += 1;
    this.endindex += 1;
    return true;
  }

  public boolean addLast(Object paramObject)
  {
    return add(paramObject);
  }

  public boolean addFirst(Object paramObject)
  {
    resetCapacity();
    this.firstindex -= 1;
    if (this.firstindex < 0)
    {
      this.firstindex = (this.list.length - 1);
      if (this.endindex == 0)
        this.endindex = this.list.length;
    }
    this.list[this.firstindex] = paramObject;
    this.elementCount += 1;
    return true;
  }

  public void clear()
  {
    this.firstindex = (this.endindex = this.elementCount = 0);
    for (int i = 0; i < this.list.length; i++)
      this.list[i] = null;
  }

  public Object remove(int paramInt)
  {
    int i = getInternalIndex(paramInt);
    Object localObject = this.list[i];
    if (i >= this.firstindex)
    {
      System.arraycopy(this.list, this.firstindex, this.list, this.firstindex + 1, i - this.firstindex);
      this.list[this.firstindex] = null;
      this.firstindex += 1;
      if (this.firstindex == this.list.length)
        this.firstindex = 0;
    }
    else
    {
      System.arraycopy(this.list, i + 1, this.list, i, this.endindex - i - 1);
      this.list[this.endindex] = null;
      this.endindex -= 1;
      if (this.endindex == 0)
        this.endindex = this.list.length;
    }
    if (this.elementCount == 0)
      this.firstindex = (this.endindex = 0);
    return localObject;
  }

  private int getInternalIndex(int paramInt)
    throws IndexOutOfBoundsException
  {
    if ((paramInt < 0) || (paramInt >= this.elementCount))
      throw new IndexOutOfBoundsException();
    int i = this.firstindex + paramInt;
    if (i >= this.list.length)
      i -= this.list.length;
    return i;
  }

  private void resetCapacity()
  {
    if (this.elementCount < this.list.length)
      return;
    Object[] arrayOfObject = new Object[this.list.length * 2];
    for (int i = 0; i < this.list.length; i++)
      arrayOfObject[i] = this.list[i];
    this.list = arrayOfObject;
    arrayOfObject = null;
    if (this.endindex <= this.firstindex)
    {
      i = this.firstindex + this.elementCount - this.endindex;
      for (int j = 0; j < this.endindex; j++)
      {
        this.list[(i + j)] = this.list[j];
        this.list[j] = null;
      }
      this.endindex = (this.firstindex + this.elementCount);
    }
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.hsqldb.lib.HsqlDeque
 * JD-Core Version:    0.6.0
 */