package org.hsqldb.lib;

import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UTFDataFormatException;
import java.io.UnsupportedEncodingException;

public class HsqlByteArrayOutputStream extends OutputStream
  implements DataOutput
{
  protected byte[] buf;
  protected int count;

  public HsqlByteArrayOutputStream()
  {
    this(128);
  }

  public HsqlByteArrayOutputStream(int paramInt)
  {
    if (paramInt < 128)
      paramInt = 128;
    this.buf = new byte[paramInt];
  }

  public HsqlByteArrayOutputStream(byte[] paramArrayOfByte)
  {
    this.buf = paramArrayOfByte;
  }

  public final void writeShort(int paramInt)
  {
    ensureRoom(2);
    this.buf[(this.count++)] = (byte)(paramInt >>> 8);
    this.buf[(this.count++)] = (byte)paramInt;
  }

  public final void writeInt(int paramInt)
  {
    if (this.count + 4 > this.buf.length)
      ensureRoom(4);
    this.buf[(this.count++)] = (byte)(paramInt >>> 24);
    this.buf[(this.count++)] = (byte)(paramInt >>> 16);
    this.buf[(this.count++)] = (byte)(paramInt >>> 8);
    this.buf[(this.count++)] = (byte)paramInt;
  }

  public final void writeLong(long paramLong)
  {
    writeInt((int)(paramLong >>> 32));
    writeInt((int)paramLong);
  }

  public final void writeBytes(String paramString)
  {
    int i = paramString.length();
    ensureRoom(i);
    for (int j = 0; j < i; j++)
      this.buf[(this.count++)] = (byte)paramString.charAt(j);
  }

  public final void writeFloat(float paramFloat)
  {
    writeInt(Float.floatToIntBits(paramFloat));
  }

  public final void writeDouble(double paramDouble)
  {
    writeLong(Double.doubleToLongBits(paramDouble));
  }

  public void writeBoolean(boolean paramBoolean)
    throws IOException
  {
    ensureRoom(1);
    this.buf[(this.count++)] = (byte)(paramBoolean ? 1 : 0);
  }

  public void writeByte(int paramInt)
    throws IOException
  {
    ensureRoom(1);
    this.buf[(this.count++)] = (byte)paramInt;
  }

  public void writeChar(int paramInt)
    throws IOException
  {
    ensureRoom(2);
    this.buf[(this.count++)] = (byte)(paramInt >>> 8);
    this.buf[(this.count++)] = (byte)paramInt;
  }

  public void writeChars(String paramString)
    throws IOException
  {
    int i = paramString.length();
    ensureRoom(i * 2);
    for (int j = 0; j < i; j++)
    {
      int k = paramString.charAt(j);
      this.buf[(this.count++)] = (byte)(k >>> 8);
      this.buf[(this.count++)] = (byte)k;
    }
  }

  public void writeUTF(String paramString)
    throws IOException
  {
    int i = paramString.length();
    if (i > 65535)
      throw new UTFDataFormatException();
    ensureRoom(i * 3 + 2);
    int j = this.count;
    this.count += 2;
    StringConverter.writeUTF(paramString, this);
    int k = this.count - j - 2;
    if (k > 65535)
    {
      this.count = j;
      throw new UTFDataFormatException();
    }
    this.buf[(j++)] = (byte)(k >>> 8);
    this.buf[j] = (byte)k;
  }

  public void flush()
    throws IOException
  {
    super.flush();
  }

  public void write(int paramInt)
  {
    ensureRoom(1);
    this.buf[(this.count++)] = (byte)paramInt;
  }

  public void write(byte[] paramArrayOfByte)
  {
    write(paramArrayOfByte, 0, paramArrayOfByte.length);
  }

  public void write(byte[] paramArrayOfByte, int paramInt1, int paramInt2)
  {
    ensureRoom(paramInt2);
    System.arraycopy(paramArrayOfByte, paramInt1, this.buf, this.count, paramInt2);
    this.count += paramInt2;
  }

  public void writeTo(OutputStream paramOutputStream)
    throws IOException
  {
    paramOutputStream.write(this.buf, 0, this.count);
  }

  public void reset()
  {
    this.count = 0;
  }

  public byte[] toByteArray()
  {
    byte[] arrayOfByte = new byte[this.count];
    System.arraycopy(this.buf, 0, arrayOfByte, 0, this.count);
    return arrayOfByte;
  }

  public int size()
  {
    return this.count;
  }

  public String toString()
  {
    return new String(this.buf, 0, this.count);
  }

  public String toString(String paramString)
    throws UnsupportedEncodingException
  {
    return new String(this.buf, 0, this.count, paramString);
  }

  public void close()
    throws IOException
  {
  }

  public void fill(int paramInt1, int paramInt2)
  {
    ensureRoom(paramInt2);
    for (int i = 0; i < paramInt2; i++)
      this.buf[(this.count++)] = (byte)paramInt1;
  }

  public byte[] getBuffer()
  {
    return this.buf;
  }

  protected void ensureRoom(int paramInt)
  {
    int i = this.count + paramInt;
    int j = this.buf.length;
    if (i > j)
    {
      while (i > j)
        j *= 2;
      byte[] arrayOfByte = new byte[j];
      System.arraycopy(this.buf, 0, arrayOfByte, 0, this.count);
      this.buf = arrayOfByte;
    }
  }

  protected void reset(int paramInt)
  {
    this.count = 0;
    if (paramInt > this.buf.length)
      this.buf = new byte[paramInt];
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.hsqldb.lib.HsqlByteArrayOutputStream
 * JD-Core Version:    0.6.0
 */