package org.hsqldb.lib;

public class HashMappedList extends HashMap
{
  public HashMappedList()
  {
    this(16, 0.75F);
  }

  public HashMappedList(int paramInt)
    throws IllegalArgumentException
  {
    this(paramInt, 0.75F);
  }

  public HashMappedList(int paramInt, float paramFloat)
    throws IllegalArgumentException
  {
    super(paramInt, paramFloat);
  }

  public Object get(int paramInt)
    throws IndexOutOfBoundsException
  {
    checkRange(paramInt);
    return this.objectValueTable[paramInt];
  }

  public Object remove(Object paramObject)
  {
    int i = getLookup(paramObject, paramObject.hashCode());
    if (i < 0)
      return null;
    Object localObject = super.remove(paramObject);
    removeRow(i);
    return localObject;
  }

  public Object remove(int paramInt)
    throws IndexOutOfBoundsException
  {
    checkRange(paramInt);
    return remove(this.objectKeyTable[paramInt]);
  }

  public boolean add(Object paramObject1, Object paramObject2)
  {
    if (keySet().contains(paramObject1))
      return false;
    super.put(paramObject1, paramObject2);
    return true;
  }

  public Object put(Object paramObject1, Object paramObject2)
  {
    return super.put(paramObject1, paramObject2);
  }

  public Object set(int paramInt, Object paramObject)
    throws IndexOutOfBoundsException
  {
    checkRange(paramInt);
    Object localObject = this.objectKeyTable[paramInt];
    this.objectKeyTable[paramInt] = paramObject;
    return localObject;
  }

  public boolean insert(int paramInt, Object paramObject1, Object paramObject2)
    throws IndexOutOfBoundsException
  {
    if ((paramInt < 0) || (paramInt > size()))
      throw new IndexOutOfBoundsException();
    if (keySet().contains(paramObject1))
      return false;
    if (paramInt == size())
      return add(paramObject1, paramObject2);
    HashMappedList localHashMappedList = new HashMappedList(size());
    for (int i = paramInt; i < size(); i++)
      localHashMappedList.add(getKey(i), get(i));
    for (i = size() - 1; i >= paramInt; i--)
      remove(i);
    for (i = 0; i < localHashMappedList.size(); i++)
      add(localHashMappedList.getKey(i), localHashMappedList.get(i));
    return true;
  }

  public boolean set(int paramInt, Object paramObject1, Object paramObject2)
    throws IndexOutOfBoundsException
  {
    checkRange(paramInt);
    if ((keySet().contains(paramObject1)) && (getIndex(paramObject1) != paramInt))
      return false;
    super.remove(this.objectKeyTable[paramInt]);
    super.put(paramObject1, paramObject2);
    return true;
  }

  public boolean setKey(int paramInt, Object paramObject)
    throws IndexOutOfBoundsException
  {
    checkRange(paramInt);
    Object localObject = this.objectValueTable[paramInt];
    return set(paramInt, paramObject, localObject);
  }

  public Object getKey(int paramInt)
    throws IndexOutOfBoundsException
  {
    checkRange(paramInt);
    return this.objectKeyTable[paramInt];
  }

  public int getIndex(Object paramObject)
  {
    return getLookup(paramObject, paramObject.hashCode());
  }

  private void checkRange(int paramInt)
  {
    if ((paramInt < 0) || (paramInt >= size()))
      throw new IndexOutOfBoundsException();
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.hsqldb.lib.HashMappedList
 * JD-Core Version:    0.6.0
 */