package org.hsqldb;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Properties;
import org.hsqldb.jdbc.jdbcConnection;
import org.hsqldb.persist.HsqlProperties;

public class jdbcDriver
  implements Driver
{
  public Connection connect(String paramString, Properties paramProperties)
    throws SQLException
  {
    return getConnection(paramString, paramProperties);
  }

  public static Connection getConnection(String paramString, Properties paramProperties)
    throws SQLException
  {
    HsqlProperties localHsqlProperties = DatabaseURL.parseURL(paramString, true);
    if (localHsqlProperties == null)
      throw new SQLException(Trace.getMessage(62));
    if (localHsqlProperties.isEmpty())
      return null;
    localHsqlProperties.addProperties(paramProperties);
    return new jdbcConnection(localHsqlProperties);
  }

  public boolean acceptsURL(String paramString)
  {
    return (paramString != null) && (paramString.regionMatches(true, 0, "jdbc:hsqldb:", 0, "jdbc:hsqldb:".length()));
  }

  public DriverPropertyInfo[] getPropertyInfo(String paramString, Properties paramProperties)
  {
    String[] arrayOfString = { "true", "false" };
    DriverPropertyInfo[] arrayOfDriverPropertyInfo = new DriverPropertyInfo[6];
    DriverPropertyInfo localDriverPropertyInfo = new DriverPropertyInfo("user", null);
    localDriverPropertyInfo.value = paramProperties.getProperty("user");
    localDriverPropertyInfo.required = true;
    arrayOfDriverPropertyInfo[0] = localDriverPropertyInfo;
    localDriverPropertyInfo = new DriverPropertyInfo("password", null);
    localDriverPropertyInfo.value = paramProperties.getProperty("password");
    localDriverPropertyInfo.required = true;
    arrayOfDriverPropertyInfo[1] = localDriverPropertyInfo;
    localDriverPropertyInfo = new DriverPropertyInfo("get_column_name", null);
    localDriverPropertyInfo.value = paramProperties.getProperty("get_column_name", "true");
    localDriverPropertyInfo.required = false;
    localDriverPropertyInfo.choices = arrayOfString;
    arrayOfDriverPropertyInfo[2] = localDriverPropertyInfo;
    localDriverPropertyInfo = new DriverPropertyInfo("ifexists", null);
    localDriverPropertyInfo.value = paramProperties.getProperty("ifexists");
    localDriverPropertyInfo.required = false;
    localDriverPropertyInfo.choices = arrayOfString;
    arrayOfDriverPropertyInfo[3] = localDriverPropertyInfo;
    localDriverPropertyInfo = new DriverPropertyInfo("default_schema", null);
    localDriverPropertyInfo.value = paramProperties.getProperty("default_schema");
    localDriverPropertyInfo.required = false;
    localDriverPropertyInfo.choices = arrayOfString;
    arrayOfDriverPropertyInfo[4] = localDriverPropertyInfo;
    localDriverPropertyInfo = new DriverPropertyInfo("shutdown", null);
    localDriverPropertyInfo.value = paramProperties.getProperty("shutdown");
    localDriverPropertyInfo.required = false;
    localDriverPropertyInfo.choices = arrayOfString;
    arrayOfDriverPropertyInfo[5] = localDriverPropertyInfo;
    return arrayOfDriverPropertyInfo;
  }

  public int getMajorVersion()
  {
    return 1;
  }

  public int getMinorVersion()
  {
    return 8;
  }

  public boolean jdbcCompliant()
  {
    return false;
  }

  static
  {
    try
    {
      DriverManager.registerDriver(new jdbcDriver());
    }
    catch (Exception localException)
    {
    }
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.hsqldb.jdbcDriver
 * JD-Core Version:    0.6.0
 */