package org.hsqldb;

import org.hsqldb.lib.HashMappedList;
import org.hsqldb.lib.ObjectComparator;

class SubQuery
  implements ObjectComparator
{
  int level;
  boolean hasParams;
  boolean isResolved;
  boolean isExistsPredicate;
  boolean uniqueRows;
  Select select;
  Table table;
  View view;
  boolean isMaterialised;

  void populateTable(Session paramSession)
    throws HsqlException
  {
    Result localResult = this.select.getResult(paramSession, this.isExistsPredicate ? 1 : 0);
    if (this.uniqueRows)
      localResult.removeDuplicates(paramSession, this.select.iResultLen);
    this.table.insertResult(paramSession, localResult);
  }

  public int compare(Object paramObject1, Object paramObject2)
  {
    SubQuery localSubQuery1 = (SubQuery)paramObject1;
    SubQuery localSubQuery2 = (SubQuery)paramObject2;
    if ((localSubQuery1.view == null) && (localSubQuery2.view == null))
      return localSubQuery2.level - localSubQuery1.level;
    if ((localSubQuery1.view != null) && (localSubQuery2.view != null))
    {
      Database localDatabase = localSubQuery1.view.database;
      int i = localDatabase.schemaManager.getTableIndex(localSubQuery1.view);
      int j = localDatabase.schemaManager.getTableIndex(localSubQuery2.view);
      if (i == -1)
        i = localDatabase.schemaManager.getTables(localSubQuery1.view.getSchemaName()).size();
      if (j == -1)
        j = localDatabase.schemaManager.getTables(localSubQuery2.view.getSchemaName()).size();
      int k = i - j;
      return k == 0 ? localSubQuery2.level - localSubQuery1.level : k;
    }
    return localSubQuery1.view == null ? 1 : -1;
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.hsqldb.SubQuery
 * JD-Core Version:    0.6.0
 */