package org.hsqldb;

import org.hsqldb.lib.IntLookup;
import org.hsqldb.lib.java.JavaSystem;
import org.hsqldb.persist.CachedObject;
import org.hsqldb.rowio.RowOutputInterface;

public class Row
  implements CachedObject
{
  int tableId;
  int iPos;
  protected Object[] oData;
  protected Node nPrimaryNode;

  protected Row()
  {
  }

  Row(Table paramTable, Object[] paramArrayOfObject)
    throws HsqlException
  {
    int i = paramTable.getIndexCount();
    this.nPrimaryNode = Node.newNode(this, 0, paramTable);
    Node localNode = this.nPrimaryNode;
    for (int j = 1; j < i; j++)
    {
      localNode.nNext = Node.newNode(this, j, paramTable);
      localNode = localNode.nNext;
    }
    this.tableId = paramTable.getId();
    this.oData = paramArrayOfObject;
  }

  Node getNode(int paramInt)
  {
    for (Node localNode = this.nPrimaryNode; paramInt-- > 0; localNode = localNode.nNext);
    return localNode;
  }

  Node getNextNode(Node paramNode)
  {
    if (paramNode == null)
      paramNode = this.nPrimaryNode;
    else
      paramNode = paramNode.nNext;
    return paramNode;
  }

  Row getUpdatedRow()
    throws HsqlException
  {
    return this;
  }

  public Object[] getData()
  {
    return this.oData;
  }

  void delete()
    throws HsqlException
  {
    JavaSystem.memoryRecords += 1;
    this.nPrimaryNode = null;
  }

  void clearNodeLinks()
  {
    Node localNode;
    for (Object localObject = this.nPrimaryNode; ((Node)localObject).nNext != null; localObject = localNode)
    {
      localNode = ((Node)localObject).nNext;
      ((Node)localObject).nNext = null;
    }
    this.nPrimaryNode = null;
  }

  boolean isCascadeDeleted()
  {
    return this.nPrimaryNode == null;
  }

  public int getRealSize(RowOutputInterface paramRowOutputInterface)
  {
    return 0;
  }

  public void setStorageSize(int paramInt)
  {
  }

  public int getStorageSize()
  {
    return 0;
  }

  public long getId()
  {
    return (this.tableId << 32) + this.iPos;
  }

  public static long getId(Table paramTable, int paramInt)
  {
    return (paramTable.getId() << 32) + paramInt;
  }

  public int getPos()
  {
    return this.iPos;
  }

  public void setPos(int paramInt)
  {
    this.iPos = paramInt;
  }

  public boolean hasChanged()
  {
    return false;
  }

  public boolean isKeepInMemory()
  {
    return true;
  }

  public void keepInMemory(boolean paramBoolean)
  {
  }

  public boolean isInMemory()
  {
    return true;
  }

  public void setInMemory(boolean paramBoolean)
  {
  }

  public void write(RowOutputInterface paramRowOutputInterface)
  {
  }

  public void write(RowOutputInterface paramRowOutputInterface, IntLookup paramIntLookup)
  {
  }

  public boolean equals(Object paramObject)
  {
    if (paramObject == this)
      return true;
    if ((paramObject instanceof Row))
      return ((Row)paramObject).iPos == this.iPos;
    return false;
  }

  public int hashCode()
  {
    return this.iPos;
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.hsqldb.Row
 * JD-Core Version:    0.6.0
 */